<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Permissions

                    <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(Session::has($key)): ?>
                    <p class="alert alert-<?php echo e($key); ?> alert-msg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;<?php echo e(Session::get($key)); ?></p>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add permissions')): ?>
                <div class="col-md-12" style="margin:10px 0;">
                    <a href="<?php echo e(route('permissions.create')); ?>" class="btn btn-default"><i class="glyphicon glyphicon-plus"></i> Create</a>
                    <button type="button" id="deleteBtn" class="float-right btn btn-default" data-toggle="modal" data-target="#deleteModal" disabled><i class="fa fa-trash" aria-hidden="true"></i></button>
                </div>
                <?php endif; ?>

                <div class="panel-body">

                    <table id="permission-tbl" class="display table-bordered dt-responsive">
                        <thead>
                            <tr>
                                <th>
                                    <input id="multi-all" class="dt-check" type="checkbox">
                                    <label for="multi-all">
                                        <span></span>
                                    </label>
                                </th>
                                <th>Permission Name</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>

                    <table id="filter-temp-tbl">
                        <thead>
                            <tr></tr>
                        </thead>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="deleteModal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-trash" aria-hidden="true"></i> Delete this permission?</h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Are you sure, you want to delete the selected permission?</p>
            </div>
            <div class="modal-footer">
                <button type="button" id="confirmDel" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_script'); ?>
<script type="text/javascript">
    $(document).ready(function() {

        $("#accordion").accordion({
            collapsible: true,
            active: false
        });

        $('#permission-tbl tr').clone(true).appendTo('#filter-temp-tbl thead');
        $('#filter-temp-tbl thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (permission_tbl.column(i).search() !== this.value) {
                    permission_tbl
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });

        $("#deleteBtn").click(function() {
            var chk_doc_ids = $('.dt-check:checked:not(#multi-all)').map(function() {
                return $(this).val();
            }).get();

            if (chk_doc_ids > 0) {
                $("#modal-body").html("<p>Are you sure, you want to delete the selected document?</p>");
            } else {
                $("#modal-body").html("<p>Are you sure, you want to delete the selected documents?</p>");
            }
        });

        $("#confirmDel").click(function() {

            var chk_doc_ids = $('.dt-check:checked:not(#multi-all)').map(function() {
                return $(this).val();
            }).get();

            $.ajax({
                url: "<?php echo e(route('permission_list.multiple-delete')); ?>",
                type: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id: chk_doc_ids
                },
                success: function(result) {
                    $(".dt-check:checked").each(function() {
                        $(this).parents("tr").remove();
                    });
                    $(".panel-heading").append('<p class="alert alert-success alert-msg"><i class="fa fa-trash" aria-hidden="true"></i>&nbsp;Permission(s) deleted successfully.</p>');
                    $(".alert-msg").fadeOut(5500, function() {
                        $(this).remove();
                    });
                }
            });

            var x$;
            x$ = $(this).data('action');
            $('#multi-form').attr('action', $('#multi-form').data('action') + x$);
            $('#multi-val').val(JSON.stringify({
                action: x$,
                id: $('.dt-check:checked:not(#multi-all)').map(function() {
                    return $(this).val();
                }).get()
            }));
            //$('#multi-sub').trigger('click');

        });

        /*
        $.ajax({
			method: "GET",
			url: base_url + '/orderlog-list'
		}).done(function(data) {

			if (data.success){
                $("#log-download-link").attr("href", data.log_path);
                $("#log-name").html(data.log_name);
                $("#log-container").html(data.log_content);
            }
        }).fail(function() {
        
        });
        */

        var permission_tbl = $('#permission-tbl').DataTable({
            serverSide: true,
            processing: true,
            bStateSave: true,
            responsive: true,
            autoWidth: false,
            deferRender: true,
            columnDefs: [{
                "targets": [0, 2],
                "orderable": false
            }],
            ajax: {
                url: "<?php echo e(route('permissions.index')); ?>",
                //type: 'GET',
            },
            language: {
                paginate: {
                    next: '>', // or '→'
                    previous: '<' // or '←' 
                }
            },
            // dom:'<lf<t>ip>',
            columns: [
                //{ data: 'id', name: 'id' },
                {
                    data: 'chk_id',
                    name: 'chk_id',
                    searchable: false,
                    orderable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'action',
                    name: 'action'
                }

            ],
            fnDrawCallback: function(oSettings) {
                //bindDelete();
            }
        });


        $('body').on('change', '#multi-all', function() {
            var a, b;
            a = $('.dt-check:not(#multi-all)');
            b = $('#deleteBtn');
            if ($('#multi-all:checked').length) {
                a.not(':checked').prop('checked', true);
                b.removeClass('disabled').removeAttr('disabled');
                b.css({
                    "background-color": "#B83131",
                    "color": "#fff"
                });
            } else {
                a.filter(':checked').prop('checked', false);
                b.addClass('disabled').attr('disabled', 'disabled');
                b.css({
                    "background-color": "#fff",
                    "color": "#B83131"
                });
            }
        });

        $('body').on('change', '.dt-check:not(#multi-all)', function() {
            var m, b, that, x$;
            m = $('#multi-all');
            b = $('#deleteBtn');
            if (that = $('.dt-check:checked:not(#multi-all)').length) {
                x$ = that < $('.dt-check:not(#multi-all)').length;
                m.prop('indeterminate', x$).prop('checked', !x$);
                b.removeClass('disabled').removeAttr('disabled');
                b.css({
                    "background-color": "#B83131",
                    "color": "#fff"
                });
            } else {
                m.prop('indeterminate', false).prop('checked', false);
                b.addClass('disabled').attr('disabled', 'disabled');
                b.css({
                    "background-color": "#fff",
                    "color": "#B83131"
                });
            }
        });

        $('#filter-temp-tbl th input[type=text]').addClass('form-control input-sm').css({
            "width": "100%"
        });
        $('#filter-temp-tbl th:nth-of-type(2) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-1');
        $('#filter-temp-tbl th:nth-of-type(3) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-1');
        $('#filter-temp-tbl th:nth-of-type(5) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-2');
        $('#filter-temp-tbl th:nth-of-type(8) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-2');
        $('#filter-container').css({
            'height': '100%'
        });
        $('#filter-temp-tbl thead tr:nth-of-type(2)').css({
            'display': 'none'
        });
        //new $.fn.dataTable.FixedHeader( sms_tbl );
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/bitnami/apache/htdocs/pmi-backoffice-my-stage/resources/views/permissions/index.blade.php ENDPATH**/ ?>