@extends('layouts.master')

@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Create Photo Feedback Tasks</div>
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="fa-ul">
                        @foreach ($errors->all() as $error)
                        <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                {{ Form::open(array('url' => 'photo-feedback/tasks', 'method' => 'POST', 'files' => true)) }}
                <div class="col-md-12" style="margin:10px 0;">
                    {{ Form::submit('Save', array('class' => 'btn btn-default')) }}
                    <a href="{{ URL::to('/photo-feedback/tasks') }}" class="btn btn-default">Back</a>
                </div>


                <div class="panel-body">

                    <div class="form-group">
                        <label for="input-hf-banner">Banner Image (EN)</label>
                        <br>
                        <span>Recommended banner dimensions: 576x260px</span>
                        <div class="file-path-wrapper">
                            <input type="file" name="banner_img" class="form-control-file" id="banner-img-file" value="{{ old('banner_img') }}" accept="image/x-png,image/gif,image/jpeg">
                        </div>
                        <label for="profile_image"></label>
                        <br>
                        <i class="img-btn fa fa-edit"></i>
                        <i class="img-btn fa fa-undo"></i>
                        <img id="banner_img" class="banner_img_preview" src="{{ url('images/empty-image.gif') }}" height="180px" />
                        <input type="hidden" class="empty-img-url" value="{{ url('images/empty-image.gif') }}" />
                    </div>

                    <div class="form-group">
                        <label for="input-hf-banner">Banner Image (CH)</label>
                        <br>
                        <span>Recommended banner dimensions: 576x260px</span>
                        <div class="file-path-wrapper">
                            <input type="file" name="banner_img_ch" class="form-control-file" id="banner-img-ch-file" value="{{ old('banner_img_ch') }}" accept="image/x-png,image/gif,image/jpeg">
                        </div>
                        <label for="profile_image"></label>
                        <br>
                        <i class="img-btn fa fa-edit"></i>
                        <i class="img-btn fa fa-undo"></i>
                        <img id="banner_img_ch" class="banner_img_preview" src="{{ url('images/empty-image.gif') }}" height="180px" />
                        <input type="hidden" class="empty-img-url" value="{{ url('images/empty-image.gif') }}" />
                    </div>

                    <div class="form-group">
                        <label for="name">*Photo Feedback Task Name</label>
                        <input type="text" name="name" class="form-control" id="name" value="{{ old('name') }}">
                    </div>

                    <div class="form-group">
                        <label for="title">*Title</label>
                        <input type="text" name="title" class="form-control" id="title" value="{{ old('title') }}">
                    </div>

                    <div class="form-group">
                        <label for="descr">*Description</label>
                        <input type="text" name="descr" class="form-control" id="descr" value="{{ old('descr') }}">
                    </div>

                    <div class="form-group campaign-content">
                        <label for="points">*Campaign Event</label>
                        {{ Form::select('campaign_id', $data['allCampaign'], null, ['class' => 'form-control campaign']) }}
                    </div>

                    <div class="form-group stage-content hide">
                        <label for="points">*Stage</label>
                        {{ Form::select('campaign_stage_id', $data['allStage'], null, ['class' => 'form-control stage']) }}
                    </div>

                    <div class="form-group task-type-content hide">
                        <label for="points">*Task Type Name</label>
                        <input type="text" name="campaign_task_type" class="form-control" id="campaign-task-type" value="{{ old('campaign_task_type') }}" placeholder="Example: MARLBORO Discounts">
                    </div>

                    <div class="form-group">
                        <label for="campaign-url">*Campaign Landing Page URL</label>
                        <input type="text" name="campaign_url" class="form-control" id="campaign-url" value="{{ old('campaign_url') }}" placeholder="https://www.example.com">
                    </div>

                    <div class="form-group">
                        <label for="snap-url">*SNAP Landing Page URL</label>
                        <input type="text" name="snap_url" class="form-control" id="snap-url" value="{{ old('snap_url') }}" placeholder="https://www.example.com">
                    </div>

                    <div class="form-group">
                        <label for="subchain">*Subchain</label>
                        {{ Form::select('subchain[]', $data['allSubchain'], null, ['class' => 'form-control subchain', 'multiple'=>'multiple']) }}
                    </div>

                    <div class="form-group">
                        <label for="points">*Transaction Description</label>
                        <input type="text" name="transaction_descr" class="form-control" id="transaction-descr" value="{{ old('transaction_descr') }}">
                    </div>

                    <div class="form-group">
                        <label for="points">*Points</label>
                        <input type="number" name="points" class="form-control" id="points" value="{{ old('points') }}">
                    </div>

                    <div class="form-group">
                        <li class="list-group-item">
                            <div class="form-group">
                                <div>
                                    <div>
                                        <input type='radio' name='options' id='static-option' value='1' class='dt-radio radio-option' {{ ( (old('options') == 1) || empty($option) ? ' checked' : '') }}>
                                        <label for='static-option'>
                                            <span></span>
                                            Static Option
                                        </label>
                                    </div>
                                    <div>
                                        <input type='radio' name='options' id='dynamic-option' value='2' class='dt-radio radio-option' {{ (old('options') == 2 ? ' checked' : '') }}>
                                        <label for='dynamic-option'>
                                            <span></span>
                                            Dynamic Option
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </li>


                        <div id="static-panel">
                            <li class="list-group-item">
                                <div class="form-group">
                                    <label for="start-datetime">*Task Start Date/time</label>
                                    <input type="datetime-local" name="start_datetime" class="form-control" id="start-datetime" value="{{ old('start_datetime') }}">
                                </div>
                            <li>
                            <li class="list-group-item">
                                <div class="form-group">
                                    <label for="end-datetime">*Task End Date/time</label>
                                    <input type="datetime-local" name="end_datetime" class="form-control" id="end-datetime" value="{{ old('end_datetime') }}">
                                </div>
                            <li>
                            <li class="list-group-item">
                                <div class="form-group">
                                    <label for="reminder-datetime">*Reminder SMS Date/time</label>
                                    <input type="datetime-local" name="reminder_datetime" class="form-control" id="reminder-datetime" value="{{ old('reminder_datetime') }}">
                                </div>
                            <li>
                        </div>

                        <div id="dynamic-panel">
                            <li class="list-group-item">
                                <div class="form-group">
                                    <label for="task-duration">*Task Duration</label>
                                    <input type="number" name="task_duration" class="form-control" id="task-duration" value="{{ (old('task_duration')) ? old('task_duration') : '' }}">
                                </div>
                            <li>
                            <li class="list-group-item">
                                <div class="form-group">
                                    <label for="reminder-sms-day">*Reminder SMS Day</label>
                                    <input type="number" name="reminder_sms_day" class="form-control" id="reminder-sms-day" value="{{ (old('reminder_sms_day')) ? old('reminder_sms_day') : '' }}">
                                </div>
                            <li>
                            <li class="list-group-item">
                                <div class="form-group">
                                    <label for="dynamic-end-datetime">*End Date/time</label>
                                    <input type="datetime-local" name="dynamic_end_datetime" class="form-control" id="dynamic-end-datetime" value="{{ (old('dynamic_end_datetime')) ? old('dynamic_end_datetime') : '' }}">
                                </div>
                            <li>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="sms-msg-temp">SMS Message Templates</label>

                        <li class="list-group-item">

                            <div class="form-group">
                                <label for="reminder-sms-en">*Reminder SMS (EN)</label>
                                <input type="text" name="reminder_sms_en" class="form-control" id="reminder-sms-en" value="{{ old('reminder_sms_en') }}">
                            </div>
                            <div class="form-group">
                                <label for="reminder-sms-ch">*Reminder SMS (CH)</label>
                                <input type="text" name="reminder_sms_ch" class="form-control" id="reminder-sms-ch" value="{{ old('reminder_sms_ch') }}">
                            </div>

                        </li>
                        <li class="list-group-item">

                            <div class="form-group">
                                <label for="approval-sms-en">*Approval SMS (EN)</label>
                                <input type="text" name="approval_sms_en" class="form-control" id="approval-sms-en" value="{{ old('approval_sms_en') }}">
                            </div>
                            <div class="form-group">
                                <label for="approval-sms-ch">*Approval SMS (CH)</label>
                                <input type="text" name="approval_sms_ch" class="form-control" id="approval-sms-ch" value="{{ old('approval_sms_ch') }}">
                            </div>

                        </li>
                        <li class="list-group-item">

                            <div class="form-group">
                                <label for="rejection-sms-en">*Rejection SMS (EN)</label>
                                <input type="text" name="rejection_sms_en" class="form-control" id="rejection-sms-en" value="{{ old('rejection_sms_en') }}">
                            </div>
                            <div class="form-group">
                                <label for="rejection-sms-ch">*Rejection SMS (CH)</label>
                                <input type="text" name="rejection_sms_ch" class="form-control" id="rejection-sms-ch" value="{{ old('rejection_sms_ch') }}">
                            </div>

                        </li>
                        <li class="list-group-item">

                            <div class="form-group">
                                <label for="task-expired-sms-en">Task Expired SMS (EN)</label>
                                <input type="text" name="task_expired_sms_en" class="form-control" id="task-expired-sms-en" value="{{ old('task_expired_sms_en') }}">
                            </div>
                            <div class="form-group">
                                <label for="task-expired-sms-ch">Task Expired SMS (CH)</label>
                                <input type="text" name="task_expired_sms_ch" class="form-control" id="task-expired-sms-ch" value="{{ old('task_expired_sms_ch') }}">
                            </div>

                        </li>
                    </div>

                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_script')

<link rel="stylesheet" href="{{ asset('vendor/select2/select2.min.css') }}">
<script src="{{ asset('vendor/select2/select2.min.js') }}"></script>

<script>
    $('select.subchain').select2();

    loadImgFunction();

    $(".radio-option").each(function() {
        if ($(this).is(':checked')) {
            if ($(this).val() == 1) {
                $("#static-panel").show();
                $("#dynamic-panel").hide();
            } else {
                $("#static-panel").hide();
                $("#dynamic-panel").show();
            }
        }
    });

    $(".form-control-file").change(function() {
        var fileExtension = ['jpeg', 'jpg', 'png', 'gif', 'bmp'];
        if ($.inArray($(this).val().split('.').pop().toLowerCase(), fileExtension) == -1) {
            alert("Only formats are allowed : " + fileExtension.join(', '));
            $(this).val('');
        } else {

            //here I CHECK if the FILE SIZE is bigger than 8 MB (numbers below are in bytes)
            if (this.files[0].size > 2388608 || this.files[0].size > 2388608) {
                //show an alert to the user
                alert("Allowed file size exceeded. (Max. 2 MB)")

                //reset file upload control
                this.value = null;
            } else {
                bannerReadURL(this, $(this), "ch");

            }
        }
    });


    function bannerReadURL(input, thisEle, locale) {

        var reader = new FileReader();
        reader.onload = function(e) {
            console.log(thisEle);
            thisEle.parent().parent().find(".banner_img_preview").attr('src', e.target.result);
        }
        reader.readAsDataURL(input.files[0]);
    }

    function loadImgFunction() {

        $(".form-control-file, .fa-undo").hide();
        $(".fa-edit").click(function() {
            $(this).attr("disabled", true);
            $(this).hide();
            $(this).parent().find("input[type=file]").trigger("click");
            $(this).parent().find("input[type=file]").show();
            $(this).next().show();
            $(this).attr("disabled", true);
        });

        $(".fa-undo").click(function() {
            $(this).hide();
            var oldImage = $(this).next().next().val();
            $(this).parent().find("input[type=file]").val("");
            //$(this).parent().find("input[type=file]").hide();
            $(this).prev().show();
            loadImg();
        });

    }


    $('.radio-option').click(function() {
        if (!$(this).val()) {
            return false;
        } else {
            if ($(this).val() == 1) {
                $("#static-panel").show();
                $("#dynamic-panel").hide();
            } else {
                $("#static-panel").hide();
                $("#dynamic-panel").show();
            }
        }
    });

    if ($('.campaign').val() != "") {
        $('.stage-content, .task-type-content').removeClass("hide");
    }

    $('.campaign').on('change', function() {
        console.log($(this).val());
        if ($(this).val() != '') {
            $('.stage-content, .task-type-content').removeClass("hide");
        } else {
            $('.stage-content, .task-type-content').addClass("hide");
        }
    });
</script>

@endsection