<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Balance Taking</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <style>
        .bt-table {
            font-family: Arial, Helvetica, sans-serif;
            border-collapse: collapse;
            width: 100%;
        }

        .bt-table td,
        .bt-table th {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
        }

        .bt-table tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        .bt-table tr:hover {
            background-color: #ddd;
        }

        .bt-table th {
            padding-top: 12px;
            padding-bottom: 12px;
            text-align: left;
            background-color: #CC2827;
            color: white;
            text-align: center;
        }

        .auto-email {
            text-align: center;
        }
    </style>
</head>

<body style="margin: 0; padding: 0;">
    <table border="0" cellpadding="0" cellspacing="0" width="100%">
        <tr>
            <td style="padding: 10px 0 30px 0;">
                <table align="center" border="0" cellpadding="0" cellspacing="0" width="600" style="border: 1px solid #cccccc; border-collapse: collapse;">
                    <tr>
                        <td align="center" bgcolor="#ffffff" style="padding: 20px  0 30px 0; color: #153643; font-size: 28px; font-weight: bold; font-family: Arial, sans-serif;">
                            <!--<img src="https://sg.pmiandu.com/file-asset/PMInUtransparent?v=1" alt="PMI BackOffice" width="280px" height="150px" style="display: block;" />-->
                            <label>PMI Balance Taking</label>
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#ffffff" style="padding: 0px 30px 40px 30px;">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                <tr>
                                    <td style="color: #153643; font-family: Arial, sans-serif; font-size: 20px; text-align: center;">
                                        Please find {{ $today_date }} report for {{ $total_outlet }}/{{ $day_name }} outlets.
                                        <br><br>
                                        No. of outlets submitted: <b>{{ $num_outlet_submitted }}</b>
                                        <br>
                                        No. of outlets to send reminder SMS: <b>{{ $num_outlet_send_reminder_sms }}</b>
                                        <br>
                                        No. of non-outlets early submission: <b>{{ $num_early_submitted }}</b>
                                        <br><br>
                                    </td>
                                </tr>
                            </table>
                            <table class="bt-table">
                                <tr>
                                    <th colspan="2">Submitted</th>
                                </tr>

                                @if (count($today_submitted_data) > 0)
                                @foreach ($today_submitted_data as $submittedData)
                                <tr>
                                    <td>{{ $submittedData->ideCust }}</td>
                                    <td>{{ $submittedData->strAddr }}</td>
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="2">None</td>
                                </tr>
                                @endif
                            </table>

                            <br>

                            <table class="bt-table">
                                <tr>
                                    <th colspan="2">Have not submitted</th>
                                </tr>
                                @if (count($today_not_submitted_data) > 0)
                                @foreach ($today_not_submitted_data as $notSubmittedData)
                                <tr>
                                    <td>{{ $notSubmittedData->ideCust }}</td>
                                    <td>{{ $notSubmittedData->strAddr }}</td>
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="2">None</td>
                                </tr>
                                @endif
                            </table>

                            <br>

                            <table class="bt-table">
                                <tr>
                                    <th colspan="2">Early submission</th>
                                </tr>
                                @if (count($early_data) > 0)
                                @foreach ($early_data as $earlyData)
                                <tr>
                                    <td>{{ $earlyData->ideCust }}</td>
                                    <td>{{ $earlyData->strAddr }}</td>
                                </tr>
                                @endforeach
                                @else
                                <tr>
                                    <td colspan="2">None</td>
                                </tr>
                                @endif
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" class="auto-email">
                            Thank you.
                            This is an auto-generated email, please do not reply.
                        </td>
                    </tr>
                    <tr>
                        <td bgcolor="#cc2827" style="padding: 30px 30px 30px 30px;">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                <tr>
                                    <td style="color: #ffffff; font-family: Arial, sans-serif; font-size: 14px; text-align: center;" width="75%">
                                        &reg; {{ date("Y") }} PHILIP MORRIS SINGAPORE PTE. LTD.<br />
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>

</html>