@extends('layouts.master')

@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Documents
                    @foreach (['danger', 'warning', 'success', 'info'] as $key)
                    @if(Session::has($key))
                    <p class="alert alert-{{ $key }} alert-msg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;{{ Session::get($key) }}</p>
                    @endif
                    @endforeach
                </div>

                <div class="col-md-12" style="margin:10px 0;">
                    @can('edit documentation')
                    <a href="{{ route('documentation.create') }}" class="btn btn-default"><i class="glyphicon glyphicon-plus"></i> Create</a>
                    <button type="button" id="deleteDocBtn" class="float-right btn btn-default" data-toggle="modal" data-target="#deleteModal" disabled><i class="fa fa-trash" aria-hidden="true"></i></button>
                    @endcan
                </div>

                <div class="panel-body">
                    <table id="doc-tbl" class="display table-bordered dt-responsive">
                        <thead>
                            <tr>
                                <th style="width:5%;">
                                    <input id="multi-all" class="dt-check" type="checkbox">
                                    <label for="multi-all">
                                        <span></span>
                                    </label>
                                </th>
                                <th>ID</th>
                                <th>Title</th>
                                <th>Description</th>
                                <th>Author</th>
                                <th>Created Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>

            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="deleteModal" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title"><i class="fa fa-trash" aria-hidden="true"></i> Delete this document?</h4>
                    </div>
                    <div id="modal-body" class="modal-body">
                        <p>Are you sure, you want to delete the selected document?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="confirmDelDoc" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>

            </div>
        </div>

        <div class="modal fade" id="viewModal" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header"></div>
                    <div id="modal-desc" class="modal-body"></div>
                    <div id="modal-body" class="modal-body"></div>
                    <div id="modal-author" class="modal-body"></div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>

            </div>
        </div>

    </div>
</div>

@endsection

@section('footer_script')
<script type="text/javascript">
    $(document).ready(function() {

        $(".alert-msg").fadeOut(5500, function() {
            $(this).remove();
        });

        $("#deleteDocBtn").click(function() {
            var chk_doc_ids = $('.dt-check:checked:not(#multi-all)').map(function() {
                return $(this).val();
            }).get();

            if (chk_doc_ids > 0) {
                $("#modal-body").html("<p>Are you sure, you want to delete the selected document?</p>");
            } else {
                $("#modal-body").html("<p>Are you sure, you want to delete the selected documents?</p>");
            }
        });

        $("#confirmDelDoc").click(function() {

            var chk_doc_ids = $('.dt-check:checked:not(#multi-all)').map(function() {
                return $(this).val();
            }).get();

            $.ajax({
                url: "{{ route('documentation.multiple-delete') }}",
                type: 'GET',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id: chk_doc_ids
                },
                success: function(result) {
                    $(".dt-check:checked").each(function() {
                        $(this).parents("tr").remove();
                    });
                    $(".panel-heading").append('<p class="alert alert-success alert-msg"><i class="fa fa-trash" aria-hidden="true"></i>&nbsp;Documents deleted successfully.</p>');
                    $(".alert-msg").fadeOut(5500, function() {
                        $(this).remove();
                    });
                }
            });

            var x$;
            x$ = $(this).data('action');
            $('#multi-form').attr('action', $('#multi-form').data('action') + x$);
            $('#multi-val').val(JSON.stringify({
                action: x$,
                id: $('.dt-check:checked:not(#multi-all)').map(function() {
                    return $(this).val();
                }).get()
            }));
            //$('#multi-sub').trigger('click');

        });


        var csrfToken = '{{ csrf_token() }}';

        console.log(csrfToken);
        var ccb2b_tbl = $('#doc-tbl').DataTable({
            serverSide: true,
            processing: true,
            bStateSave: true,
            responsive: true,
            autoWidth: false,
            columnDefs: [{
                "targets": [0, 6],
                "orderable": false
            }],
            ajax: {
                url: "{{ route('documentation.index') }}",
                //type: 'GET',
            },
            language: {
                paginate: {
                    next: '>', // or '→'
                    previous: '<' // or '←' 
                }
            },
            // dom:'<lf<t>ip>',
            columns: [
                //{ data: 'id', name: 'id' },
                {
                    data: 'chk_id',
                    name: 'chk_id',
                    searchable: false,
                    orderable: false
                },
                {
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'header',
                    name: 'header'
                },
                {
                    data: 'desc',
                    name: 'desc'
                },
                {
                    data: 'author',
                    name: 'author'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'action',
                    name: 'action',
                    searchable: false,
                    orderable: false
                },
            ],
            fnDrawCallback: function(oSettings) {
                viewButton();
                //bindDelete();
            }
        });
        //new $.fn.dataTable.FixedHeader( sms_tbl );
    });

    function viewButton() {
        $(".viewBtn").click(function() {
            var id = $(this).data("id");

            $.ajax({
                url: "{{ route('doc.content') }}",
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    csrf_token: "{{ csrf_token() }}",
                    id: id
                },
                success: function(result) {
                    data = result.data;

                    $("#viewModal .modal-header").html("Title: " + data.header);
                    $("#viewModal #modal-desc").html("Description: " + data.desc);
                    $("#viewModal #modal-author").html("Author: " + data.author);
                    $("#viewModal #modal-body").html("Content: " + data.content);
                }
            });
        })
    }

    $('body').on('change', '#multi-all', function() {
        var a, b;
        a = $('.dt-check:not(#multi-all)');
        b = $('#deleteDocBtn');
        if ($('#multi-all:checked').length) {
            a.not(':checked').prop('checked', true);
            b.removeClass('disabled').removeAttr('disabled');
            b.css({
                "background-color": "#B83131",
                "color": "#fff"
            });
        } else {
            a.filter(':checked').prop('checked', false);
            b.addClass('disabled').attr('disabled', 'disabled');
            b.css({
                "background-color": "#fff",
                "color": "#B83131"
            });
        }
    });

    $('body').on('change', '.dt-check:not(#multi-all)', function() {
        var m, b, that, x$;
        m = $('#multi-all');
        b = $('#deleteDocBtn');
        if (that = $('.dt-check:checked:not(#multi-all)').length) {
            x$ = that < $('.dt-check:not(#multi-all)').length;
            m.prop('indeterminate', x$).prop('checked', !x$);
            b.removeClass('disabled').removeAttr('disabled');
            b.css({
                "background-color": "#B83131",
                "color": "#fff"
            });
        } else {
            m.prop('indeterminate', false).prop('checked', false);
            b.addClass('disabled').attr('disabled', 'disabled');
            b.css({
                "background-color": "#fff",
                "color": "#B83131"
            });
        }
    });
</script>
@endsection