<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreateDispenserReport extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dispenser_report', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('case_id', 255);
            $table->string('outlet_name', 255);
            $table->string('cust_id', 15);
            $table->longText('address');
            $table->string('name', 255);
            $table->string('contact_no', 255);
            $table->string('locale', 15);
            $table->longText('imgs')->nullable();
            $table->longText('comment')->nullable();
            $table->text('admin_comment')->nullable();
            $table->tinyInteger('spring_pusher')->comment('0: Not select, 1: Select');
            $table->tinyInteger('ticketing_holder')->comment('0: Not select, 1: Select');
            $table->tinyInteger('door_roller')->comment('0: Not select, 1: Select');
            $table->tinyInteger('tray')->comment('0: Not select, 1: Select');
            $table->tinyInteger('number_strip')->comment('0: Not select, 1: Select');
            $table->tinyInteger('stopper')->comment('0: Not select, 1: Select');
            //$table->tinyInteger('data_strip')->comment('0: Not select, 1: Select');
            $table->tinyInteger('door_and_frame')->comment('0: Not select, 1: Select');
            $table->tinyInteger('ekit')->comment('0: Not select, 1: Select');
            $table->tinyInteger('status')->comment('0: Submitted, 1: Scheduled, 2: Closed')->nullable();
            $table->integer('scheduled_by')->nullable();
            $table->date('repair_date')->nullable();
            $table->string('time_range', 255)->nullable();
            $table->string('acknowledge_closed_by', 10)->comment('1: Retailer, NULL: Admin')->nullable();
            $table->dateTime('acknowledge_closed_datetime')->nullable();
            $table->string('priority', 30)->comment('1: High, 2:Med, 3: Low')->nullable();
            $table->tinyInteger('created_from_backoffice')->comment('0: From API, 1: From Backoffice')->default(0);
            $table->timestamps();
        });

        //DB::statement('ALTER TABLE dispenser_report CHANGE cust_id cust_id INT(5) UNSIGNED ZEROFILL NOT NULL');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dispenser_report');
    }
}
