<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTradeProgram extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trade_program', function (Blueprint $table) {
            $table->softDeletes();
            $table->bigIncrements('id');
            $table->bigInteger('family_tag_id');
            //$table->foreign('family_tag_id')->references('id')->on('trade_program_family_tag');
            $table->mediumText('program_name');
            $table->mediumText('program_name_ch')->nullable();
            //$table->string('kv_image', 255);
            $table->longText('descr');
            $table->longText('descr_ch')->nullable();
            $table->longText('terms_cond');
            $table->longText('terms_cond_ch')->nullable();
            //$table->longText('tips_payout');
            $table->tinyInteger('is_homepage_feature');
            $table->tinyInteger('is_prefer_program');
            $table->longText('homepage_feature_banner');
            $table->longText('homepage_feature_banner_ch');
            $table->string('sku_pack', 255)->nullable();
            $table->unique('slug_name', 255);
            $table->timestamps();
            $table->engine = 'InnoDB';
        });

        Schema::table('trade_program', function ($table) {
            $table->foreign('family_tag_id')->references('id')->on('trade_program_family_tag');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trade_program');
    }
}
