<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class ResetPassword extends Notification
{
    use Queueable;
    public $token;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($token)
    {
        $this->token = $token;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {

        /*
        return (new MailMessage)
            ->line('The introduction to the notification.')
            ->action('Notification Action', url('password/reset', $this->token))
            ->line('Thank you for using our application!');
            */



        return (new MailMessage)
            ->subject('PMI BackOffice - ' . config('app.name'))
            ->line('Ovaj e-mail Vam je poslat jer ste zahtijevali promjenu lozinke za vaš nalog.')
            ->action('Promjena lozinke', url('password/reset', $this->token))
            ->line('Ukoliko nijeste zahtijevali promjenu lozinke, ignorišite ovaj e-mail.');
        //->view('emails.reset-pw')
        //->markdown('mail.new_job.user_notification', ['data' => $data]);


        //custom template
        /*
        return (new MailMessage)->view(
            'emails.mail',
            ['password' => ""]
        );
        */
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
