<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class BackofficeGameplay2022May extends Model
{
    protected $table = 'backoffice_gameplay_2022_may';
    private static $tableName = 'backoffice_gameplay_2022_may';
    public $timestamps = false;

    public static function totalGamePlays($custId, $gameName)
    {
        $sql = "SELECT count(*) as numPlayed
        FROM  " . static::$tableName . "
        WHERE cust_id = '" . $custId . "' AND game = '" . $gameName . "' ";

        $invoiceDate = DB::select($sql);
        return collect($invoiceDate)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array
    }

    public static function leaderboard($game)
    {

        // $sql = "SELECT  cust_id, MAX(email) as email, game, max(score) as higher_score
        // FROM  " . static::$tableName . " 
        // WHERE game = '" . $game . "' AND end IS NOT NULL
        // GROUP BY cust_id ORDER BY MAX(score) DESC LIMIT 10";

        $sql = "SELECT  cust_id, MAX(first_name) as first_name, game, max(score) as higher_score
        FROM  " . static::$tableName . " 
        WHERE game = '" . $game . "' 
		AND cust_id != 'SG80072' AND cust_id != 'SG80073' AND cust_id != 'SG80078'
        GROUP BY cust_id ORDER BY MAX(score) DESC LIMIT 30";

        $invoiceDate = DB::select($sql);
        return collect($invoiceDate)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array
    }

    public static function myRank($game)
    {

        // $sql = "SELECT  cust_id, MAX(email) as email, game, max(score) as higher_score
        // FROM  " . static::$tableName . " 
        // WHERE game = '" . $game . "' AND end IS NOT NULL
        // GROUP BY cust_id ORDER BY MAX(score) DESC";

        $sql = "SELECT  cust_id, MAX(email) as email, game, max(score) as higher_score
        FROM  " . static::$tableName . " 
        WHERE game = '" . $game . "' 
        GROUP BY cust_id ORDER BY MAX(score) DESC";

        $invoiceDate = DB::select($sql);
        return collect($invoiceDate)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array
    }


    public static function lastPositionLeaderbroad($gameName)
    {

        // $sql = "SELECT  cust_id, MAX(email) as email, game, max(score) as higher_score
        // FROM  " . static::$tableName . " 
        // WHERE game = '" . $gameName . "' AND end IS NOT NULL
        // GROUP BY cust_id ORDER BY MAX(score) DESC LIMIT 10";

        $sql = "SELECT  cust_id, MAX(email) as email, game, max(score) as higher_score
        FROM  " . static::$tableName . " 
        WHERE game = '" . $gameName . "'
        GROUP BY cust_id ORDER BY MAX(score) DESC LIMIT 30";

        $invoiceDate = DB::select($sql);
        $arr  = collect($invoiceDate)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array

        if (count($arr) > 0) {
            $total = count($arr) - 1;
            $lastHighestScore = $arr[$total]['higher_score'];
        } else {
            $lastHighestScore = 0;
        }

        return $lastHighestScore;
    }

    public static function chkSubmitted($custId, $gameName)
    {
        $sql = "SELECT cust_id
        FROM  " . static::$tableName . "
        WHERE cust_id = '" . $custId . "' AND 
        game = '" . $gameName . "' AND
        add_to_dte IS NOT NULL ";

        $invoiceDate = DB::select($sql);
        return collect($invoiceDate)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array
    }
}
