<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Carbon;

class RemainderPasswordExpire extends Mailable
{
    use Queueable, SerializesModels;

    public $data;
    public $token;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data, $token)
    {
        $this->data = $data;
        $this->token = $token;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        //$host = request()->getHost();
        $expiredDate = $this->data->password_changed_at;
        $expiredDateArr = explode("-", $expiredDate);

        $year = $expiredDateArr[0];
        $mth = str_pad($expiredDateArr[1], 2, '0', STR_PAD_LEFT);
        $day = explode(" ", str_pad($expiredDateArr[2], 2, '0', STR_PAD_LEFT));
        $day  = $day[0];

        $dt = Carbon::create($year, $mth, $day);
        $passwordEndDate = $dt->addDays(90)->format("d-m-Y");

        //$expiredDate = Carbon::createFromFormat('Y-m-d', $passwordEndDate)->format('d-m-Y');
        return $this->subject('Your backoffice account password is expiring soon')->markdown('emails.remainder-pw')
            ->with([
                //'email' => $this->data->email,
                'message' => "Your password will expire on <" . $passwordEndDate . ">, Please change before expiry to prevent login issues",
                'password' => '',
                'actionUrl' => url("/pmi-backoffice/public/password/reset/" . $this->token),
            ]);
    }
}
