<?php

namespace App\Http\Controllers;

use App\Http\Controllers\EmailController;
use App\User;
use App\Role;
use App\Authorizable;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use App\Mail\ResetEmail;
use App\Mail\NewUserEmail;
use Illuminate\Support\Facades\Mail;
use Redirect;
use View;
use URL;
use Session;
use Hash;
use Illuminate\Support\Str;
use App\PasswordHistory;
use Illuminate\Support\Facades\Password;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;

class UserListController extends Controller
{
    //
    use Authorizable;

    public function __construct(EmailController $EmailController)
    {
        //$this->middleware('auth');
        $this->EmailController = $EmailController;
    }

    public function index()
    {
        if (request()->ajax()) {
            $user = DB::connection('mysql')
                ->table('backoffice_users')
                ->select(['id', 'name', 'email', 'role_id', 'created_at']);

            return datatables()->of($user)
                ->addColumn('roles', function ($row) {
                    $roles = Role::find($row->role_id);
                    if (!empty($roles->name)) {
                        return $roles->name;
                    } else {
                        return "None";
                    }
                })
                ->addColumn('action', function ($row) {
                    if ($row->id != 1) {
                        $editBtn = (auth()->user()->can('edit user-creation') or auth()->user()->can('edit user-creation-role')) ? "<a href='" . URL::to("user-creation/" . $row->id . "/edit") . "' class='btn btn-default'>Edit</a>  " : "";
                        $deleteBtn = auth()->user()->can('edit user-creation') ? "<a data-id=" . $row->id . " class='btn btn-default btn-user-delete' data-toggle='modal' data-target='#deleteModal' >Delete</a>" : "";
                        $resetBtn = auth()->user()->can('edit user-creation') ? "<a data-id=" . $row->id . " class='btn btn-default btn-user-reset' data-toggle='modal' data-target='#resetModal' >Reset</a>" : "";
                    } else {
                        $editBtn = "";
                        $deleteBtn = "";
                        $resetBtn =  "";
                    }
                    return $editBtn . $deleteBtn . "  " . $resetBtn;
                })
                ->rawColumns(['roles', 'action'])
                ->make();;
        }
        return view('user.index');
    }

    public function create()
    {
        $roles = Role::pluck('name', 'id');

        $userAuth = Auth::user();
        if (!$userAuth->hasRole('Super Admin')) {
            unset($roles[1]); //removed Super Admin role
        }
        return view('user.create', compact('roles'));
    }

    public function show()
    {
        return view('user.index');
    }

    public function update($id)
    {
        /*
        $validator = [
            //'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
            'password' => [
                'min:9',             // must be at least 10 characters in length
                'required_with:password_confirmation',
                'same:password_confirmation',
                'regex:/[a-z]/',      // must contain at least one lowercase letter
                'regex:/[A-Z]/',      // must contain at least one uppercase letter
                'regex:/[0-9]/',      // must contain at least one digit
                'regex:/[@$!%*#?&]/', // must contain a special character
            ],
            'password_confirmation' => 'min:9'
        ];
        */

        $userAuth = Auth::user();

        $rules = array(
            'name' => [
                'required'
            ]
        );

        $customMessages = [];

        if ($userAuth->hasRole('Super Admin')) {
            $rules = array(

                'name' => [
                    'required'
                ],

                'email' => [
                    'required',
                    'email',
                    'unique:backoffice_users,email,' . $id,
                    'regex:/@pmi\.com|contracted.pmi\.com|@onyxisland\.com/'
                ],

                /*
            'password' => [
                'min:9',             // must be at least 10 characters in length
                'required_with:password_confirmation',
                'same:password_confirmation',
                'regex:/[a-z]/',      // must contain at least one lowercase letter
                'regex:/[A-Z]/',      // must contain at least one uppercase letter
                'regex:/[0-9]/',      // must contain at least one digit
                'regex:/[@$!%*#?&]/', // must contain a special character
            ],
            'password_confirmation' => 'min:9'
            */
            );

            $customMessages = [
                'email.regex' => 'Your email should ends with "pmi.com" or "@contracted.pmi.com"'
            ];
        }

        $validator = Validator::make(Input::all(), $rules, $customMessages);
        if ($validator->fails()) {
            return Redirect::to('user-creation/' . $id . '/edit')
                ->withErrors($validator)
                ->withInput(Input::except('password'));
        } else {

            // store
            $user = User::find($id);
            $user->name = Input::post('name');
            if ($userAuth->hasRole('Super Admin')) {
                $user->email = Input::post('email');
            }
            //$user->password = Hash::make(Input::post('password'));

            if ($userAuth->hasRole('Super Admin') || $userAuth->can('edit user-creation-role')) {
                if (!empty(Input::post('role_id'))) {
                    $user->role_id = Input::post('role_id');
                }
            }

            $user->save();

            if ($userAuth->hasRole('Super Admin') || $userAuth->can('edit user-creation-role')) {
                if (!empty(Input::post('role_id'))) {
                    $roles = Role::find($user->role_id);
                    $roleName = $roles->name;

                    $userInfo = User::find($id);
                    $userInfo->syncRoles($roleName); //remove all roles and update
                }
            }

            // redirect
            Session::flash('success', $user->name . ' successfully updated!');
            return Redirect::to('user-creation');
        }
    }

    public function store(Request $request)
    {
        $customMessages = [
            'email.regex' => 'Your email should ends with "pmi.com" or "@contracted.pmi.com"'
        ];

        $this->validate($request, [
            'name' => 'bail|required|min:2',
            //'email' => 'required|email|unique:backoffice_users|regex:/@gmail\.com|yahoo\.com/u',
            'email' => [
                'required',
                'email',
                'unique:backoffice_users',
                'regex:/@pmi\.com|contracted.pmi\.com|@onyxisland\.com/'
            ],
            //'password' => 'required|min:6',
            'password' => [
                'min:9',             // must be at least 10 characters in length
                'regex:/[a-z]/',      // must contain at least one lowercase letter
                'regex:/[A-Z]/',      // must contain at least one uppercase letter
                'regex:/[0-9]/',      // must contain at least one digit
                'regex:/[@$!%*#?&]/', // must contain a special character
            ],
            //'role_id' => 'required|min:1'
        ], $customMessages);

        // hash password
        //$request->merge(['password' => bcrypt($request->get('password'))]);
        $randomPwd = $this->randomPassword();

        $request->merge(['password' => bcrypt($randomPwd)]);

        // Create the user
        if ($user = User::create($request->except('permissions'))) {

            //Assign Role function
            $userAuth = Auth::user();
            if ($userAuth->hasRole('Super Admin') || $userAuth->can('edit user-creation-role')) {
                if (!empty($request->get('role_id'))) {
                    $roles = Role::find($request->get('role_id'));
                    $roleName = $roles->name;

                    $userInfo = User::find($user->id);
                    $userInfo->assignRole($roleName);
                }
            }

            $passwordHistory = PasswordHistory::create([
                'email' => $user->email,
                'password' => bcrypt($randomPwd)
            ]);

            //$this->syncPermissions($request, $user);
            //$this->EmailController->html_email($user->email, $randomPwd);

            $token = Password::broker()->createToken($user);
            Mail::to($user->email)->send(new NewUserEmail($user, $token));

            $host = request()->getHost();
            $logPath = "";
            if (strstr($host, 'localhost') || strstr($host, '192.168')) {
                $logPath = 'C:\wamp64\www\pmi-backoffice/storage/reset-password/';
            } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
                $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/reset-password/';
            } else if (strstr($host, 'games.pmisg.cloud.sg')) {
                $logPath = '/home/game/public_html/pmi-backoffice/storage/reset-password/';
            }

            $log_date = Carbon::now()->format('Y-m-d');
            $log_name = 'reset-password-' . $log_date;
            $log = new Logger('ResetPassword_log');
            $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

            if (Mail::failures()) {
                $log->critical($user->email . ' reset failed.', []);
                Session::flash()->error('Unable to create user.');
            } else {
                $log->critical($user->email . ' reset successfully.', []);
                Session::flash('User has been created.');
            }
        } else {
            Session::flash()->error('Unable to create user.');
        }

        $createStatus = true;
        $msg = "An email has been sent to " . $user->email;
        $data = compact("createStatus", "msg");

        return view('user.index', $data);
    }

    public function edit($id)
    {
        // get the User
        $user = User::find($id);
        $roles = Role::all();

        $userAuth = Auth::user();
        if (!$userAuth->hasRole('Super Admin')) {
            unset($roles[0]);
        }

        // show the edit form and pass the user
        return View::make('user.edit')
            ->with('user', $user)
            ->with('roles', $roles);
    }

    private function syncPermissions(Request $request, $user)
    {
        // Get the submitted roles
        $roles = $request->get('roles', []);
        $permissions = $request->get('permissions', []);

        // Get the roles
        $roles = Role::find($roles);

        // check for current role changes
        if (!$user->hasAllRoles($roles)) {
            // reset all direct permissions for user
            $user->permissions()->sync([]);
        } else {
            // handle permissions
            $user->syncPermissions($permissions);
        }

        $user->syncRoles($roles);
        return $user;
    }

    private function randomPassword()
    {

        // $length - the length of the generated password
        // $count - number of passwords to be generated
        // $characters - types of characters to be used in the password

        $length = 10;
        $count = 1;
        $characters = "lower_case,upper_case,numbers,special_symbols";

        // define variables used within the function    
        $symbols = array();
        $passwords = "";
        $used_symbols = '';
        $pass = '';

        // an array of different character types    
        $symbols["lower_case"] = 'abcdefghijklmnopqrstuvwxyz';
        $symbols["upper_case"] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $symbols["numbers"] = '1234567890';
        $symbols["special_symbols"] = '!?~@#-_+<>[]{}';

        $characters = explode(",", $characters); // get characters types to be used for the passsword
        foreach ($characters as $key => $value) {
            $used_symbols .= $symbols[$value]; // build a string with all characters
        }
        $symbols_length = strlen($used_symbols) - 1; //strlen starts from 0 so to get number of characters deduct 1

        for ($p = 0; $p < $count; $p++) {
            $pass = '';
            for ($i = 0; $i < $length; $i++) {
                $n = rand(0, $symbols_length); // get a random character from the string with all characters
                $pass .= $used_symbols[$n]; // add the character to the password string
            }
            $passwords = $pass;
        }

        return $passwords; // return the generated password
    }

    public function deleteMultiple(Request $request)
    {

        $ids = $request->id;

        //User::whereIn('id',$ids)->delete();
        if (User::where('id', $ids)->delete()) {
            return response()->json(['status' => true, 'message' => "User deleted successfully."]);
        } else {
            return response()->json(['status' => false, 'message' => "User failed successfully."]);
        }
    }

    public function reset_password(Request $request)
    {

        $randomPwd = $this->randomPassword();

        $id = $request->id;
        $user = User::find($id);
        $user->password = Hash::make($randomPwd);
        $user->save();

        $token = Password::broker()->createToken($user);

        $host = request()->getHost();

        $logPath = "";
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/reset-password/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/reset-password/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $logPath = '/home/game/public_html/pmi-backoffice/storage/reset-password/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'reset-password-' . $log_date;
        $log = new Logger('ResetPassword_log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        try {
            Mail::to($user->email)->send(new ResetEmail($user, $token));
            $log->critical($user->email . ' reset successfully.', []);
            return response()->json(['status' => true, 'message' => "An password reset email notification has been sent to " . $user->email]);
        } catch (\Swift_TransportException $transportExp) {

            //if (Mail::failures()) {
            $log->critical($user->email . ' reset failed. Error Message: ' . $transportExp->getMessage(), []);
            return response()->json(['status' => false, 'message' => "User reset failed. Error Message: " . $transportExp->getMessage()]);
            //} else {
            //	$log->critical($user->email . ' reset successfully.', []);
            //	return response()->json(['status' => true, 'message' => "An password reset email notification has been sent to " . $user->email]);
            //}
        }
    }










    // public function validatePasswordRequest(Request $request)
    // {
    //     //You can add validation login here
    //     $user = DB::table('users')->where('email', '=', $request->email)
    //         ->first();
    //     //Check if the user exists
    //     if (count($user) < 1) {
    //         return redirect()->back()->withErrors(['email' => trans('User does not exist')]);
    //     }

    //     //Create Password Reset Token
    //     DB::table('password_resets')->insert([
    //         'email' => $request->email,
    //         'token' => Str::random(60),
    //         'created_at' => Carbon::now()
    //     ]);
    //     //Get the token just created above
    //     $tokenData = DB::table('password_resets')
    //         ->where('email', $request->email)->first();

    //     if ($this->sendResetEmail($request->email, $tokenData->token)) {
    //         return redirect()->back()->with('status', trans('A reset link has been sent to your email address.'));
    //     } else {
    //         return redirect()->back()->withErrors(['error' => trans('A Network Error occurred. Please try again.')]);
    //     }
    // }

    // private function sendResetEmail($email, $token)
    // {
    //     //Retrieve the user from the database
    //     $user = DB::table('users')->where('email', $email)->select('firstname', 'email')->first();
    //     //Generate, the password reset link. The token generated is embedded in the link
    //     $link = config('base_url') . 'password/reset/' . $token . '?email=' . urlencode($user->email);

    //     try {
    //         //Here send the link with CURL with an external email API 
    //         return true;
    //     } catch (\Exception $e) {
    //         return false;
    //     }
    // }

    // public function resetPassword(Request $request)
    // {

    //     //Validate input
    //     $validator = Validator::make($request->all(), [
    //         'email' => 'required|email',
    //         'password' => 'required|confirmed',
    //         'token' => 'required'
    //     ]);

    //     $customMessages = [
    //         'email.regex' => 'Your email should ends with "pmi.com" or "@contracted.pmi.com"'
    //     ];

    //     $this->validate($request, [
    //         'name' => 'bail|required|min:2',
    //         //'email' => 'required|email|unique:backoffice_users|regex:/@gmail\.com|yahoo\.com/u',
    //         'email' => [
    //             'required',
    //             'email',
    //             //'unique:backoffice_users',
    //             //'regex:/@pmi\.com|contracted.pmi\.com|@onyxisland\.com/'
    //         ],
    //         //'password' => 'required|min:6',
    //         'password' => [
    //             'min:9',             // must be at least 10 characters in length
    //             'regex:/[a-z]/',      // must contain at least one lowercase letter
    //             'regex:/[A-Z]/',      // must contain at least one uppercase letter
    //             'regex:/[0-9]/',      // must contain at least one digit
    //             'regex:/[@$!%*#?&]/', // must contain a special character
    //         ],
    //     ], $customMessages);
    //     echo "test";
    //     exit();
    //     //check if payload is valid before moving on
    //     /*
    //     if ($validator->fails()) {
    //         return redirect()->back()->withErrors(['email' => 'Please complete the form']);
    //     }
    //     */

    //     $password = $request->password;
    //     // Validate the token
    //     $tokenData = DB::table('password_resets')
    //         ->where('token', $request->token)->first();
    //     // Redirect the user back to the password reset request form if the token is invalid
    //     if (!$tokenData) return view('auth.passwords.email');

    //     $user = User::where('email', $tokenData->email)->first();
    //     // Redirect the user back if the email is invalid
    //     if (!$user) return redirect()->back()->withErrors(['email' => 'Email not found']);
    //     //Hash and update the new password
    //     $user->password = Hash::make($password);
    //     $user->update(); //or $user->save();

    //     //login the user immediately they change password successfully
    //     Auth::login($user);

    //     //Delete the token
    //     DB::table('password_resets')->where('email', $user->email)
    //         ->delete();

    //     //Send Email Reset Success Email
    //     if ($this->sendSuccessEmail($tokenData->email)) {
    //         return view('index');
    //     } else {
    //         return redirect()->back()->withErrors(['email' => trans('A Network Error occurred. Please try again.')]);
    //     }
    // }
}
