<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        $user = Auth::user();
        $password_changed_at = $user->password_changed_at;

        if (Carbon::now()->diffInDays($password_changed_at) >= config('auth.password_expires_days')) {
            return redirect()->route('password.expired');
        }


        if (count(auth()->user()->getRoleNames()) <= 0) {
            return view('home-no-role');
        } else {
            return view('home');
        }

        /*
        $role = Role::find(2);
        $role = Role::create(['name'=>'digital_branding']);
        $permission = Permission::create(['name'=>'edit docs']);
        $role->givePermissionTo($permission);
        */

        //$role = Role::find(3);
        //$role->givePermissionTo('export dashboard');

        //$permission = Permission::create(['name'=>'view documentation']);
        //$role = Role::find(3);
        //$role->givePermissionTo($permission);

        //$user = User::find(1);
        //$user->givePermissionTo('add permissions');
        //$user->assignRole('Super Admin');

        /*
        $permission = Permission::create(['name'=>'export gamelogs']);
        $user = User::find(1); // returns an instance of \App\User
        $user->givePermissionTo($permission);
        //or
        $user->assignRole('superadmin');
        */
        //return auth()->user()->can('edit docs');
        //return auth()->user()->getRoleNames();

        //return auth()->user()->getRoleNames();

        //return auth()->user()->getAllPermissions();
        return view('home');
    }


    public function changePassword(Request $request)
    {

        if (!(Hash::check($request->get('current-password'), Auth::user()->password))) {
            // The passwords matches
            return redirect()->back()->with("error", "Your current password does not matches with the password you provided. Please try again.");
        }

        if (strcmp($request->get('current-password'), $request->get('new-password')) == 0) {
            //Current password and new password are same
            return redirect()->back()->with("error", "New Password cannot be same as your current password. Please choose a different password.");
        }

        $validatedData = $request->validate([
            'current-password' => 'required',
            'new-password' => 'required|string|min:9|confirmed',
        ]);

        //Check Password History
        $user = Auth::user();
        $passwordHistories = $user->passwordHistories()->take(env('PASSWORD_HISTORY_NUM'))->get();
        foreach ($passwordHistories as $passwordHistory) {
            echo $passwordHistory->password;
            if (Hash::check($request->get('new-password'), $passwordHistory->password)) {
                // The passwords matches
                return redirect()->back()->with("error", "Your new password can not be same as any of your recent passwords. Please choose a new password.");
            }
        }


        //Change Password

        $user->password = bcrypt($request->get('new-password'));
        $user->save();

        //entry into password history
        $passwordHistory = PasswordHistory::create([
            'user_id' => $user->id,
            'password' => bcrypt($request->get('new-password'))
        ]);

        return redirect()->back()->with("success", "Password changed successfully !");
    }
}
