<?php

namespace App\Helpers;

use Google_Client;
use Google_Service_Gmail;

use Symfony\Component\HttpFoundation\Request;
use Auth;

class Gmail
{

    public $filter_subject = "PMI-MY - Daily GT Dataset";

    // public function getClient()
    // {

    //     $configArray = [
    //         'client_id' => '746211625195-0fr8q54kj7nm44snsloaib3l19t83sjf.apps.googleusercontent.com',
    //         'client_secret' => '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'
    //     ];
    //     $client = new Google_Client($configArray);

    //     //$client = new Google_Client();
    //     $client->setApplicationName('Gmail API PHP Quickstart');
    //     $client->setScopes(Google_Service_Gmail::GMAIL_READONLY);
    //     //$client->setAuthConfig('credentials.json');
    //     $client->setAccessType('offline');
    //     $client->setPrompt('select_account consent');

    //     // Load previously authorized token from a file, if it exists.
    //     // The file token.json stores the user's access and refresh tokens, and is
    //     // created automatically when the authorization flow completes for the first
    //     // time.
    //     $tokenPath = 'token.json';
    //     if (file_exists($tokenPath)) {
    //         $accessToken = json_decode(file_get_contents($tokenPath), true);
    //         $client->setAccessToken($accessToken);
    //     }

    //     // If there is no previous token or it's expired.
    //     if ($client->isAccessTokenExpired()) {
    //         // Refresh the token if possible, else fetch a new one.
    //         if ($client->getRefreshToken()) {
    //             $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
    //         } else {
    //             // Request authorization from the user.
    //             $authUrl = $client->createAuthUrl();
    //             printf("Open the following link in your browser:\n%s\n", $authUrl);
    //             print 'Enter verification code: ';
    //             $authCode = trim(fgets(STDIN));

    //             // Exchange authorization code for an access token.
    //             $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
    //             $client->setAccessToken($accessToken);

    //             // Check to see if there was an error.
    //             if (array_key_exists('error', $accessToken)) {
    //                 throw new Exception(join(', ', $accessToken));
    //             }
    //         }
    //         // Save the token to a file.
    //         if (!file_exists(dirname($tokenPath))) {
    //             mkdir(dirname($tokenPath), 0700, true);
    //         }
    //         file_put_contents($tokenPath, json_encode($client->getAccessToken()));
    //     }
    //     return $client;
    // }

    // public function getClient()
    // {
    //     //$this->config->item('746211625195-0fr8q54kj7nm44snsloaib3l19t83sjf.apps.googleusercontent.com')
    //     $client = new Google_Client();
    //     $client->setClientId('746211625195-0fr8q54kj7nm44snsloaib3l19t83sjf.apps.googleusercontent.com');
    //     $client->setClientSecret('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');
    //     //$client->setRedirectUri('https://pmi-my.com/pmi-backoffice-my/public/login');
    //     $client->setRedirectUri('http://localhost');
    //     //$client->addScope('email');
    //     //$client->setScopes(implode(array(Google_Service_Gmail::GMAIL_READONLY)), ' ');
    //     //$client->addScope(Google_Service_Gmail::GMAIL_READONLY);
    //     //$client->addScope('profile');     
    //     $client->setScopes('https://mail.google.com');
    //     //$client->setAuthConfigFile('key/client_secret_105219sfdf2456244-bi3lasgl0qbgu5hgedg9adsdfvqmds5c0rkll.apps.googleusercontent.com.json');
    //     $client->setAuthConfig(getcwd() . '\client_secret.json');
    //     $client->setAccessType('offline');
    //     //$client->setApprovalPrompt('force');
    //     $client->setApprovalPrompt("consent");
    //     //$client->setIncludeGrantedScopes(true);
    //     //$client->setLoginHint('pmi@onyxisland.com');
    //     if ($client->isAccessTokenExpired()) {
    //         echo $client->getRefreshToken();
    //         exit();
    //         $accessToken = $client->fetchAccessTokenWithAuthCode($client->getRefreshToken());
    //     }
    //     // if ($client->isAccessTokenExpired()) {
    //     //     $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
    //     // }

    //     $gmailService = new Google_Service_Gmail($client);

    //     return $gmailService;
    // }


    // public function getClient()
    // {
    //     $client = new Google_Client();
    //     //$client->setApplicationName($this->projectName);
    //     $client->setScopes('https://mail.google.com');
    //     $client->setAuthConfig(getcwd() . '\client_secret.json');
    //     $client->setRedirectUri('https://pmi-my.com/pmi-backoffice-my/public/login');
    //     $client->setAccessType('offline');
    //     $client->setApprovalPrompt('force');
    //     $tokenFile = getcwd() . '\google-token.json';
    //     $authFile = getcwd() . '\client_secret.json';

    //     // Load previously authorized credentials from a file.
    //     if (file_exists($tokenFile)) {
    //         $accessToken = json_decode(
    //             file_get_contents($tokenFile),
    //             true
    //         );
    //     } else {

    //         // Request authorization from the user.
    //         $authUrl = $client->createAuthUrl();
    //         header('Location: ' . filter_var($authUrl, FILTER_SANITIZE_URL));

    //         if (isset($_GET['code'])) {
    //             $authCode = $_GET['code'];
    //             // Exchange authorization code for an access token.
    //             $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
    //             header('Location: ' . filter_var(
    //                 $this->redirectUri,
    //                 FILTER_SANITIZE_URL
    //             ));
    //             if (!file_exists(dirname($tokenFile))) {
    //                 mkdir(dirname($tokenFile), 0700, true);
    //             }

    //             file_put_contents($tokenFile, json_encode($accessToken));
    //         } else {
    //             exit('No code found');
    //         }
    //     }

    //     $client->setAccessToken($accessToken);

    //     print_r($client->isAccessTokenExpired());

    //     // Refresh the token if it's expired.
    //     if ($client->isAccessTokenExpired()) {

    //         // save refresh token to some variable
    //         $refreshTokenSaved = $client->getRefreshToken();
    //         $refreshTokenSaved = "1//04c2fJEPDytUOCgYIARAAGAQSNwF-L9IrDnJvihot20KYuiEYvC6omEu1CnN-Nj4UXeC-N6jIVWl_vHhrBiynFwbKXlXrqOsbbzw";

    //         // update access token
    //         $client->fetchAccessTokenWithRefreshToken($refreshTokenSaved);

    //         // pass access token to some variable
    //         $accessTokenUpdated = $client->getAccessToken();

    //         // append refresh token
    //         $accessTokenUpdated['refresh_token'] = $refreshTokenSaved;

    //         //Set the new acces token
    //         $accessToken = $refreshTokenSaved;
    //         $client->setAccessToken($accessToken);

    //         // save to file
    //         file_put_contents(
    //             $tokenFile,
    //             json_encode($accessTokenUpdated)
    //         );
    //     }
    //     return $client;
    // }

    public function refreshToken($refreshToken)
    {
        $curl = curl_init();

        // $refreshToken is the Auth code

        $clientId = env('GOOGLE_API_CLIENT_ID');
        $secret = env('GOOGLE_API_SECRET');
        $refreshToken = env('GOOGLE_REFRESH_TOKEN');

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://www.googleapis.com/oauth2/v4/token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'client_id=' . $clientId . '&client_secret=' . $secret . '&grant_type=refresh_token&refresh_token=' . $refreshToken,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        if (!empty($response)) {
            $jsonDecode = json_decode($response);

            $refreshToken = new \stdClass();
            if (!empty($jsonDecode->access_token)) {
                $refreshToken->success  = true;
                $refreshToken->response = $jsonDecode->access_token;
            } else {

                $refreshToken->success  = false;
                $refreshToken->response = $jsonDecode->error_description;
            }

            return $refreshToken;
        }
        return NULL;
    }

    public function filterLatestMail($latestDate, $authCode, $filterEmailList)
    {

        $curl = curl_init();

        $subject = $this->filter_subject;

        //https://www.googleapis.com/gmail/v1/users/me/messages?q=from:%20samrong.tee@onyxisland.com%20subject:%20PMI-MY%20-%20Daily%20GT%20Dataset%20newer_than:2d

        $urlFormat = "https://www.googleapis.com/gmail/v1/users/me/messages?q=from:";
        $urlFilter = str_replace(' ', '%20', $filterEmailList . ' subject: ' . $subject . ' newer_than:4d');

        $endpoint = $urlFormat . $urlFilter;

        curl_setopt_array($curl, array(
            //CURLOPT_URL => 'https://www.googleapis.com/gmail/v1/users/me/messages?q=from:%20' . $filterEmail . '%20subject:%20' . $subject . '%20newer:' . $latestDate,
            CURLOPT_URL => $endpoint,
            CURLOPT_RETURNTRANSFER => true,
            // CURLOPT_FAILONERROR => true,
            // CURLOPT_VERBOSE => true,
            // CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $authCode
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        if (!empty($response)) {

            $jsonDecode = json_decode($response);

            if (!empty($jsonDecode->messages)) {
                if (!empty($jsonDecode->messages[0])) {
                    $latestEmail = $jsonDecode->messages[0];
                }

                $latestEmail->success  = true;
                return $latestEmail;
            } else if (!empty($jsonDecode->error)) {
                $latestEmail = new \stdClass();
                $latestEmail->success  = false;
                $latestEmail->response = $jsonDecode;
            } else { // success and empty 

                $latestEmail = new \stdClass();
                $latestEmail->success  = true;
                $latestEmail->response = NULL;
            }
        }

        return $latestEmail;
    }

    public function getMailById($emailId, $authCode)
    {
        $curl = curl_init();

        $email = env('GOOGLE_API_EMAIL');

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://gmail.googleapis.com/gmail/v1/users/' . $email . '/messages/' . $emailId,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $authCode
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        if (!empty($response)) {
            $jsonDecode = json_decode($response);

            if (!empty($jsonDecode->payload->headers)) {

                $headers = $jsonDecode->payload->headers;

                // retrieve header info
                $date = "";
                $subject = "";
                $from = "";

                foreach ($headers as $header) {
                    if ($header->name == "Date") {
                        $date = $header->value;
                    }

                    if ($header->name == "Subject") {
                        $subject = $header->value;
                    }

                    if ($header->name == "From") {
                        $from = $header->value;
                    }
                }
                $bodyParts = $jsonDecode->payload->parts;
                $fileName = $bodyParts[1]->filename;
                $attachBody = $bodyParts[1]->body;
                $attachmentId = $attachBody->attachmentId;

                $attachInfo = new \stdClass();
                $attachInfo->success  = true;
                $attachInfo->filename = $fileName;
                $attachInfo->date = $date;
                $attachInfo->subject = $subject;
                $attachInfo->from = $from;
                $attachInfo->attachment_id = $attachmentId;
                return $attachInfo;
            } else {
                $attachInfo = new \stdClass();
                $attachInfo->success  = false;
                $attachInfo->response = $jsonDecode;

                return $attachInfo;
            }
        }
    }

    public function getAttachmentId($emailId, $attachId, $filename, $authCode)
    {
        $curl = curl_init();

        $email = env('GOOGLE_API_EMAIL');

        //echo 'https://gmail.googleapis.com/gmail/v1/users/' . $email . '/messages/' . $emailId . '/attachments/' . $attachId;

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://gmail.googleapis.com/gmail/v1/users/' . $email . '/messages/' . $emailId . '/attachments/' . $attachId,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_HTTPHEADER => array(
                'Authorization: Bearer ' . $authCode,
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        if (!empty($response)) {
            $jsonDecode = json_decode($response);
            if (!empty($jsonDecode->data)) {
                $attachmentData = new \stdClass();
                $attachmentData->success  = true;
                $attachmentData->response = $jsonDecode->data;
            } else {
                $attachmentData = new \stdClass();
                $attachmentData->success  = false;
                $attachmentData->response = $jsonDecode;
            }
            return $attachmentData;
        } else {
            //return $error_msg;
        }

        return NULL;
    }
}
