<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\Lead_data;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;


use Rap2hpoutre\FastExcel\FastExcel;
use Illuminate\Support\Facades\Storage;

class ImportLead extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:importLead';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import Lead';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */

    public function handle()
    {

        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice-my/storage/logs/lead-history/';
        } else {
            $logPath = '/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/logs/lead-history/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'Lead-history-' . $log_date;
        $log = new Logger('Lead-history-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));
        $log->info('Start importing Lead history...');

        //\Log::info("Cron is working fine!");
        //$this->info('KA Cron Cummand Run successfully!');

        try {

            $files = scandir('/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/app/lead-history-files', SCANDIR_SORT_DESCENDING);
            $newest_file = $files[0];

            $path = storage_path('app/lead-history-files/' . $newest_file);

            Lead_data::truncate();

            $leadCollection = (new FastExcel)->import($path);
            $leadCollection->filter()->each(function ($line) {

                Lead_data::create([
                    'name' => $line['Full Name'],
                    'email' => $line['Email'],
                    'dob' => $line['Date of Birth'],
                    'mobile' => $line['Mobile'],
                    'stage' => $line['Stage'],
                    'created_date' => $line['Created Date'],
                    'account_number' => $line['Contact Retailer: Account: Account Number'],
                    'account_name' => $line['Contact Retailer: Account: Account Name'],
                    'full_name' => $line['Contact Retailer: Full Name'],
                    'retailer_email' => $line['Contact Retailer: Email'],
                    'user_id' => $line['Contact Retailer: User ID']
                ]);
            });

            $log->info('Lead history data imported successfully.');
        } catch (\Exception $ex) {
            $log->critical('Lead history data imported failed.' . $ex);
        }
    }
}
