<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\Gt_buy;
use App\Models\Gt_files;
use App\Models\Gt_tier;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use App\Helpers\Gmail;

use Rap2hpoutre\FastExcel\FastExcel;
use Illuminate\Support\Facades\Storage;

class ImportGTfromEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:ImportGTfromEmail';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import GT from email';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    // public function handle()
    // {

    //     $logPath = "";
    //     $host = request()->getHost();
    //     if (strstr($host, 'localhost') || strstr($host, '192.168')) {
    //         $csv_dir = '';
    //         $logPath = 'C:\wamp64\www\pmi-backoffice/storage/gt/';
    //     } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
    //         $upload_dir = '/home/gamestg/gamepmistg_export';
    //         $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/gt/';
    //     } else if (strstr($host, 'games.pmisg.cloud.sg')) {
    //         $upload_dir = '/home/game/gamepmiprod_export';
    //         $logPath = '/home/game/public_html/pmi-backoffice/storage/gt/';
    //     }

    //     $log_date = Carbon::now()->format('Y-m-d');
    //     $log_name = 'GT-' . $log_date;
    //     $log = new Logger('GT-log');
    //     $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

    //     $filename = 'Data - GT.csv';

    //     try {

    //         $csvPath = $upload_dir . '/' . $filename;

    //         if (file_exists($csvPath)) {
    //             GT::query()->truncate();
    //             $result = Excel::import(new GTImport, $csvPath);

    //             $allInvoiceData = GT::all();

    //             foreach ($allInvoiceData as $invoiceData) {

    //                 if (
    //                     !empty($invoiceData->invoice_date) and
    //                     $invoiceData->invoice_date != null and
    //                     $invoiceData->invoice_date != "0000-00-00"
    //                 ) {
    //                     $publishData = PhotoFeedbackInvoicesPublish::select("published_date")
    //                         ->where("cust_id", $invoiceData->cust_id)
    //                         ->get();

    //                     if ($publishData->isEmpty()) {

    //                         $invoicePublish = new PhotoFeedbackInvoicesPublish();
    //                         $invoicePublish->cust_id = $invoiceData->cust_id;
    //                         $invoicePublish->published_date =  $invoiceData->invoice_date;

    //                         $invoicePublish->save();
    //                     }
    //                 }
    //             }
    //             $log->info($filename . ' imported successfully.');
    //         } else {
    //             $log->warning($filename . ' imported failed. ' . $csvPath);
    //         }
    //     } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {

    //         $log->warning($filename . '.csv imported failed. ' . $csvPath);
    //     }
    // }


    public function handle()
    {
        $gmail = new Gmail();

        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice-my/storage/logs/gt-data/';
        } else {
            $logPath = '/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/logs/gt-data/';
        }

        $filterEmailArr = [
            'HanCheng.Tan@pmi.com',
            'ShahZulAmanShah.MuhammadHaziq@contracted.pmi.com',
            'Grace.Tan@pmi.com',
            'SiamsingiNaiker.PrasadBahadur@pmi.com',
            'samrong.tee@onyxisland.com'
        ];
        $filterEmailList = implode(" OR from:", $filterEmailArr);

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'GT-Data-' . $log_date;
        $log = new Logger('GT-data-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));
        $log->info('');
        $log->info('Start search GT data from ' . $filterEmailList . '...');

        $todayDate = Carbon::now()->format('Y/m/d');

        try {

            ///////////Get refresh token

            $refreshToken = env('GOOGLE_REFRESH_TOKEN');
            $accessTokenResponse = $gmail->refreshToken($refreshToken);

            if ($accessTokenResponse->success === false) {
                $log->error('Filter latest mail: ' . $accessTokenResponse->response);
                throw new \ErrorException($accessTokenResponse->response);
            }
            $log->info('Access Token refreshed successfully.');
            $accessToken = $accessTokenResponse->response;
            $log->info('Access Token: ' . $accessToken);

            //$accessToken = "ya29.A0ARrdaM_3OsidtkRtkZpnxuF4U4MUaC9pJIdJhPrWxuLWr1Jg_xkJoHNJHsKGoyiUjWpWE66BXghojm2T6pcClVYy78kKyc2kVRhwuL4EJFM7443uWNDEdbfCUNQJMj-mJfUqmRR2bZgUlVxmm41AsLYGD-83Ew";
            ///////////Filter latest mail

            $latestEmail = $gmail->filterLatestMail($todayDate, $accessToken, $filterEmailList);
            if ($latestEmail->success === false) {
                $log->error('Filter latest mail: ' . $latestEmail->response->error->message);
                throw new \ErrorException($latestEmail->response->error->message);
            }

            if (empty($latestEmail->id)) {
                $log->info('Mail not found in the inbox. Please make sure the email send.');
                exit();
            }
            $log->info('Mail ID: ' . $latestEmail->id . ' retrieved.\n');

            ///////////Get Mail By ID

            $emailData = $gmail->getMailById($latestEmail->id, $accessToken);
            if ($emailData->success === false) {
                $log->error('Get Mail by ID: ' . $emailData->response->error->message);
                throw new \ErrorException($emailData->response->error->message);
            }
            $log->info('Received date: ' . $emailData->date . ' retrieved.');
            $log->info('Subject: ' . $emailData->subject . ' retrieved.');
            $log->info('From: ' . $emailData->from . ' retrieved.');
            $log->info('File name: ' . $emailData->filename . ' retrieved.');
            $log->info('Attachment ID: ' . $emailData->attachment_id . ' retrieved.');


            ///////////Get Attachment by ID

            $attachmentData = $gmail->getAttachmentId($latestEmail->id, $emailData->attachment_id, $emailData->filename, $accessToken);
            if ($attachmentData->success === false) {
                $log->error('Get attachment: ' . $attachmentData->response->error->message);
                throw new \ErrorException($attachmentData->response->error->message);
            }
            $log->info('Attachement: ' . $emailData->filename . ' read from API.');

            $decodedData = strtr($attachmentData->response, array('-' => '+', '_' => '/'));
            $decodedData = base64_decode($decodedData);

            $fileDate = Carbon::now()->format('Y-m-d his');
            $fileName = $fileDate . ' - ' . $emailData->filename;

            if (Storage::put('gt-files/' . $fileName, $decodedData)) {
                $log->info('Attachement: ' . $fileName . ' saved. Process completed.');
            } else {
                $log->error('File uploaded failed.');
            }

            /////////////// Start import data

            $log->info('Start importing GT data...');

            $path = storage_path('app/gt-files/' . $fileName);

            // insert file record
            $gtFile = new Gt_files;

            $gtFile->file_name = $fileName;
            $gtFile->path_name = $path;
            $gtFile->updated_at = null;
            $gtFile->save();

            Gt_buy::truncate();

            $BuyCollection = (new FastExcel)->sheet(1)->import($path);
            $BuyCollection->filter()->each(function ($line) {
                Gt_buy::create([
                    'customer_code' => $line['CustomerCode'],
                    'customer_name' => $line['CustomerName'],
                    'base_target_month' => $line['Base Target Month'],
                    'base_target' => $line['Base Target'],
                    'product_price_segment_descr' => $line['ProductPriceSegmentDescription'],
                    'product_family_descr' => $line['ProductFamilyDescription'],
                    'time_id' => $line['TimeId'],
                    'ims' => $line['IMS'],
                    'chain' => $line['Chain']
                ]);
            });

            $tierCollection = (new FastExcel)->sheet(2)->import($path);

            if (count($tierCollection) > 0) {

                Gt_tier::truncate();

                $tierCollection->filter()->each(function ($line) {
                    Gt_tier::create([
                        'customer_code'     => $line['CustomerCode'],
                        'customer_name'    => $line['CustomerName'],
                        'status_level' => $line['Status Level'],
                        'pm_posm'    => $line['PM POSM'],
                        'successful_lead'    => $line['Successful Lead'],
                        'base_target_quarterly'    => $line['Base Target Quarter'],
                        'base_target'    => $line['Base Target'],
                        'last_update'  => $line['Last Update']
                    ]);
                });
            }

            $log->info('GT data imported successfully.');
        } catch (QueryException $ex) {
            $log->error('Gmail sync failed.' . $ex);
        }
    }
}
