<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\Gt_buy;
use App\Models\Gt_tier;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;


use Rap2hpoutre\FastExcel\FastExcel;
use Illuminate\Support\Facades\Storage;

class ImportGT extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:importGT';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import GT';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    // public function handle()
    // {

    //     $logPath = "";
    //     $host = request()->getHost();
    //     if (strstr($host, 'localhost') || strstr($host, '192.168')) {
    //         $csv_dir = '';
    //         $logPath = 'C:\wamp64\www\pmi-backoffice/storage/gt/';
    //     } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
    //         $upload_dir = '/home/gamestg/gamepmistg_export';
    //         $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/gt/';
    //     } else if (strstr($host, 'games.pmisg.cloud.sg')) {
    //         $upload_dir = '/home/game/gamepmiprod_export';
    //         $logPath = '/home/game/public_html/pmi-backoffice/storage/gt/';
    //     }

    //     $log_date = Carbon::now()->format('Y-m-d');
    //     $log_name = 'GT-' . $log_date;
    //     $log = new Logger('GT-log');
    //     $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

    //     $filename = 'Data - GT.csv';

    //     try {

    //         $csvPath = $upload_dir . '/' . $filename;

    //         if (file_exists($csvPath)) {
    //             GT::query()->truncate();
    //             $result = Excel::import(new GTImport, $csvPath);

    //             $allInvoiceData = GT::all();

    //             foreach ($allInvoiceData as $invoiceData) {

    //                 if (
    //                     !empty($invoiceData->invoice_date) and
    //                     $invoiceData->invoice_date != null and
    //                     $invoiceData->invoice_date != "0000-00-00"
    //                 ) {
    //                     $publishData = PhotoFeedbackInvoicesPublish::select("published_date")
    //                         ->where("cust_id", $invoiceData->cust_id)
    //                         ->get();

    //                     if ($publishData->isEmpty()) {

    //                         $invoicePublish = new PhotoFeedbackInvoicesPublish();
    //                         $invoicePublish->cust_id = $invoiceData->cust_id;
    //                         $invoicePublish->published_date =  $invoiceData->invoice_date;

    //                         $invoicePublish->save();
    //                     }
    //                 }
    //             }
    //             $log->info($filename . ' imported successfully.');
    //         } else {
    //             $log->warning($filename . ' imported failed. ' . $csvPath);
    //         }
    //     } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {

    //         $log->warning($filename . '.csv imported failed. ' . $csvPath);
    //     }
    // }


    public function handle()
    {


        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice-my/storage/logs/gt-data/';
        } else {
            $logPath = '/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/logs/gt-data/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'GT-Data-' . $log_date;
        $log = new Logger('GT-data-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));
        $log->info('Start importing GT data...');

        // \Log::info("Cron is working fine!");
        // $this->info('GT Cron Cummand Run successfully!');

        try {

            $files = scandir('/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/app/gt-files', SCANDIR_SORT_DESCENDING);
            $newest_file = $files[0];

            $path = storage_path('app/gt-files/' . $newest_file);

            Gt_buy::truncate();

            $BuyCollection = (new FastExcel)->sheet(1)->import($path);
            $BuyCollection->filter()->each(function ($line) {
                Gt_buy::create([
                    'customer_code' => $line['CustomerCode'],
                    'customer_name' => $line['CustomerName'],
                    'base_target_month' => $line['Base Target Month'],
                    'base_target' => $line['Base Target'],
                    'product_price_segment_descr' => $line['ProductPriceSegmentDescription'],
                    'product_family_descr' => $line['ProductFamilyDescription'],
                    'time_id' => $line['TimeId'],
                    'ims' => $line['IMS'],
                    'chain' => $line['Chain']
                ]);
            });

            $tierCollection = (new FastExcel)->sheet(2)->import($path);

            if (count($tierCollection) > 0) {

                Gt_tier::truncate();

                $tierCollection->filter()->each(function ($line) {
                    Gt_tier::create([
                        'customer_code'     => $line['CustomerCode'],
                        'customer_name'    => $line['CustomerName'],
                        'status_level' => $line['Status Level'],
                        'pm_posm'    => $line['PM POSM'],
                        'successful_lead'    => $line['Successful Lead'],
                        'base_target_quarterly'    => $line['Base Target Quarter'],
                        'base_target'    => $line['Base Target'],
                        'last_update'  => $line['Last Update']
                    ]);
                });
            }

            $log->info('GT data imported successfully.');
        } catch (\Exception $ex) {
            $log->critical('GT data imported failed.' . $ex);
        }
    }
}
