<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;

class DeletePasswordHistories extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'delete:password_histories';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete Password Histories (more than 10 records)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $passwordMaxRecords = env('PASSWORD_HISTORY_NUM');
        $selectSql = "SELECT substring_index(GROUP_CONCAT(id ORDER BY created_at DESC), ',', 10) as id, email, count(id) as num
        FROM `password_histories`
        GROUP BY email HAVING num >= '$passwordMaxRecords' ";

        $passwordHistories = DB::select($selectSql);
        $passwordHistoriesIds = collect($passwordHistories)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array

        $commaList = "";
        foreach ($passwordHistoriesIds as $pHIds) {

            if (!empty($pHIds['id'])) {
                if ($commaList == "") {
                    $commaList .= $pHIds['id'];
                } else {
                    $commaList .= "," . $pHIds['id'];
                }
            }
        }

        $host = request()->getHost();

        $logPath = "";
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'storage/password-histories/';
            //$logPath = 'C:\wamp64\www\pmi-backoffice/storage/password-histories/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/password-histories/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $logPath = '/home/game/public_html/pmi-backoffice/storage/password-histories/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'password-histories-' . $log_date;
        $log = new Logger('PasswordHistories_log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        if (!empty($commaList)) {

            //Log::useFiles(storage_path() . '/password-histories/password-histories-' . date("Y-m-d H:i:s", time()) . '.log');
            if (DB::delete('DELETE FROM password_histories WHERE id NOT IN ( ' . $commaList . ' ) ')) {
                $log->critical('Password Histories deleted ID: ' . $commaList . ' deleted successfully.', []);
                dd('Password Histories deleted ID: ' . $commaList . ' deleted successfully.');
            } else {
                $log->critical('Password Histories deleted ID: ' . $commaList . ' deleted failed.', []);
                dd('Password Histories deleted ID: ' . $commaList . ' deleted failed.');
            }
        } else {
            $log->critical('Password Histories deleted ID: None ', []);
            dd('Password Histories deleted ID: None ');
        }
    }
}
