<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Helpers\SMSDome;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;

class BalanceTakingSMS extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:balance_taking_sms';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command Send SMS to the GPRIC (Balance Taking)';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $logPath = "";
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/balance-taking/sms/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/balance-taking/sms/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $logPath = '/home/game/public_html/pmi-backoffice/storage/balance-taking/sms/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'Balance-Taking-SMS-' . $log_date;
        $log = new Logger('Balance-Taking-SMS-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        $audience = "GPRIC";
        $selectSql = 'SELECT * FROM qa_payout
        WHERE SubChain LIKE "%' . $audience . '%" ';

        $data = DB::select($selectSql);
        $payoutArr = collect($data)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array

        $today = new Carbon();
        $dayOfWeek = $today->dayOfWeek;


        //dayOfWeek = 6; //hardcode

        $startDate = Carbon::createFromFormat('Y-m-d', '2021-10-02');
        $endDate = Carbon::createFromFormat('Y-m-d', '2021-11-20');

        // Testing purpose
        // $knownDate = Carbon::create(2021, 10, 3);
        // Carbon::setTestNow($knownDate);
        // var_dump(Carbon::create(2021, 9, 30, 3)->isBetween($startDate, $endDate));

        $check = Carbon::now()->between($startDate, $endDate);

        // Testing purpose
        //$check = Carbon::create(2021, 11, 20, 3)->between($startDate, $endDate);
        //$dayOfWeek = 0;

        if ($check == true) {

            $log->warning('Start checking... ');
            foreach ($payoutArr as $payout) {

                $custId = $payout['ideCust'];
                $mobileNo = "65" . $payout['mobile_no'];
                $visityDay = $payout['visit_day'];

                //before visity day
                $beforeVisityDayofWeek = $visityDay - 1;
                if ($dayOfWeek == $beforeVisityDayofWeek) {
                    //send SMS
                    echo "Before - $custId - $mobileNo - $beforeVisityDayofWeek (Actual: $visityDay) <br>";

                    $message = "";
                    $message .= "It is important to maintain a healthy in-store inventory to avoid any out-of-stock situation! \n\n Login to sg.pmiandu.com to input your in-store balance inventory of NEXT Red, Blue, Menthol, Red XL, Blue XL as well as Menthol XL today!";
                    $message .= "\n\n\n";
                    $message .= "保持店库存在建康水平，以免出现缺货情况！\n\n请在今天内登录sg.pmiandu.com 输入您店里 NEXT Red、Blue、Menthol、Red XL、Blue XL 和 Menthol XL 的库存余额。";

                    $sms = new SmsDome();

                    //Testing

                    //if ($mobileNo == "6598109360") {
                    //echo "!!!" . $mobileNo . "<br>" . $message;
                    if ($sms->send_sms($mobileNo, $message)) {
                        $log->info($custId . '---' . $mobileNo . ' msg success delivered (' . $message . '), Visity Day: (' . $visityDay . ') Before Visity Day: (' . $beforeVisityDayofWeek . ') ');
                    } else {
                        $log->warning($custId . '---' . $mobileNo . ' msg not delivered (' . $message . ')');
                    }
                    //}
                }

                //after visity day
                // $afterVisityDayofWeek = $visityDay + 1;
                // if ($dayOfWeek == $afterVisityDayofWeek) {
                //     //send SMS
                //     echo "After - $custId - $mobileNo - $afterVisityDayofWeek (Actual: $visityDay) <br>";
                // }

            }
        } else {
            $log->warning('Start date is 2021-10-03. ');
        }
    }
}
