<?php $__env->startSection('content'); ?>

<div class="content-wrapper">

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">User List
                    <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(Session::has($key)): ?>
                    <p class="alert alert-<?php echo e($key); ?> alert-msg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;<?php echo e(Session::get($key)); ?></p>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <a class="btn btn-default" id="emailSendBtn" style="display:none;" data-toggle="modal" data-target="#emailSendModal"></a>

                <div class="col-md-12" style="margin:10px 0;">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add user-creation')): ?>
                    <a href="<?php echo e(route('user-creation.create')); ?>" class="btn btn-default">Create</a>
                    <!--<button type="button" id="deleteUserBtn" class="float-right btn btn-default" data-toggle="modal" data-target="#deleteModal" disabled><i class="fa fa-trash" aria-hidden="true"></i></button>-->
                    <?php endif; ?>
                </div>

                <div class="panel-body">

                    <table id="user-tbl" class="display table-bordered dt-responsive">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Roles</th>
                                <th>Created at</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>

                    <table id="filter-temp-tbl">
                        <thead>
                            <tr></tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="deleteModal" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title"><i class="fa fa-undo" aria-hidden="true"></i> Delete this User?</h4>
                    </div>
                    <div id="modal-body" class="modal-body">
                        <p>Are you sure, you want to delete the selected User?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="confirmDelUser" data-id="" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>

            </div>
        </div>

        <div class="modal fade" id="resetModal" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h4 class="modal-title"><i class="fa fa-undo"></i> Reset this User?</h4>
                    </div>
                    <div id="modal-body" class="modal-body">
                        <p>Are you sure you want to reset the password for the selected user?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="confirmResetUser" data-id="" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>

            </div>
        </div>

        <div class="modal fade" id="emailSendModal" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <br><br>
                        <h4 class="modal-title" id="receiver-name"></h4>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<?php

if (empty($createStatus)){
$createStatus = false;
$msg = "";
}

?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_script'); ?>

<script type="text/javascript">
    $(document).ready(function() {

        var createdStatus = "<?php echo e($createStatus); ?>";
        var msg = "<?php echo e($msg); ?>";

        if (createdStatus == true) {
            $("#receiver-name").html("");
            $("#receiver-name").append('<p class="alert alert-success alert-msg" style="width: 100%;"><i class="fa fa-envelope" aria-hidden="true"></i><br>' + msg + '</p>');
            $("#emailSendBtn").trigger("click");
            createdStatus = false;
            msg = "";
        }

        $("#accordion").accordion({
            collapsible: true,
            active: false
        });


        $('#user-tbl tr').clone(true).appendTo('#filter-temp-tbl thead');
        $('#filter-temp-tbl thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (sms_tbl.column(i).search() !== this.value) {
                    sms_tbl
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });

        $("#confirmResetUser").click(function() {

            var chk_doc_ids = $(this).data("id");

            $.ajax({
                url: "<?php echo e(route('user-creation.reset-user')); ?>",
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    id: chk_doc_ids
                },
                success: function(result) {

                    $("#receiver-name").html("");
                    if (result.status) {
                        //$(".panel-heading").append('<p class="alert alert-success alert-msg"><i class="fa fa-envelope" aria-hidden="true"></i>&nbsp;' + result.message + '</p>');
                        $("#receiver-name").append('<p class="alert alert-success alert-msg"><i class="fa fa-envelope" aria-hidden="true"></i><br>' + result.message + '</p>');

                    } else {
                        $("#receiver-name").append('<p class="alert alert-danger alert-msg" style="width:100%;"><i class="fa fa-envelope" aria-hidden="true"></i><br>User Reset failed.</p>');

                    }

                    $("#emailSendBtn").trigger("click");
                }
            });

            var x$;
            x$ = $(this).data('action');
            $('#multi-form').attr('action', $('#multi-form').data('action') + x$);
            $('#multi-val').val(JSON.stringify({
                action: x$,
                id: $('.dt-check:checked:not(#multi-all)').map(function() {
                    return $(this).val();
                }).get()
            }));

        });

        var sms_tbl = $('#user-tbl').DataTable({
            serverSide: true,
            processing: true,
            bStateSave: true,
            responsive: true,
            autoWidth: false,
            columnDefs: [{
                "targets": [0, 3],
                "orderable": false
            }],
            ajax: {
                url: "<?php echo e(route('user-creation.index')); ?>",
                //type: 'GET',
            },
            language: {
                paginate: {
                    next: '>', // or '→'
                    previous: '<' // or '←' 
                }
            },
            // dom:'<lf<t>ip>',
            columns: [{
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'email',
                    name: 'email'
                },
                {
                    data: 'roles',
                    name: 'roles'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'action',
                    name: 'action'
                }

            ],
            fnDrawCallback: function(oSettings) {

                $(".btn-user-delete").click(function() {
                    /*
                    var chk_doc_ids = $('.dt-check:checked:not(#multi-all)').map(function() {
                        return $(this).val();
                    }).get();
                    */
                    var chkUserId = $(this).data("id");

                    if (chkUserId != "") {
                        $("#modal-body").html("<p>Are you sure, you want to delete the selected User?</p>");
                    } else {
                        $("#modal-body").html("<p>Are you sure, you want to delete the selected User?</p>");
                    }
                    $("#confirmDelUser").attr('data-id', chkUserId);
                    initi_delete(chkUserId, sms_tbl);
                });

                $(".btn-user-reset").click(function() {
                    var chkUserId = $(this).data("id");

                    if (chkUserId != "") {
                        $("#modal-body").html("<p>Are you sure, you want to reset the selected User?</p>");
                    } else {
                        $("#modal-body").html("<p>Are you sure, you want to reset the selected User?</p>");
                    }
                    $("#confirmResetUser").attr('data-id', chkUserId);
                });



            },
            initComplete: function(settings, json) {

            }
        });


        function initi_delete(id, sms_tbl) {
            $("#confirmDelUser").click(function() {

                /*
                var chk_doc_ids = $('.dt-check:checked:not(#multi-all)').map(function() {
                    return $(this).val();
                }).get();
                */

                $.ajax({
                    url: "<?php echo e(route('user-creation.multiple-user')); ?>",
                    type: 'GET',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        id: id
                    },
                    success: function(result) {
                        $(".btn-user-delete").each(function() {
                            if ($(this).data("id") == id) {
                                $(this).parents("tr").remove();
                                sms_tbl.row($(this).parents("tr")).remove().draw();
                                //$(this).parents("tr").remove();
                            }
                        });

                        $(".panel-heading").append('<p class="alert alert-success alert-msg"><i class="fa fa-trash" aria-hidden="true"></i>&nbsp;User deleted successfully.</p>');
                        $(".alert-msg").fadeOut(5500, function() {
                            $(this).remove();
                        });
                    }
                });

                var x$;
                x$ = $(this).data('action');
                $('#multi-form').attr('action', $('#multi-form').data('action') + x$);
                $('#multi-val').val(JSON.stringify({
                    action: x$,
                    id: $('.dt-check:checked:not(#multi-all)').map(function() {
                        return $(this).val();
                    }).get()
                }));

            });

        }

        $('#filter-temp-tbl th input[type=text]').addClass('form-control input-sm').css({
            "width": "100%"
        });
        $('#filter-temp-tbl th:nth-of-type(1) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-1');
        $('#filter-temp-tbl th:nth-of-type(2) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-1');

        $('#filter-container').css({
            'height': '100%'
        });
        $('#filter-temp-tbl thead tr:nth-of-type(2)').css({
            'display': 'none'
        });
        //new $.fn.dataTable.FixedHeader( sms_tbl );
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/hello/backend/pmi-backoffice-my/resources/views/user/index.blade.php ENDPATH**/ ?>