<?php $__env->startSection('content'); ?>

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Roles

                    <?php $__currentLoopData = ['danger', 'warning', 'success', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(Session::has($key)): ?>
                    <p class="alert alert-<?php echo e($key); ?> alert-msg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;<?php echo e(Session::get($key)); ?></p>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <div class="col-md-12" style="margin:10px 0;">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit role')): ?>
                    <a href="#" class="btn btn-default" data-toggle="modal" data-target="#roleModal"> <i class="glyphicon glyphicon-plus"></i> New Role</a>
                    <?php endif; ?>
                    <!--<button type="button" id="deleteDocBtn" class="float-right btn btn-default" data-toggle="modal" data-target="#deleteModal" disabled><i class="fa fa-trash" aria-hidden="true"></i></button>-->
                </div>

                <div class="panel-body">

                    <table id="roles-tbl" class="display table-bordered dt-responsive">
                        <thead>
                            <tr>
                                <th>Role</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>

                    <table id="filter-temp-tbl">
                        <thead>
                            <tr></tr>
                        </thead>
                    </table>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="roleModal" tabindex="-1" role="dialog" aria-labelledby="roleModalLabel">
    <div class="modal-dialog" role="document">
        <?php echo Form::open(['method' => 'post']); ?>


        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h4 class="modal-title" id="roleModalLabel">Role</h4>
            </div>
            <div class="modal-body">
                <!-- name Form Input -->
                <div class="form-group <?php if($errors->has('name')): ?> has-error <?php endif; ?>">
                    <?php echo Form::label('name', 'Name'); ?>

                    <?php echo Form::text('name', null, ['class' => 'form-control', 'placeholder' => 'Role Name']); ?>

                    <?php if($errors->has('name')): ?> <p class="help-block"><?php echo e($errors->first('name')); ?></p> <?php endif; ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                <!-- Submit Form Button -->
                <?php echo Form::submit('Submit', ['class' => 'btn btn-primary']); ?>

            </div>
            <?php echo Form::close(); ?>

        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="deleteModal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-trash" aria-hidden="true"></i> Delete this Role?</h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Are you sure, you want to delete the selected Role?</p>
            </div>
            <div class="modal-footer">
                <button type="button" id="confirmDelRole" data-id="" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_script'); ?>
<script type="text/javascript">
    $(document).ready(function() {

        $("#accordion").accordion({
            collapsible: true,
            active: false
        });

        var roles_tbl = $('#roles-tbl').DataTable({
            serverSide: true,
            processing: true,
            bStateSave: true,
            responsive: true,
            autoWidth: false,
            columnDefs: [{
                "targets": [0, 1],
                "orderable": false
            }],
            ajax: {
                url: "<?php echo e(route('roles.index')); ?>",
                //type: 'GET',
            },
            language: {
                paginate: {
                    next: '>', // or '→'
                    previous: '<' // or '←' 
                }
            },
            // dom:'<lf<t>ip>',
            columns: [{
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'action',
                    name: 'action'
                }

            ],
            fnDrawCallback: function(oSettings) {
                //bindDelete();

                $(".btn-role-delete").click(function() {
                    var chkId = $(this).data("id");

                    if (chkId != "") {
                        $("#modal-body").html("<p>Are you sure, you want to delete the selected Role?</p>");
                    } else {
                        $("#modal-body").html("<p>Are you sure, you want to delete the selected Role?</p>");
                    }
                    $("#confirmDelRole").attr('data-id', chkId);
                    initi_delete(chkId, roles_tbl);
                });
            }
        });

        $('#filter-temp-tbl th input[type=text]').addClass('form-control input-sm').css({
            "width": "100%"
        });
        $('#filter-temp-tbl th:nth-of-type(2) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-1');
        $('#filter-temp-tbl th:nth-of-type(3) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-1');
        $('#filter-temp-tbl th:nth-of-type(5) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-2');
        $('#filter-temp-tbl th:nth-of-type(8) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-2');
        $('#filter-container').css({
            'height': '100%'
        });
        $('#filter-temp-tbl thead tr:nth-of-type(2)').css({
            'display': 'none'
        });

        function initi_delete(chk_ids, roles_tbl) {
            $("#confirmDelRole").click(function() {

                $.ajax({
                    url: "<?php echo e(route('roles.multiple-delete-role')); ?>",
                    type: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        id: chk_ids
                    },
                    success: function(result) {
                        $(".btn-role-delete").each(function() {
                            if ($(this).data("id") == chk_ids) {
                                console.log($(this).parents("tr"));
                                $(this).parents("tr").remove();
                                roles_tbl.row($(this).parents("tr")).remove().draw();
                            }
                        });

                        $(".panel-heading").append('<p class="alert alert-success alert-msg"><i class="fa fa-trash" aria-hidden="true"></i>&nbsp;Role deleted successfully.</p>');
                        $(".alert-msg").fadeOut(5500, function() {
                            $(this).remove();
                        });
                    }
                });

                var x$;
                x$ = $(this).data('action');
                $('#multi-form').attr('action', $('#multi-form').data('action') + x$);
                $('#multi-val').val(JSON.stringify({
                    action: x$,
                    id: $('.dt-check:checked:not(#multi-all)').map(function() {
                        return $(this).val();
                    }).get()
                }));

            });
        }

    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/hello/backend/pmi-backoffice-my/resources/views/role/index.blade.php ENDPATH**/ ?>