<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
Route::get('/', function () {
    return view('auth/login');
});
*/

Route::get('/', ['middleware' => 'guest', function () {
    //Artisan::call('config:clear');
    return view('auth.login');
}]);

Route::get('logout', function () {
    auth()->logout();
    Session()->flush();

    return Redirect::to('/');
})->name('logout');

Route::get('/clear-cache', function () {
    Artisan::call('route:clear');
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('config:cache');

    //Artisan::call('route:cache');
    //Artisan::call('permission:cache-reset');
    return "Cache is cleared";
});

Auth::routes(['register' => false]);

Route::get('/home', 'HomeController@index')->middleware('auth');

Route::get('/reset-password-successfully', function () {
    return view('auth.passwords.reset-success');
});

Route::resource('documentation', 'DocController');
//Route::resource('user-creation', 'UserListController');
Route::resource('permissions', 'PermissionsListController');
Route::resource('permission-groups', 'PermissionGroupsController');
Route::resource('permission-group-maps', 'PermissionGroupMapsController');

Route::group(['middleware' => ['auth']], function () {
    Route::resource('roles', 'RoleController');
    Route::post('multiple-delete-role', ['as' => 'roles.multiple-delete-role', 'uses' => 'RoleController@deleteMultiple']);

    Route::get('my-invoices-logs', '\Rap2hpoutre\LaravelLogViewer\LogViewerController@index')->name('invoice_log');

    //IF password expired all pages redirect to reset password page
    Route::middleware(['password_expired'])->group(function () {
        Route::get('/', function () {
            return redirect()->action('HomeController@index');
        });

        //Game
        // Route::middleware(['can:view game'])->group(function () {
        //     Route::get('game/game-user', 'GameController@game_user')->name('game.game_user');
        //     Route::get('game/game-user-autocomplete', 'GameController@userautoComplete')->name('game-user.autocomplete');

        //     Route::get('game/game-log', 'GameController@game_log')->name('game.game_log');
        //     Route::get('game/game-log-autocomplete', 'GameController@logautoComplete')->name('game-log.autocomplete');
        // });

        Route::resource('user-creation', 'UserListController');
        Route::get('delete-multiple-user', ['as' => 'user-creation.multiple-user', 'uses' => 'UserListController@deleteMultiple']);
        Route::post('user-creation/reset-user', ['as' => 'user-creation.reset-user', 'uses' => 'UserListController@reset_password']);
        Route::get('testEmail', ['as' => 'user-creation.testEmail', 'uses' => 'UserListController@testEmail']);

        //Response Queue
        // Route::middleware(['can:view responseQueue'])->group(function () {
        //     Route::get('response-queue', 'ResponseQueueController@list')->name('res_que.queue_list');
        //     Route::post('response-xml-list', 'ResponseQueueController@chk_response_xml')->name('chk_response_xml');
        //     Route::get('data/response-queue-autocomplete', 'ResponseQueueController@autoComplete')->name('response.autocomplete');
        //     Route::get('response-queue/export', 'ResponseQueueController@export')->name('res_que.export');
        // });

        //Photo Feedback
        Route::middleware(['can:view photo-feedback'])->group(function () {

            Route::resource('photo-feedback/tasks', 'PhotoFeedbackTasksController');
            Route::get('delete-multiple-photo-feedback-tasks', ['as' => 'photo-feedback-task.multiple-delete', 'uses' => 'PhotoFeedbackTasksController@deleteMultiple']);

            Route::resource('photo-feedback/submissions', 'PhotoFeedbackSubmissionsController');
            Route::post('photo-feedback/delete', ['as' => 'photo-feedback.multiple-delete', 'uses' => 'PhotoFeedbackSubmissionsController@deleteMultiple']);
            //Route::get('photo-feedback', 'PhotoFeedbackTasksController@index')->name('photofeedback.list');
            //Route::resource('photo-feedback', 'PhotoFeedbackTasksController');
            //Route::get('data/faulty-dispenser-autocomplete', 'FaultyDispenserController@autoComplete')->name('faulty-dispenser.autocomplete');

            //Photo Feedback (SubChain)
            Route::get('photo-feedback/subchain', 'TradeProgramSubchainController@index');
        });
    });

    // Import Photo Feedback data
    Route::get('photo-feedback/import-pf', 'PfController@importView');
    Route::post('photo-feedback/import-pf', ['as' => 'pf.import', 'uses' => 'PfController@import']);
    Route::get('pf-file-list', ['as' => 'pf.index', 'uses' => 'PfController@index']);

    Route::get('delete-multiple-doc', ['as' => 'documentation.multiple-delete', 'uses' => 'DocController@deleteMultiple']);
    Route::get('delete-multiple-permission', ['as' => 'permission_list.multiple-delete', 'uses' => 'PermissionsListController@deleteMultiple']);

    //Force change password
    Route::get('password/expired', 'Auth\ExpiredPasswordController@expired')
        ->name('password.expired');
    Route::post('password/post_expired', 'Auth\ExpiredPasswordController@postExpired')
        ->name('password.post_expired');

    // Import GT data
    Route::get('import-gt', 'GtController@importView');
    Route::post('import-gt', ['as' => 'gt.import', 'uses' => 'GtController@import']);
    Route::get('gt-file-list', ['as' => 'gt.index', 'uses' => 'GtController@index']);

    // Import KA data
    Route::get('import-ka', 'KaController@importView');
    Route::post('import-ka', ['as' => 'ka.import', 'uses' => 'KaController@import']);
    Route::get('ka-file-list', ['as' => 'ka.index', 'uses' => 'KaController@index']);

    // Import Lead data
    Route::get('import-lead', 'LeadReportController@importView');
    Route::post('import-lead', ['as' => 'lead.import', 'uses' => 'LeadReportController@import']);
    Route::get('lead-file-list', ['as' => 'lead.index', 'uses' => 'LeadReportController@index']);

    // Import GT Past Incentive data
    Route::get('import-gt-past-incentive', 'GtPastIncentiveController@importView');
    Route::post('import-gt-past-incentive', ['as' => 'gt-past-incentive.import', 'uses' => 'GtPastIncentiveController@import']);
    Route::get('gt-past-incentive-file-list', ['as' => 'gt-past-incentive.index', 'uses' => 'GtPastIncentiveController@index']);
});


Route::get('/password/reset/{token}/{email}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');


Route::get('qr-code-g', function () {

    \QrCode::size(500)
        ->format('png')
        ->generate('ItSolutionStuff.com', public_path('images/qrcode.png'));

    return view('coupon.qrcode');
});
