@extends('layouts.master')

@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Edit User details</div>
                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="fa-ul">
                        @foreach ($errors->all() as $error)
                        <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                {{ Form::model($user, array('url' => array('user-creation', $user->id), 'method' => 'PUT')) }}
                <div class="col-md-12" style="margin:10px 0;">
                    {{ Form::submit('Save', array('class' => 'btn btn-default')) }}
                    <a href="{{ URL::to('/user-creation') }}" class="btn btn-default">Back</a>
                </div>

                <div class="panel-body">

                    @php
                    $nameReadonly = ($user->role_id == 1 or !auth()->user()->can('edit user-creation')) ? "readonly" : "";
                    $emailReadonly = ($user->role_id == 1 or !auth()->user()->can('edit user-creation')) ? "readonly" : "";

                    $userAuth = Auth::user();
                    $emailDisable = empty($userAuth->hasRole('Super Admin')) ? true : false;

                    @endphp

                    <div class="form-group">
                        <label for="title">Name</label>
                        <input type="text" name="name" class="form-control" id="name" placeholder="Name" value="{{ $user->name }}" {{ $nameReadonly }}>
                    </div>

                    <div class="form-group">
                        <label for="email">Email</label>

                        @if(!$emailDisable)
                        <input type="email" class="form-control" id="email" name="email" value="{{ $user->email }}" {{ $emailReadonly }} />
                        @else
                        <span class="form-control">{{ $user->email }}</span>
                        @endif
                    </div>

                    <!--
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" name="password" class="form-control" id="password" placeholder="Password" value="">
                        <span class="fa fa-fw fa-eye-slash field-icon toggle-password"></span>
                    </div>

                    <div id="pswd_info">
                        <h4>Password must meet the following requirements:</h4>
                        <ul>
                            <li id="upper" class="invalid">At least <strong>one uppercase letter</strong></li>
                            <li id="lower" class="invalid">At least <strong>one lowercase letter</strong></li>
                            <li id="number" class="invalid">At least <strong>one number</strong></li>
                            <li id="special" class="invalid">At least <strong>one special character</strong></li>
                            <li id="length" class="invalid">Be at least <strong>9 characters</strong></li>
                        </ul>
                    </div>

                    <div class="form-group">
                        <label for="password">Confirm Password</label>
                        <input type="password" name="password_confirmation" class="form-control" id="password-confirmation" placeholder="Confirm password" value="">
                    </div>
                    -->


                    @php
                    $readonlyRoleStatus = true;
                    @endphp

                    @can('edit user-creation-role')
                    @php
                    $readonlyRoleStatus = false;
                    @endphp
                    @endcan

                    @php
                    $disabledRole = ($readonlyRoleStatus == true) ? "disabled" : "" ;
                    @endphp

                    <div class="form-group">
                        <label for="content">Role</label>

                        @php
                        $userAuth = Auth::user();
                        $roleDisable = (!empty($userAuth->hasRole('Super Admin')) || !empty($userAuth->can('edit user-creation-role'))) ? "" : "disabled";
                        @endphp

                        @if(!$roleDisable)
                        <select name="role_id" id="role" class="form-control" data-old="{{ old('roles') }}" {{ $roleDisable }} {{ $disabledRole }}>
                            <option selected disabled>Please Select Role</option>
                            @foreach($roles as $r => $vl)
                            @if ($vl->id == $user->role_id)
                            <option value="{{ $vl->id }}" selected>{{ $vl->name }}</option>
                            @else
                            <option value="{{ $vl->id }}">{{ $vl->name }}</option>
                            @endif
                            @endforeach
                        </select>

                        @else
                        <span class="form-control">
                            @foreach($roles as $r => $vl)
                            @if ($vl->id == $user->role_id)
                            {{ $vl->name }}
                            @endif
                            @endforeach
                        </span>
                        @endif
                    </div>

                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('footer_script')

<script>
    $(".toggle-password").click(function() {

        $(this).toggleClass("fa-eye-slash fa-eye");

        if ($(this).parent().find('#password').attr("type") == "password") {
            $(this).parent().find('#password').attr("type", "text");
            $('#password-confirmation').attr("type", "text");
        } else {
            $(this).parent().find('#password').attr("type", "password");
            $('#password-confirmation').attr("type", "password");
        }
    });
</script>

@push('scripts')
<script src="{{ asset('js/pswd/validate.js')}}"></script>
@endpush

@endsection