@extends('layouts.master')

@section('title', 'Roles & Permissions')

@section('content')
<!-- Modal -->
<div class="modal fade" id="roleModal" tabindex="-1" role="dialog" aria-labelledby="roleModalLabel">
    <div class="modal-dialog" role="document">
        {!! Form::open(['method' => 'post']) !!}

        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h4 class="modal-title" id="roleModalLabel">Role</h4>
            </div>
            <div class="modal-body">
                <!-- name Form Input -->
                <div class="form-group @if ($errors->has('name')) has-error @endif">
                    {!! Form::label('name', 'Name') !!}
                    {!! Form::text('name', null, ['class' => 'form-control', 'placeholder' => 'Role Name']) !!}
                    @if ($errors->has('name')) <p class="help-block">{{ $errors->first('name') }}</p> @endif
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                <!-- Submit Form Button -->
                {!! Form::submit('Submit', ['class' => 'btn btn-primary']) !!}
            </div>
            {!! Form::close() !!}
        </div>
    </div>
</div>


<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Roles

                    @role('Super Admin')
                    <a href="#" class="btn btn-default pull-right" data-toggle="modal" data-target="#roleModal" style="margin-top:-4px;"> <i class="glyphicon glyphicon-plus"></i> New Role</a>
                    @endrole

                </div>

                @php
                /*
                $arr_role = [];

                foreach ($roles as $role){
                array_push($arr_role, $role->id) ;

                }
                */
                @endphp


                @forelse ($roles as $role)

                @if($role->id == $id)
                {!! Form::model($role, ['method' => 'PUT', 'route' => ['roles.update', $role->id ], 'class' => 'm-b roles-accordion']) !!}

                @if($role->name === 'Super Admin')
                @include('shared._permissions', [
                'title' => $role->name .' Permissions',
                'options' => ['disabled'] ])
                @else
                @if (Auth::user()->can('edit user-creation-role'))
                {{Form::submit('Save', ['class' => 'btn btn-default'])}}
                @endif
                @include('shared._permissions', [
                'title' => $role->name .' Permissions',
                'model' => $role ])

                @endif

                {!! Form::close() !!}
                @endif
                @empty
                <p>No Roles defined, please run <code>php artisan db:seed</code> to seed some dummy data.</p>
                @endforelse

            </div>
        </div>
    </div>
</div>

@endsection