<html>

<head>
    <title>PMI NEXT PHOTO FEEDBACK (Sept)</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Roboto', sans-serif;
            font-weight: 500;
            width: 100%;
            /* height: 100vh; */
            /* display: flex;
            align-items: center; */
            /* justify-content: center; */
            overflow: hidden;
            max-height: 225px;
            margin: 0;
            overflow-y: hidden;
        }

        .image-container {
            padding: 0;
            margin: 0;
        }

        .img-banner {
            border-radius: 12px;
        }

        .slds-is-relative>div>iframe {
            box-shadow: 0px 0px 0px rgba(0, 0, 0, 0);
        }

        #img-container {
            position: relative;
            height: auto;
            top: -46px;
            right: 14px;
            float: right;
            width: 110px;
        }

        #img-btn {
            width: 100%;
            height: 32px;
            border-radius: 20px;
            cursor: pointer;
            background-color: <?= $data['button_color']; ?>;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #ffffff !important;
            font-family: "Roboto";
            font-size: 12px;
            font-weight: 700;
            text-align: center;
            text-transform: uppercase;
        }

        .remaining {
            color: #c7271b;
            text-align: center;
            display: inline-block;
            margin-top: -24px;
            width: 100%;
            font-size: 12px;
        }

        .img-failed {
            -webkit-filter: grayscale(100%);
            -moz-filter: grayscale(100%);
            -o-filter: grayscale(100%);
            -ms-filter: grayscale(100%);
            filter: grayscale(100%);
        }

        @media only screen and (min-device-width: 320px) and (max-device-width: 568px) and (-webkit-device-pixel-ratio: 2) and (device-aspect-ratio: 40/71) and (orientation:portrait) #img-container {
            width: 100px;
        }

        #img-btn {
            font-size: 11px;
        }

        }
    </style>


</head>

<body>

    @if ($data['success'] == true)
    @if ($data['task_over'] == false)

    <div class="image-container"><img class='img-banner' src="{{ $data['img'] }}" alt="" width="100%"></div>
    @if ($data['coming_soon'] == false)
    <a id="btn-link" href="{{ $data['snap_url'] }}" target="_parent">
        @else
        <a id="btn-link">
            @endif
            <!--<a href="https://sg.pmiandu.com/s/Learn/MarlboroFreshIBBM/Snap" target="_blank">-->
            <div id="img-container">
                <div id="img-btn">{!! $data['button_text'] !!}</div>
            </div>
        </a>
        <div class="remaining">{{ $data['remain_day'] }}</div>
        @endif
        @endif

</body>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script>
    $(document).ready(function() {

        //var query = getUrlParameter('query');
        var base_url = "localhost";
        var taskId = "{{ $data['task'] }}";

        $("#btn-link").click(function() {
            $.ajax({
                method: "GET",
                url: '/pmi-backoffice/public/api/photo-feedback-task/store-task',
                data: {
                    task_id: taskId,
                }
            }).done(function(data) {
                console.log(data);
                console.log(data.message);
            })

        });
    });
</script>


</html>