
@extends('layouts.master')

@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Create Permission</div>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="fa-ul">
                            @foreach ($errors->all() as $error)
                                <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                {{ Form::open(array('url' => 'permissions')) }}
                <div class="col-md-12" style="margin:10px 0;">
                    {{ Form::submit('Save', array('class' => 'btn btn-default')) }}
                    <a href="{{ URL::previous() }}" class="btn btn-default">Back</a>
                </div>
  

                <div class="panel-body">

                    <div class="form-group">
                        <label for="title">Permission Name</label>
                        <input type="text" name="name" class="form-control" id="title"  value="{{ old('name') }}">
                    </div>

                    <!--
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea class="form-control" id="description" name="description">{{ old('description') }}</textarea>
                    </div>

                    <div class="form-group">
                        <label for="content">Status</label>
                        <select name="status" class="form-control">
                            {{-- 
                            @foreach($status as $s => $vl)
                            <option value="{{ $s }}">{{ $vl }}</option>
                            @endforeach
                            --}}
                        </select>
                    </div>
                    -->

                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection

