
@extends('layouts.master')



@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Edit Permission Group Maps</div>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="fa-ul">
                            @foreach ($errors->all() as $error)
                                <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                {{ Form::model($pgm, array('url' => array('permission-group-maps', $id), 'method' => 'PUT')) }}
                <div class="col-md-12" style="margin:10px 0;">
                    {{ Form::submit('Save', array('class' => 'btn btn-default')) }}
                    <a href="{{ URL::previous() }}" class="btn btn-default">Back</a>
                </div>
  

                <div class="panel-body">

                    <div class="form-group">

                            @foreach($permissions as $perm)
                            <?php
                                $per_found = null;

                                if( in_array($perm->name, $permission_names) ) {
                                    $per_found =true;
                                }

                            ?>

                            <div class="col-md-3">
                                <div class="checkbox">
                                    <label class="{{ str_contains($perm->name, 'delete') ? 'text-danger' : '' }}">
                                        {!! Form::checkbox("permissions[]", $perm->id, $per_found, isset($options) ? $options : []) !!} {{ $perm->name }}
                                    </label>
                                </div>
                            </div>
                        @endforeach
                    </div>

                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection
