<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBalanceTakingSkuTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('balance_taking_sku', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('sku_name');
            $table->integer('brand')->comment('1: L&M, 2: Marlboro, 3: NEXT, 4: Virginia , 5: Sampoerna');
            $table->string('group_name')->comment('1: 15 SKUs, 2: 30 SKUs');
            //$table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('balance_taking_sku');
    }
}
