<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreatePhotoFeedbackInvoicesSms extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('photo_feedback_invoices_sms', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('cust_id', 255);
            $table->integer('int_visity_day');
            $table->string('order_status', 50)->nullable();
            $table->date('invoice_date')->nullable();
            $table->date('request_date')->nullable();
            $table->string('business_order_type', 50)->nullable();
            $table->timestamp('created_at');
        });

        DB::statement('ALTER TABLE photo_feedback_invoices_sms CHANGE cust_id cust_id INT(5) UNSIGNED ZEROFILL NOT NULL');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('photo_feedbnack_invoices_sms');
    }
}
