<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class CreatePhotoFeedbackSubmissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('photo_feedback_submissions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('cust_id', 255);
            $table->string('contact_no', 255);
            $table->string('contact_id', 255);
            $table->string('locale', 15);
            $table->longText('imgs');
            $table->tinyInteger('status')->comment('0: Disapproved, 1: Approved');
            $table->dateTime('points_submitted')->nullable()->comment('NULL: Failed, NOT NULL: Success');
            $table->integer('points')->nullable();
            $table->dateTime('send_to_dte')->nullable();
            $table->dateTime('add_to_dte')->nullable();
            $table->longText('dte_message')->nullable();
            $table->integer('checked_by')->nullable();
            $table->dateTime('checked_datetime')->nullable();
            $table->softDeletes('deleted_at', 0);
            $table->timestamps();
        });

        //DB::statement('ALTER TABLE photo_feedback_submissions CHANGE cust_id cust_id INT(5) UNSIGNED ZEROFILL NOT NULL');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('photo_feedback_submissions');
    }
}
