<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTradeProgramStage extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trade_program_stage', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('stage_name_id');
            $table->bigInteger('trade_program_id');
            $table->text('retailer_clusters_banner_id');
            $table->date('start_date');
            $table->date('end_date');
            $table->tinyInteger('price_recog');
            $table->string('price_sku', 255);
            $table->bigInteger('incremental_stage')->nullable()->comment('reference from stage name id');
            $table->tinyInteger('status')->comment('0: Active, 1: Inactive');
            $table->softDeletes();
            $table->timestamps();
        });

        Schema::table('trade_program_stage', function ($table) {
            $table->foreign('stage_name_id')->references('id')->on('trade_program_stage_name');
            $table->foreign('trade_program_id')->references('id')->on('trade_program');
            //$table->foreign('retailer_clusters_id')->references('id')->on('trade_program_retailer_clusters');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stage');
    }
}
