<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTradeProgramMechanics extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trade_program_mechanics', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('target_program_code', 45)->nullable();
            $table->tinyInteger('show_payout');
            $table->string('cap_program_code', 45)->nullable();
            $table->tinyInteger('cap_payout_show');
            $table->string('increment_program_code', 45)->nullable();
            $table->tinyInteger('increment_payout_show');
            //$table->bigInteger('increment_stage_1')->nullable();
            $table->timestamps();
        });

        /*
        Schema::table('trade_program_mechanics', function ($table) {
            $table->foreign('increment_stage_1')->references('id')->on('trade_program_stage');
        });
        */
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mechanics');
    }
}
