<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        'App\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        // Implicitly grant "Super Admin" role all permissions
        // This works in the app by using gate-related functions like auth()->user->can() and @can()
        Gate::before(function ($user, $ability) {
            return $user->hasRole('Super Admin') ? true : null; //superadmin
        });

        //Data
        Gate::define('view data', function ($user) {
            return $user->hasPermissionTo('view data');
        });

        //Game
        Gate::define('view game', function ($user) {
            return $user->hasPermissionTo('view game');
        });

        //Response Queue
        Gate::define('view responseQueue', function ($user) {
            return $user->hasPermissionTo('view responseQueue');
        });

        //Trade Program Permission
        Gate::define('view trade-program', function ($user) {
            return $user->hasPermissionTo('view trade-program');
        });

        //Faulty Dispenser Permission
        Gate::define('view faulty-dispenser', function ($user) {
            return $user->hasPermissionTo('view faulty-dispenser');
        });

        //Photo Feedback Permission
        Gate::define('view photo-feedback', function ($user) {
            return $user->hasPermissionTo('view photo-feedback');
        });

        //Subchain
        Gate::define('view subchain', function ($user) {
            return $user->hasPermissionTo('view subchain');
        });
    }
}
