<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class PhotoFeedbackTasksModel extends Model
{
    use SoftDeletes;

    protected $table = 'photo_feedback_tasks';
    private static $tableName = 'photo_feedback_tasks';
    private static $subchainTableName = 'trade_program_subchain';

    // public static function chkDuration($subchain)
    // {

    //     $sql = "SELECT duration, title, descr, campaign_url FROM " . static::$tableName . "
    //             LEFT JOIN " . static::$subchainTableName . " ON FIND_IN_SET (" . static::$subchainTableName . ".id, " . static::$tableName . ".subchain_id)
    //             WHERE " . static::$subchainTableName . ".name = '" . $subchain . "'";

    //     $submissions = DB::select($sql);
    //     return collect($submissions)->map(function ($x) {
    //         return (array) $x;
    //     })->toArray(); //return array
    // }

    public static function chkPoints($subchain)
    {

        $sql = "SELECT points FROM " . static::$tableName . "
                LEFT JOIN " . static::$subchainTableName . " ON FIND_IN_SET (" . static::$subchainTableName . ".id, " . static::$tableName . ".subchain_id)
                WHERE TRIM(" . static::$subchainTableName . ".name) = TRIM('" . $subchain . "') ";

        $submissions = DB::select($sql);
        return collect($submissions)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array
    }

    public static function getTaskData($subchain)
    {

        $sql = "SELECT 
                " . static::$tableName . ".id,
                title, 
                descr, 
                campaign_url,
				snap_url,
                transaction_descr,
                points,
                start_datetime,
                end_datetime,
                reminder_datetime,
                approval_sms_en, 
                approval_sms_ch, 
                rejection_sms_en, 
                rejection_sms_ch, 
                task_expired_sms_en, 
                task_expired_sms_ch,
                reminder_sms_en,
                reminder_sms_ch
                FROM " . static::$tableName . "
                LEFT JOIN " . static::$subchainTableName . " ON FIND_IN_SET (" . static::$subchainTableName . ".id, " . static::$tableName . ".subchain_id)
                WHERE TRIM(" . static::$subchainTableName . ".name) = TRIM('" . $subchain . "') AND
                NOW() BETWEEN start_datetime AND end_datetime";

        $submissions = DB::select($sql);
        return collect($submissions)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array
    }

    public static function getTaskDataById($id)
    {

        $sql = "SELECT 
                " . static::$tableName . ".id,
                title, 
                descr, 
                campaign_url,
				snap_url,
                banner_img,
                banner_img_ch,
                subchain_id,
                transaction_descr,
                points,
                options,
                start_datetime,
                end_datetime,
                reminder_datetime,
                task_duration,
                reminder_sms_day,
                dynamic_end_datetime,
                approval_sms_en, 
                approval_sms_ch, 
                rejection_sms_en, 
                rejection_sms_ch, 
                task_expired_sms_en, 
                task_expired_sms_ch,
                reminder_sms_en,
                reminder_sms_ch
                FROM " . static::$tableName . "
                LEFT JOIN " . static::$subchainTableName . " ON FIND_IN_SET (" . static::$subchainTableName . ".id, " . static::$tableName . ".subchain_id)
                WHERE " . static::$tableName . ".id = " . $id . " ";

        $submissions = DB::select($sql);
        return collect($submissions)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array
    }

    // public static function getReminderSMSTemplates($subchain)
    // {
    //     $sql = "SELECT 
    //     reminder_sms_en, 
    //     reminder_sms_ch 
    //     FROM " . static::$tableName . "
    //     LEFT JOIN " . static::$subchainTableName . " ON FIND_IN_SET (" . static::$subchainTableName . ".id, " . static::$tableName . ".subchain_id)
    //     WHERE TRIM(" . static::$subchainTableName . ".name) = TRIM('" . $subchain . "') ";

    //     $submissions = DB::select($sql);
    //     return collect($submissions)->map(function ($x) {
    //         return (array) $x;
    //     })->toArray(); //return array
    // }
}
