<?php

namespace App\Imports;

use App\Models\Gt_buy;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Carbon;

class GTBuyImport implements ToModel, WithStartRow, WithMultipleSheets
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function sheets(): array
    {
        return [
            'Buy' => $this,
        ];
    }

    public function model(array $row)
    {

        if ($row[0] != "" and $row[1] != "" and $row[2] != "" and $row[3] != "") {
            return new Gt_buy([
                'customer_code'     => $row[0],
                'customer_name'    => $row[1],
                'base_target_month' => $row[2],
                'base_target'    => $row[3],
                'product_price_segment_descr'    => $row[4],
                'product_family_descr'    => $row[5],
                'time_id'  => $row[6],
                'ims'  => $row[7],
                'created_at' => Carbon::now()->format('Y-m-d H:i:s')

            ]);
        }
    }

    public function startRow(): int
    {
        return 2;
    }

    public function batchSize(): int
    {
        return 500;
    }

    public function chunkSize(): int
    {
        return 1000;
    }
}
