<?php

namespace App\Http\Controllers;

use App\Role;
use App\Permission;
use App\Authorizable;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Session;
use URL;


class RoleController extends Controller
{
    use Authorizable;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (request()->ajax()) {
            $roles = DB::connection('mysql')
                ->table('roles')
                ->select(['id', 'name'])
                ->whereNull('deleted_at');

            return datatables()->of($roles)
                /*
                ->addColumn('status', function($row) {
                    return $this->status[$row->status];
                })
                */
                ->addColumn('action', function ($row) {
                    if (auth()->user()->can('edit roles')) {
                        $editBtn = "<a href='" . URL::to("roles/" . $row->id . "/edit") . "' class='btn btn-default'>Edit</a>";
                        $deleteBtn = "<a data-id=" . $row->id . " class='btn btn-default btn-role-delete' data-toggle='modal' data-target='#deleteModal' >Delete</a>";
                        return $editBtn . "  " . $deleteBtn;
                    }
                })
                ->rawColumns(['action'])
                ->make();
        }

        return view('role.index');
        /*
        $roles = Role::all();
        $permissions = Permission::all();

        return view('role.index', compact('roles', 'permissions'));
        */
    }

    public function show()
    {
        return view('role.index');
    }

    public function store(Request $request)
    {
        $this->validate($request, ['name' => 'required|unique:roles']);

        if (Role::create($request->only('name'))) {
            Session::flash('Role Added');
        }

        return redirect()->back();
    }

    public function edit($id)
    {
        $pgm = DB::connection('mysql')
            ->table('permission_group')
            ->leftJoin('permission_group_maps', 'permission_group_maps.permission_group_id', '=', 'permission_group.id')
            ->leftJoin('permissions', 'permission_group_maps.permission_id', '=', 'permissions.id')
            ->select(['permission_group.id', DB::raw('group_concat(permissions.id) as permission_id'), 'permission_group.description as pg_name'])
            ->groupBy('description')
            ->get();

        //$role = Role::find($id);
        $roles = Role::all();
        $permissions = Permission::all();

        return view('role.edit', compact('id', 'roles', 'permissions', 'pgm'));
    }

    public function update(Request $request, $id)
    {
        if ($role = Role::findOrFail($id)) {
            // admin role has everything
            if ($role->name === 'Super Admin') {
                $role->syncPermissions(Permission::all());
                return redirect()->route('roles.index');
            }

            $permissions = $request->get('permissions', []);
            $role->syncPermissions($permissions);
            Session::flash('success', $role->name . ' permissions has been updated.');
        } else {
            Session::flash()->error('Role with id ' . $id . ' note found.');
        }

        return redirect()->route('roles.index');
    }

    public function deleteMultiple(Request $request)
    {
        $id = $request->id;

        $role = DB::table('roles')
            ->select('name')
            ->where('id', $id)->first();

        Role::where('id', $id)->delete();

        //$user->removeRole('writer');
        return response()->json(['status' => true, 'message' => "Role (" . $role->name . ") deleted successfully."]);
    }
}
