<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Authorizable;
use App\ResponseQueueModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Illuminate\Support\Facades\Input;
use Symfony\Component\HttpFoundation\Response;
use View;
use Rap2hpoutre\FastExcel\FastExcel;
//use Box\Spout\Writer\Common\Creator\Style\StyleBuilder;
use Box\Spout\Writer\Style\StyleBuilder;


class ResponseQueueController extends Controller
{

    //use Authorizable;

    public function __construct()
    {
        //$this->middleware('auth');
    }

    function _logging($message, $action, $additional_messages = [])
    {
        ///////////////Logging/////////////////////		
        $log_date = Carbon::now()->format('Ymd');
        $log_name = 'CCB2B_Order_log_' . $log_date;
        $log = new Logger('EmailRetailer_log');
        $log->pushHandler(new StreamHandler(ORDER_LOG_PATH . $log_name . '.log'));
        ///////////////Logging/////////////////////

        switch ($action) {
            case 'Error':
                $log->error($message, $additional_messages);
                break;
            case 'Warning':
                $log->warning($message, $additional_messages);
                break;
            case 'Info':
                $log->info($message, $additional_messages);
                break;
            case 'Emergency':
                $log->emergency($message, $additional_messages);
                break;
            case 'Notice':
                $log->notice($message, $additional_messages);
                break;
            case 'Critical':
                $log->critical($message, $additional_messages);
                break;
            default:
                $log->info($message, $additional_messages);
                break;
        }
    }

    public function content(Request $request)
    {

        $id = $request->id;
        $res = ResponseQueueModel::find_by_id($id);

        $xml_data = html_entity_decode($res[0]['xml_data']);
        //$xml_data = htmlspecialchars($xml_data, ENT_QUOTES, 'UTF-8', false);
        $xml_data = htmlentities($xml_data, ENT_QUOTES, 'UTF-8');
        $res[0]['xml_data'] = $xml_data;
        return response()->json(['data' => $res[0]]);
    }

    public function list()
    {
        if (request()->ajax()) {
			
			$request = request();
			$requestAll = $request->all();
			$orderBy = isset($requestAll['order'][0]['column']) ? $requestAll['order'][0]['column'] : NULL;
			$orderOption = isset($requestAll['order'][0]['dir']) ? $requestAll['order'][0]['dir'] : NULL;
			
			$columns = array(
				//0 => 'id',
				0 => 'response_id',
				1 => 'response_name',
				2 => 'response_status',
				3 => 'error_status_code',
				4 => 'error_message',
				5 => 'created_datetime');
			
			if (!is_null($orderBy)):
				$orderBy = $columns[$orderBy];
			endif;
			
			//print_r($request->all());
			
            $order_xml = DB::connection('mysql')
                ->table('ccb2b_response_queue')
                ->select(['id', 'response_id', 'response_name', 'response_status', 'error_status_code', 'error_message', 'created_datetime'])
				->orderBy($orderBy, $orderOption);

            return datatables()->of($order_xml)
                ->addColumn('chk_id', function ($row) {
                    return "<input type='checkbox' name='xml-chk-" . $row->id . "' id='xml-chk-" . $row->id . "' value='" . $row->id . "' class='dt-check'>
                        <label for='xml-chk-" . $row->id . "'>
                            <span></span>
                        </label>";
                })
                ->addColumn('action', function ($row) {

                    $exportBtn = auth()->user()->can('export responseQueue') ? "<a data-id='" . $row->id . "' class='btn btn-default export-xml-btn' data-target='#exportSingleModal' >Export</a>" : "";
                    $viewBtn = auth()->user()->can('view responseQueue') ? "<a data-id='" . $row->id . "' data-toggle='modal' data-target='#viewModal' class='btn btn-default view-res-btn' >View</a>" : "";
                    //return $exportBtn . "  " . $viewBtn;
                    return $viewBtn;
                })
                ->rawColumns(['chk_id', 'action'])
                ->make(true);
        }

        return view('response_queue.list');
    }

    public function autoComplete()
    {

        $name = Input::get('name');
        $value = Input::get('value');

        switch ($name) {
            case "ID";
                $column_name = "id";
                break;
            case "API Name";
                $column_name = "response_name";
                break;
            case "Response";
                $column_name = "response_status";
                break;
            case "Message";
                $column_name = "error_message";
                break;
            case "XML Data";
                $column_name = "xml_data";
                break;
        }

        $data = DB::select(DB::raw("SELECT DISTINCT (" . $column_name . ") FROM ccb2b_response_queue WHERE " . $column_name . "  LIKE " . " '%" . $value . "%' "));
        if ($data) {

            $data_arr = array();
            foreach ($data as $d) {
                //array_push($data_arr, $d->ideCust);
                $data_arr[$d->{$column_name}] = $d->{$column_name};
            }

            return $data_arr;
        }
    }

    /*
    public function list_export_response_xml(Request $request)
    {

        if ($request->input()) {
            $xml_id = $request->input('xml_id');

            $xml_data = ResponseQueueModel::xml_data_by_id($xml_id);

            $total = 0;
            $xml_filename_arr = array();
            //$xml_path = ORDERS_FROM_CCB2B_PATH;
            if (!empty($xml_data)) {

                $total = count($xml_data);
                foreach ($xml_data as $xdata) {

                    $datetime = Carbon::now()->format('YmdHis');

                    Storage::disk('ccb2b_order')->put($datetime . "-" . $xdata['response_name'], $xdata['xml_data']);
                    $this->_logging('Successfully export XML (id:' . $xdata['id'] . ', ' . $xdata['response_name'] . ')', 'Info');
                }
            } else {
                return response()->json(array(
                    'success' => TRUE,
                    'total' => 0,
                    'xml_filenames' => array('None'),
                ), 200);
            }

            return response()->json(array(
                'success' => TRUE,
                'total' => $total,
                'xml_filenames' => $xml_filename_arr,
            ), 200);
        }
    }
    */

    public function response_log()
    {

        $domain = $_SERVER['HTTP_HOST'];
        if (strstr($domain, 'localhost') || strstr($domain, '192.168')) {
            $orderlog_arr = scandir("C:/wamp64/www/pmi-ccb2b/logs/response_queue");
        } else if (strstr($domain, 'games.pmisg.cloud.sg')) {
            $orderlog_arr = scandir("/home/game/domains/games.pmisg.cloud.sg/public_html/pmi-ccb2b/logs/response_queue");
        } else if (strstr($domain, 'games-staging.pmisg.cloud.sg')) {
            $orderlog_arr = scandir("/home/gamestg/domains/games-staging.pmisg.cloud.sg/public_html/pmi-ccb2b/logs/response_queue");
        } else {
            $orderlog_arr = scandir("/var/www/html/pmi-ccb2b/logs/response_queue");
        }

        unset($orderlog_arr[0]);
        unset($orderlog_arr[1]);
        $orderlog_dir_arr = array_values($orderlog_arr);
        rsort($orderlog_dir_arr);

        $firstorder_log = reset($orderlog_dir_arr);

        //return view('ccb2b.orderlog');
        $data = compact("orderlog_dir_arr", "firstorder_log");

        return View::make('response_queue.logs')->with('data', $data);;
    }

    public function responselog_list(Request $request)
    {
        $log_content = "";
        $input = $request->all();
        $log_name = $input["log_name"];

        $domain = $_SERVER['HTTP_HOST'];
        if (strstr($domain, 'localhost') || strstr($domain, '192.168')) {
            $log_path = "C:/wamp64/www/pmi-ccb2b/logs/response_queue/$log_name";
        } else if (strstr($domain, 'games.pmisg.cloud.sg')) {
            $log_path = "/home/game/domains/games.pmisg.cloud.sg/public_html/pmi-ccb2b/logs/response_queue/$log_name";
        } else if (strstr($domain, 'games-staging.pmisg.cloud.sg')) {
            $log_path = "/home/gamestg/domains/games-staging.pmisg.cloud.sg/public_html/pmi-ccb2b/logs/response_queue/$log_name";
        } else {
            $log_path = "/var/www/html/pmi-ccb2b/logs/response_queue/$log_name";
        }

        $log_url = "logs/response_queue/$log_name";

        $myfile = fopen($log_path, "r") or die("Unable to open file!");
        while (!feof($myfile)) {
            $log_content .= fgets($myfile) . "<br />";
        }
        fclose($myfile);
        return response()->json(array(
            'success' => TRUE,
            'log_path' => $log_url,
            'log_name' => $log_name,
            'log_content' => $log_content
        ), 200);
        //$query = $_GET['query'];
    }

    public function export(Request $request)
    {
        ini_set('memory_limit', '2048M');
        ini_set('max_execution_time', 0);
        ini_set('request_terminate_timeout ', 0);

        $responseId = $request->input('response_id');
        $responseName = $request->input('response_name');
        $responseStatus = $request->input('response_status');
        $createdDatetime = $request->input('created_datetime');

        $header_style = (new StyleBuilder())->setFontBold()->build();

        /*
        $rows_style = (new StyleBuilder())
            ->setFontSize(15)
            ->setShouldWrapText()
            ->setBackgroundColor("EDEDED")
            ->build();
        */

        return (new FastExcel($this->responseGenerator($responseId, $responseName, $responseStatus, $createdDatetime)))
        ->headerStyle($header_style)
        //->rowsStyle($rows_style)
        ->download('Response_queue_' . date('Y-m-d h:i:sa') . '.csv');

        //Excel::store($this->smsGenerator(), 'laravelexcel.csv');

        //return Excel::download($this->smsGenerator(), 'SMS.csv');
    }

    public function responseGenerator($responseId = NULL, $responseName = NULL, $responseStatus = NULL, $createdDatetime = NULL)
    {

        $query = DB::connection('mysql')->table('ccb2b_response_queue')
            ->where(function ($query) use ($responseId, $responseName, $responseStatus, $createdDatetime) {
                if (!empty($responseId)) {
                    $query->where('response_id', 'LIKE', '%' . $responseId . '%');
                }
                
                if (!empty($responseName)) {
                    $query->where('response_name', 'LIKE', '%' . $responseName . '%');
                }

                if (!empty($responseStatus)) {
                    $query->where('response_status', 'LIKE', '%' . $responseStatus . '%');
                }

                if (!empty($createdDatetime)) {
                    $query->where('created_datetime', 'LIKE', '%' . $createdDatetime . '%');
                }
            });

        //foreach (SMS_Model::cursor() as $sms) {
        foreach ($query->cursor() as $sms) {
            yield $sms;
        }

        /*
        SMS_Model::chunk(1000, function($data)
        {
            foreach ($data as $sms)
            {
                yield $sms;
            }
        });
        */
    }
}
