<?php

namespace App\Http\Controllers;

use App\Helpers\DTEdecode;
use App\Helpers\SMSDome;

use App\User;
use App\PhotoFeedbackSubmissionsModel;
use App\PhotoFeedbackInvoicesSMS;
use App\PhotoFeedbackInvoicesPublish;
use App\PhotoFeedbackErrorMsg;
use App\Payout;
use App\Invoices;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use URL;
use View;
use Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Input;
use Validator, Redirect, Response, File;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Mail;
use Cache;

use Rap2hpoutre\FastExcel\FastExcel;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\PhotoFeedbackInvoicesSMSImport;
use App\PhotoFeedbackTasksModel;
use App\Subchain;

class PhotoFeedbackSubmissionsController extends Controller
{

    public $QACliendId = '9b343f4ee91a434fbda4ab3b82d08d10';
    public $QAClientSecret = '49D1a1b09e934A8387c0291f8774987D';

    public $ProCliendId =  '4a2dbd8c61a14e2ca2718985ad835c0f';
    public $ProCliendSecret =  '279a89CE72704bdba0610cd8147DBA61';

    public $staticOption = 1;
    public $dynamicOption = 2;

    //public $eventStartDate =  '2021-07-26';
    //public $eventEndDate =  '2021-08-08 23:59';

    public $allowed_image_extension = array(
        "png",
        "jpg",
        "jpeg",
        "gif",
        "PNG",
        "JPG",
        "JPEG",
        "GIF"
    );

    public function formatSizeUnits($bytes)
    {
        if ($bytes >= 1073741824) {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        } elseif ($bytes >= 1048576) {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        } elseif ($bytes >= 1024) {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        } elseif ($bytes > 1) {
            $bytes = $bytes . ' bytes';
        } elseif ($bytes == 1) {
            $bytes = $bytes . ' byte';
        } else {
            $bytes = '0 bytes';
        }

        return $bytes;
    }

    public function chkdomain()
    {
        $domain = $_SERVER['HTTP_HOST'];
        if (strstr($domain, 'localhost') || strstr($domain, '192.168') || strstr($domain, 'wamp64')) {
            $tradeProgramImgsPath = public_path("imgs/photo-feedback/");
        } else if (strstr($domain, 'games.pmisg.cloud.sg')) {
            $domainPath = explode("/", public_path());
            $path1 = $domainPath[0];
            $path2 = $domainPath[1];
            $path3 = $domainPath[2];
            $path4 = $domainPath[3];
            $path5 = $domainPath[4];
            $path6 = $domainPath[5];
            $path7 = $domainPath[6];
            $path8 = $domainPath[7];

            $tradeProgramImgsPath = $path1 . "/" . $path2 . "/" . $path3 . "/" . $path4 . "/" . $path5 . "/" . $path6  . "/" . $path7 . "/" . $path8 . "/" . "imgs/photo-feedback/";
        } else if (strstr($domain, 'games-staging.pmisg.cloud.sg')) {

            $domainPath = explode("/", public_path());
            $path1 = $domainPath[0];
            $path2 = $domainPath[1];
            $path3 = $domainPath[2];
            $path4 = $domainPath[3];
            $path5 = $domainPath[4];
            $path6 = $domainPath[5];
            $path7 = $domainPath[6];
            $path8 = $domainPath[7];

            $tradeProgramImgsPath = $path1 . "/" . $path2 . "/" . $path3 . "/" . $path4 . "/" . $path5 . "/" . $path6  . "/" . $path7 . "/" . $path8 . "/" . "imgs/photo-feedback/";
        }

        return $tradeProgramImgsPath;
    }

    public function index()
    {
        if (request()->ajax()) {

            $dispenser = DB::connection('mysql')
                ->table('photo_feedback_submissions')
                ->select([
                    'photo_feedback_submissions.id',
                    'photo_feedback_submissions.task_id',
                    'photo_feedback_submissions.cust_id',
                    'photo_feedback_tasks.name',
                    'qa_payout.SubChain as subchain',
                    'photo_feedback_submissions.status',
                    'photo_feedback_submissions.created_at',
                ])
                //->distinct('photo_feedback_submissions.id')
                ->leftJoin('qa_payout', function ($join) {
                    $join->whereRaw("qa_payout.ideCust = photo_feedback_submissions.cust_id");
                    //$join->whereRaw("qa_payout.ideCust = SUBSTRING(photo_feedback_submissions.cust_id, 3)");
                })
                ->leftJoin('trade_program_subchain', function ($join) {
                    $join->whereRaw(" TRIM(trade_program_subchain.name) = TRIM(qa_payout.subchain) ");
                })
                ->leftJoin('photo_feedback_tasks', function ($join) {
                    //$join->whereRaw("FIND_IN_SET (trade_program_subchain.id, photo_feedback_tasks.subchain_id)");
                    $join->whereRaw("photo_feedback_tasks.id = photo_feedback_submissions.task_id");
                })
                ->whereNull('photo_feedback_submissions.deleted_at')
                ->orderBy('photo_feedback_submissions.created_at', 'desc');

            return datatables()->of($dispenser)
                ->addColumn('chk_id', function ($row) {
                    return "<input type='checkbox' name='rc-chk-" . $row->id . "' id='pf-chk-" . $row->id . "' value='" . $row->id . "' class='dt-check'>
                            <label for='pf-chk-" . $row->id . "'>
                                <span></span>
                            </label>";
                })
                ->addColumn('action', function ($row) {
                    if (auth()->user()->can('view photo-feedback')) {
                        return "<a href='" . URL::to("photo-feedback/submissions/" . $row->id . "/edit") . "' class='btn btn-default'>Edit</a>";
                    }
                })

                ->rawColumns(['chk_id', 'action'])
                ->make();
        }
        return view('photo-feedback-submissions.list');
    }

    public function edit($id)
    {
        $todayDate = Carbon::now()->format('Y-m-d');

        $pf_sub = PhotoFeedbackSubmissionsModel::find($id);

        $custId = $pf_sub->cust_id;
        //$subchain = PhotoFeedbackSubmissionsModel::chkPfSubchain($custId);
        //$subchain = $subchain[0]['SubChain'];
        $taskData = PhotoFeedbackTasksModel::getTaskDataById($pf_sub->task_id);

        if (empty($taskData)) {
            // return response()->json(array(
            //     'success' => false,
            //     'message' => "Couldn't find the Task data of subchain - " . $subchain . ". Please check the Task module. "
            // ), 400);
            // exit();

            $taskId = "";
            $taskName = "";
            $start_datetime = "";
            $eventEndDatetime = "";
            $reminderDatetime = "";
        } else {
            $taskData = $taskData[0];

            $taskName = $taskData['title'];
            $start_datetime = $taskData['start_datetime'];
            $eventEndDatetime = $taskData['end_datetime'];
            $reminderDatetime = $taskData['reminder_datetime'];
        }

        if (!empty($pf_sub)) {
            $userData = User::find($pf_sub->checked_by);
            $userId = Auth::user()->id;
            $status = $pf_sub->status;
            $disableApproveBtn = ($todayDate >= $eventEndDatetime) ? true : false;

            $approvedBy = '';
            if (!empty($userData)) {
                $approvedBy = $userData->name;
            }
            $pf_sub->checked_by = $approvedBy;

            $errorMsgOpt = PhotoFeedbackErrorMsg::orderBy('id', 'asc')->pluck('descr', 'id');

            // show the edit form and pass the doc
            return View::make('photo-feedback-submissions.edit')
                ->with('data', $pf_sub)
                ->with('userId', $userId)
                ->with('status', $status)
                ->with('disableApproveBtn', $disableApproveBtn)
                ->with('task_name', $taskName)
                ->with('error_msg_opt', $errorMsgOpt);
        } else {
            return Redirect::to('photo-feedback/submissions');
        }
    }

    public function approved($id, Request $request)
    {
        try {

            if (!empty($id)) {

                $pf_sub = PhotoFeedbackSubmissionsModel::find($id);

                if (!empty($pf_sub)) {

                    $custId = $pf_sub->cust_id;
                    $submittedDate = PhotoFeedbackSubmissionsModel::find($id)->created_at;

                    if ($request->has("user_id") and $request->has("status")) {
                        $pf_sub->checked_by = $request->input('user_id');
                        $pf_sub->status = $request->input('status');

                        // error message
                        if (!empty($request->input('error_msg'))) {
                            $pf_sub->error_msg = $request->input('error_msg');
                        }
                    } else {
                        return response()->json(array(
                            'success' => false,
                            'message' => 'Missing property (user_id or status).',
                            'id' => $id,
                            'checked_datetime' => ''
                        ), 500);
                    }

                    $pf_sub->checked_datetime = Carbon::now('Asia/Singapore')->format('Y-m-d H:i:s');

                    $logPath = "";
                    $host = request()->getHost();
                    if (strstr($host, 'localhost') || strstr($host, '192.168')) {
                        $logPath = 'C:\wamp64\www\pmi-backoffice/storage/photofeedback/sms/';
                    } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
                        $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/photofeedback/sms-status/';
                    } else if (strstr($host, 'games.pmisg.cloud.sg')) {
                        $logPath = '/home/game/public_html/pmi-backoffice/storage/photofeedback/sms-status/';
                    }

                    $log_date = Carbon::now()->format('Y-m-d');
                    $log_name = 'Photofeedback-Status-SMS-' . $log_date;
                    $log = new Logger('Photofeedback-Status-SMS-log');
                    $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

                    $message = "";
                    $responseMsg = "";

                    //$todayDate = Carbon::now()->format('Y-m-d');

                    //retrieve Subchain 
                    $subchain = PhotoFeedbackSubmissionsModel::chkPfSubchain($custId);

                    if (!empty($subchain)) {
                        $subchain = $subchain[0]['SubChain'];
                    } else {
                        $log->warning($custId . ' not found on Payout table.');
                        return response()->json(array(
                            'success' => false,
                            'message' => $custId . ' not found on Payout table.'
                        ), 400);
                        exit();
                    }

                    $taskData = PhotoFeedbackTasksModel::getTaskDataById($pf_sub->task_id);
                    if (empty($taskData)) {
                        $log->warning("Couldn't find the Task data of subchain - " . $subchain . ". Please check the Task module. ");
                        return response()->json(array(
                            'success' => false,
                            'message' => "Couldn't find the Task data of subchain - " . $subchain . ". Please check the Task module. "
                        ), 400);
                        exit();
                    } else {
                        $taskData = $taskData[0];

                        $start_datetime = $taskData['start_datetime'];
                        $eventEndDatetime = $taskData['end_datetime'];
                        $reminderDatetime = $taskData['reminder_datetime'];

                        $approval_sms_en = $taskData['approval_sms_en'];
                        $approval_sms_ch = $taskData['approval_sms_ch'];
                        $rejection_sms_en = $taskData['rejection_sms_en'];
                        $rejection_sms_ch = $taskData['rejection_sms_ch'];
                        $task_expired_sms_en = $taskData['task_expired_sms_en'];
                        $task_expired_sms_ch = $taskData['task_expired_sms_ch'];
                    }

                    // $endDateArr = explode("-", $start_datetime);
                    // $endDate_year = $endDateArr[0];
                    // $endDate_mth = $endDateArr[1];
                    // $endDate_date = $endDateArr[2];

                    // $endTime = substr($start_datetime, -5);
                    // $endTimeArr = explode(":", $endTime);
                    // $invoiceHour = $endTimeArr[0];
                    // $invoiceMin = $endTimeArr[2];

                    // $eventEndDate = Carbon::create($endDate_year, $endDate_mth, $endDate_date, $invoiceHour, $invoiceMin)->setTimezone('Asia/Singapore')->addHours($duration)->format('Y-m-d H:i');
                    //end retrieve duration

                    $successSave = true;

                    switch ($pf_sub->status) {
                        case 0: //DISSAPPROVED
                            if ($pf_sub->save()) {

                                //if submission is rejected after task expires on 9 Aug
                                // if ($submittedDate >= $eventEndDatetime) {
                                //     $message = $task_expired_sms_en . "\n\n" . $task_expired_sms_ch;
                                // } else {
                                //     $message = $rejection_sms_en . "\n\n" . $rejection_sms_ch;
                                // }
                                $message = $rejection_sms_en . "\n\n" . $rejection_sms_ch;

                                $responseMsg = "Rejected status updated";
                            } else {
                                return response()->json(array(
                                    'success' => false,
                                    'message' => 'Failed approved',
                                    'id' => $id,
                                    'checked_datetime' => ''
                                ), 500);
                            }
                            break;

                        case 1: //APPROVED

                            $pf_sub->send_to_dte = Carbon::now()->format('Y-m-d H:i:s');
                            if ($pf_sub->save()) {

                                $message = $approval_sms_en . "\n\n" . $approval_sms_ch;
                                $responseMsg = "Approved status updated";

                                $data = [];
                                $data['transactionDescr'] = $taskData['transaction_descr'];
                                $data['points'] = $taskData['points'];
                                $data['custId'] = $pf_sub->cust_id;
                                $data['contactId'] = $pf_sub->contact_id;
                                $data['dateOfTransaction'] = Carbon::now('Asia/Singapore')->format('Y-m-d');

                                $awardResponse = $this->awardPoints($data);

                                if ($awardResponse['status'] != true) {
                                    $successSave = false;
                                } else {
                                    $submissionData = PhotoFeedbackSubmissionsModel::find($id);
                                    $submissionData->points_submitted = Carbon::now('Asia/Singapore')->format('Y-m-d H:i:s');
                                    $submissionData->points = $taskData['points'];
                                    $submissionData->add_to_dte = Carbon::now()->format('Y-m-d H:i:s');

                                    $awardResponse = json_encode($awardResponse['response']);
                                    $submissionData->dte_message = strval($awardResponse);
                                    $submissionData->save();
                                }
                            } else {
                                return response()->json(array(
                                    'success' => false,
                                    'message' => 'Failed approved',
                                    'id' => $id,
                                    'checked_datetime' => ''
                                ), 400);
                            }

                            break;
                    }

                    if ($successSave ==  true) {

                        $sms = new SmsDome();
                        $contactNo = str_replace("+", "", $pf_sub->contact_no);

                        if ($sms->send_sms($contactNo, $message)) {

                            $log->info($pf_sub->cust_id . ' (' . $pf_sub->contact_no . ') SMS send successfully. [' . $message . '] ');

                            return response()->json(array(
                                'success' => TRUE,
                                'message' => $responseMsg,
                                'id' => $id,
                                'checked_datetime' => $pf_sub->checked_datetime,
                                'submitted_datetime' => $submittedDate,
                                'event_end_datetime' => $eventEndDatetime
                            ), 200);
                        } else {
                            $log->error($pf_sub->cust_id . ' (' . $pf_sub->contact_no . ') SMS send failed.');
                            return response()->json(array(
                                'success' => FALSE,
                                'message' => $responseMsg,
                                'id' => $id,
                                'checked_datetime' => $pf_sub->checked_datetime
                            ), 200);
                        }
                    }
                } else {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Data not found.',
                        'checked_datetime' => ''
                    ), 400);
                }
            } else {
                return response()->json(array(
                    'success' => false,
                    'message' => 'Id not found.',
                    'checked_datetime' => ''
                ), 400);
            }
        } catch (NotFoundHttpException $e) {

            return response()->json(array(
                'success' => false,
                'message' => 'Id not found.',
                'checked_datetime' => ''
            ), 400);
        }
    }

    public function submission(Request $request)
    {

        $logPath = "";
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/photofeedback/awards/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/photofeedback/awards/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $logPath = '/home/game/public_html/pmi-backoffice/storage/photofeedback/awards/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'Photofeedback-awards-' . $log_date;
        $log = new Logger('Photofeedback-awards-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        if ($request->all()) {

            if (
                $request->has("cust_id") and
                $request->has("contact_no") and
                $request->has("contact_id") and
                $request->has("locale") and
                $request->has("imgs") and
                $request->has("task_id")
            ) {

                $taskId = Input::get('task_id');
                $custId = Input::get('cust_id');
                $custId = substr($custId, 2);

                //retrieve points 
                $subchain = Payout::chkSubchain($custId);

                //$currentDate = Carbon::now()->format('Y-m-d');
                $currentDatetime = Carbon::now()->format('Y-m-d H:i');

                if (!empty($subchain)) {
                    $subchain = $subchain[0]['SubChain'];
                } else {
                    $log->warning($custId . ' not found on Payout table.');
                    return response()->json(array(
                        'success' => false,
                        'message' => $custId . ' not found on Payout table.'
                    ), 400);
                    exit();
                }

                //$subchain = "7-11"; /////hardcode
                //$currentDatetime = "2021-07-26 09:00"; //hardcode
                //$currentDate = "2021-07-26"; //hardcode  

                //if subchain found on Tasks module    
                $taskData = PhotoFeedbackTasksModel::getTaskDataById($taskId);
                if (empty($taskData)) {
                    $log->warning("Couldn't find the Task data of subchain - " . $subchain . ". Please check the Task module. ");
                    return response()->json(array(
                        'success' => false,
                        'message' => "Couldn't find the Task data of subchain - " . $subchain . ". Please check the Task module. ",
                    ), 500);
                    exit();
                } else {
                    $taskData = $taskData[0];

                    $taskId = $taskData['id'];
                    $points = $taskData['points'];
                    $transactionDescr = $taskData['transaction_descr'];
                    $options = $taskData['options'];

                    $startDatetime = substr($taskData['start_datetime'], 0, -3);
                    $endDatetime = substr($taskData['end_datetime'], 0, -3);
                    $reminderDatetime = substr($taskData['reminder_datetime'], 0, -3);

                    $taskDuration = $taskData['task_duration'];
                    $reminderSmsDay = $taskData['reminder_sms_day'];
                    $dynamicEndDatetime = $taskData['dynamic_end_datetime'];
                }


                // If Static Option
                if ($options == $this->staticOption) {
                    if ($currentDatetime >= $startDatetime) {

                        //if over end date then cannot submit 
                        if ($currentDatetime > $endDatetime) {
                            $log->warning($custId . ' - (' . $endDatetime . ') date passed.');
                            return response()->json(array(
                                'success' => false,
                                'message' => $custId . ' - (' . $endDatetime . ') date passed.'
                            ), 500);
                            exit();
                        }
                    } else {
                        return response()->json([
                            'status' => false,
                            'message' => "OOShelf program haven't started yet. Please submit at " . $startDatetime . " or after. ",
                            'start_date' => $startDatetime,
                            'end_date' => $endDatetime,
                            'current_datetime' => $currentDatetime,
                            'response' => []
                        ]);
                    }
                } else { // If Dynamic Option

                    $data = PhotoFeedbackInvoicesPublish::where('cust_id', $custId)
                        ->first();

                    if (!empty($data->published_date)) {

                        $releaseDatetime = $data->published_date;
                        $taskEnd = Carbon::parse($releaseDatetime)->addDays($taskDuration);

                        // after start datetime
                        if (Carbon::now() >= $releaseDatetime) {
                            if (Carbon::now() > $taskEnd) {
                                $taskOver = true;
                            }
                        } else if (Carbon::now() < $releaseDatetime) { // haven't start yet (coming soon)
                            $comingSoon = true;
                        }
                    } else {
                        return response()->json([
                            'status' => false,
                            'message' => $custId . " Invoice Date not found. ",
                        ]);
                    }
                }

                //if submission completed (Not Rejected or approved)
                $submittedData = PhotoFeedbackSubmissionsModel::chkSubmissionData($custId, $taskId);

                if (!empty($submittedData)) {
                    $log->warning($custId . ' data have submitted and pending approval.');
                    return response()->json(array(
                        'success' => false,
                        'message' => $custId . ' data have submitted and pending approval.'
                    ), 200);
                    exit();
                }

                //if submission approved
                $approvedData = PhotoFeedbackSubmissionsModel::getApproved($custId, $taskId);

                if (!empty($approvedData)) {
                    $log->warning($custId . ' data have approved.');
                    return response()->json(array(
                        'success' => false,
                        'message' => $custId . ' data have approved.'
                    ), 200);
                    exit();
                }

                //if points credited
                // $pfSubmission = PhotoFeedbackSubmissionsModel::checkPointsSubmitted($custId);

                // if (!empty($pfSubmission)) {
                //     $log->warning($custId . ' data points awarded.');
                //     return response()->json(array(
                //         'success' => false,
                //         'message' => $custId . ' data points awarded.'
                //     ), 200);
                //     exit();
                // }

                $pfSub = new PhotoFeedbackSubmissionsModel;
                $pfSub->cust_id = $custId;
                $pfSub->task_id = $taskId;
                $pfSub->contact_no = Input::get('contact_no');
                $pfSub->contact_id = Input::get('contact_id');
                $pfSub->locale = Input::get('locale');
                $pfSub->updated_at = null;

                if (!empty(Input::file('imgs'))) {
                    $imgsArr = Input::file('imgs');

                    $pfImgsPath = $this->chkdomain();

                    $imgContentArr = [];
                    foreach ($imgsArr as $img) {

                        if ($img) {

                            $fileSize = $img->getClientSize();
                            $file_extension =  $img->getClientOriginalExtension();

                            if (!in_array($file_extension, $this->allowed_image_extension)) {
                                DB::rollBack();
                                return response()->json(['status' => false, 'message' => "Upload valid images. Only PNG, JPG, JPEG and GIF are allowed."]);
                            } else if (($fileSize > 2000000)) { //Image size exceeds 2MB
                                DB::rollBack();
                                return response()->json(['status' => false, 'message' => "Image size exceeds 2MB."]);
                            } else {
                                // Define upload path
                                $path = $pfImgsPath . $custId;
                                $absoPath = $custId . $img->getClientOriginalName();
                                File::makeDirectory($path, $mode = 0777, true, true);
                                $destinationPath = $path;
                                //$destinationPath = public_path('/imgs/trade-program/' . $nextIncrementId . '/banner-path/' . $rcStageName . "-" . $rcBanner->retailer_cluster_id); // upload path

                                // Upload Orginal Image     
                                $fileInfo = $img->getClientOriginalName();
                                $filename = pathinfo($fileInfo, PATHINFO_FILENAME);
                                $profileImage = date('YmdHis') . "-" . uniqid() . "-" . $filename . "." . $img->getClientOriginalExtension();
                                $img->move($destinationPath, $profileImage);

                                //$profileImagePath = $caseId . "/" . $profileImage;
                                //$rcBanner->banner_path = "$profileImagePath";
                                $profileImagePath = "imgs/photo-feedback/" . $custId . "/" . $profileImage;

                                array_push($imgContentArr, $profileImagePath);
                            }
                        }
                    }

                    $imgJSON = json_encode($imgContentArr);
                    $pfSub->imgs = $imgJSON;
                }

                if ($pfSub->save()) {
                    $pfSub->refresh();
                    $saveId = $pfSub->id;

                    if (!is_null($pfSub->imgs)) {

                        $imgResponseArr = [];
                        if (!empty($imgContentArr)) {
                            foreach ($imgContentArr as $imgPath) {
                                array_push($imgResponseArr, url($imgPath));
                            }

                            $pfSub->imgs = $imgResponseArr;
                        } else {
                            $pfSub->imgs = [];
                        }
                        //$pfSub->imgs =  json_decode($pfSub->imgs);
                    } else {
                        $pfSub->imgs = [];
                    }

                    //Award points
                    $data = [];
                    $data['transactionDescr'] = $transactionDescr;
                    $data['points'] = $points;
                    $data['custId'] = $pfSub->cust_id;
                    $data['contactId'] = $pfSub->contact_id;
                    $data['dateOfTransaction'] = Carbon::now('Asia/Singapore')->format('Y-m-d');
                    //$data['dateOfTransaction'] = '2021-06-19';

                    $pointsSubmitted = PhotoFeedbackSubmissionsModel::checkPointsSubmitted($custId, $taskId);

                    //if point credited than skip Mulesoft endpoint
                    if (!empty($pointsSubmitted)) {
                        $log->info($custId . " Successfully created. (Without credited points due to points submitted. )");
                        $pfSub->refresh();
                        return response()->json([
                            'status' => true,
                            'message' => "Successfully created. (Without credited points due to points submitted. )",
                            'start_date' => $startDatetime,
                            'end_date' => $endDatetime,
                            'response' => $pfSub,
                            'points' => 0
                        ]);
                        exit();
                    } else {

                        //Start trigger Mulesoft endpoint
                        $submissionData = PhotoFeedbackSubmissionsModel::find($saveId);
                        $submissionData->send_to_dte = Carbon::now()->format('Y-m-d H:i:s');

                        if ($submissionData->save()) {

                            return response()->json([
                                'status' => true,
                                'message' => "Successfully created. ",
                                //'message' => "Successfully created and " . $points . " points credited. ",
                                'start_date' => $startDatetime,
                                'end_date' => $endDatetime,
                                'points' => $points
                            ]);

                            // $awardResponse = $this->awardPoints($data);

                            // if ($awardResponse['status'] === true) { // if SUCCESS

                            //     $pfSubStatus = PhotoFeedbackSubmissionsModel::find($saveId);
                            //     if (!empty($awardResponse['response'])) {
                            //         $muleResponse = $awardResponse['response'];
                            //         $responseId = $muleResponse->id;
                            //     }
                            //     $pfSubStatus->points_submitted = (!empty($responseId)) ? Carbon::now('Asia/Singapore')->format('Y-m-d H:i:s') : null;
                            //     $pfSubStatus->points = $points;

                            //     $pfSubStatus->add_to_dte = Carbon::now()->format('Y-m-d H:i:s');
                            //     $awardResponse = json_encode($awardResponse['response']);
                            //     $pfSubStatus->dte_message = strval($awardResponse);

                            //     if ($pfSubStatus->save()) {

                            //         //$pfSub->points_submitted = Carbon::now('Asia/Singapore')->format('Y-m-d H:i:s');
                            //         $log->info($custId . " Successfully created and " . $points . " points credited. ");
                            //         $pfSubStatus->refresh();

                            //         return response()->json([
                            //             'status' => true,
                            //             'message' => "Successfully created and " . $points . " points credited. ",
                            //             'start_date' => $startDatetime,
                            //             'end_date' => $endDatetime,
                            //             'response' => $pfSubStatus,
                            //             'points' => $points
                            //         ]);
                            //     } else {
                            //         $log->warning($custId . "Data updated and Points credited but update status failed in the database.");
                            //         return response()->json([
                            //             'status' => true,
                            //             'message' => "Data updated and Points credited but update status failed in the database.",
                            //             'start_date' => $startDatetime,
                            //             'end_date' => $endDatetime,
                            //             'response' => $pfSubStatus,
                            //             'points' => $points
                            //         ]);
                            //     }
                            // } else { // if Mulesoft failed

                            //     $pfSubStatus = PhotoFeedbackSubmissionsModel::find($saveId);
                            //     $pfSubStatus->points_submitted =  null;
                            //     $pfSubStatus->points = $points;

                            //     $pfSubStatus->add_to_dte = Carbon::now()->format('Y-m-d H:i:s');
                            //     $awardResponse = json_encode($awardResponse['response']);
                            //     $pfSubStatus->dte_message = strval($awardResponse);

                            //     if ($pfSubStatus->save()) {
                            //         $log->warning($custId . " Failed approved. Error occured in the Mulesoft endpoint.");

                            //         $pfSubStatus->refresh();
                            //         return response()->json(array(
                            //             'success' => false,
                            //             'message' => 'Failed approved. Error occured in the Mulesoft endpoint',
                            //             'start_date' => $startDatetime,
                            //             'end_date' => $endDatetime,
                            //             'response' => $pfSubStatus,
                            //             'points' => ''
                            //         ), 500);
                            //     }
                            // }
                        }
                    }
                } else {
                    return response()->json([
                        'status' => false,
                        'message' => "Failed.",
                        'start_date' => $startDatetime,
                        'end_date' => $endDatetime,
                        'response' => []
                    ]);
                }
            } else {
                return response()->json(['status' => false, 'message' => "Missing property or value."]);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Failed."]);
        }
    }

    //API
    public function init(Request $request)
    {
        if (
            $request->has('query')
        ) {

            //Check if parameter slug is empty
            if (Cache::has('task_id')) {
                $taskId = Cache::get('task_id');
                Cache::forget('task_id');
            } else if (!empty($request->input('task_id'))) {
                $taskId = $request->input('task_id');
            } else if (!empty($_COOKIE['task_id'])) {

                $taskId = $_COOKIE['task_id'];
                unset($_COOKIE['task_id']);
                setcookie("task_id", "", time() - 3600, "/; SameSite=None; Secure");
            } else {
                return response()->json(array(
                    'success' => false,
                    'message' => 'Task Id not found. ',
                ), 200);
            }

            $query = $request->input('query');
            //$taskId = $request->input('task_id');

            $dte = new DTEdecode();
            $decryptedData = $dte->decode_id($query, FALSE);
            if ($decryptedData == false) {

                return response()->json(array(
                    'success' => false,
                    'message' => 'Invalid query string. ',
                ), 200);
            } else {
                //$custId = $decryptedData->User->Contact->Account->DTE_Account_Id__c;
                $subchain = $decryptedData->User->Contact->Account->DTE_Sub_Chain__c;
                $custId = $decryptedData->User->Contact->Account->DTE_AccountNumber__c;
                $custId = substr($custId, 2);

                //if FlexParameter2 not found or is not COMMERCIAL (First Photo feedback)
                //All (Second Photo feedback)
                // if (empty($decryptedData->User->Contact->DTE_FlexParameter2__c)) {
                //     return response()->json(array(
                //         'success' => false,
                //         'message' => "You are not eligible to perform this task. Thank you.",
                //     ), 500);
                //     exit();
                // } else if ($decryptedData->User->Contact->DTE_FlexParameter2__c != "COMMERCIAL") {
                //     return response()->json(array(
                //         'success' => false,
                //         'message' => "You are not eligible to perform this task. Thank you. (" . $decryptedData->User->Contact->DTE_FlexParameter2__c . ") ",
                //     ), 500);
                //     exit();
                // }

                $currentDateTime = Carbon::now()->setTimezone('Asia/Singapore')->format('Y-m-d H:i');

                //$currentDateTime = "2021-07-26 09:00"; //hardcode
                //$subchain = "7-11"; //hardcode for testing

                $taskData = PhotoFeedbackTasksModel::getTaskDataById($taskId);
                if (empty($taskData)) {
                    return response()->json(array(
                        'success' => false,
                        'message' => "Couldn't find the Task data of subchain - " . $subchain . ". Please check the Task module. ",
                    ), 500);
                    exit();
                } else {
                    $taskData = $taskData[0];

                    $taskId = $taskData['id'];
                    $title = $taskData['title'];
                    $descr = $taskData['descr'];
                    $campaignUrl = $taskData['campaign_url'];
                    $points = $taskData['points'];
                    $options = $taskData['options'];

                    $startDatetime = substr($taskData['start_datetime'], 0, -3);
                    $endDatetime = substr($taskData['end_datetime'], 0, -3);
                    $reminderDatetime = substr($taskData['reminder_datetime'], 0, -3);

                    $taskDuration = $taskData['task_duration'];
                    $reminderSmsDay = $taskData['reminder_sms_day'];
                    $dynamicEndDatetime = $taskData['dynamic_end_datetime'];
                }

                // If Static Option
                if ($options == $this->staticOption) {
                    if ($currentDateTime >= $startDatetime) {

                        //$closeDatetime = Carbon::create($invoiceDate_year, $invoiceDate_mth, $invoiceDate_date, $invoiceHour, $invoiceMin)->setTimezone('Asia/Singapore')->addHours($duration)->format('Y-m-d H:i');
                        $close_time_remaining_arr = [];
                        if ($currentDateTime >= $endDatetime) {
                            $close_time_remaining = 0;

                            $close_time_remaining_arr['day'] = (int)0;
                            $close_time_remaining_arr['hours'] = (int)0;
                            $close_time_remaining_arr['mins'] = (int)0;
                        } else {
                            $endDate = Carbon::parse($endDatetime);
                            $now = Carbon::now("Asia/Singapore");

                            $diff = $now->diff($endDate, false)->format('%I');
                            //$close_time_remaining = $now->diffInHours($endDate) . ' hours ' . $diff . ' minutes';

                            $hours = $now->diffInHours($endDate);
                            $dayHours = 24; //one day 24 hours

                            $close_time_remaining = "";
                            $close_time_remaining_arr = [];
                            $remainDays = 0;
                            $remainHours = 0;
                            $remainMins = $diff;

                            if ($hours > $dayHours) {
                                $days = (int)($hours / $dayHours);
                                $totalHours = $hours % $dayHours;

                                $remainDays = $days;
                                $remainHours = $totalHours;

                                //$dayWord = ($days > 1) ? "Days" : "Day";
                                //$hourWord = ($remainHours > 1) ? "Hours" : "Hour";
                                //$close_time_remaining =  "$days $dayWord / $remainHours $hourWord / $diff Minutes";
                            } else {
                                //$hourWord = ($hours > 1) ? "Hours" : "Hour";
                                //$close_time_remaining =  "$hours $hourWord / $diff Minutes";
                                $remainDays = 0;
                                $remainHours = $hours;
                            }

                            $close_time_remaining_arr['day'] = (int)$remainDays;
                            $close_time_remaining_arr['hours'] = (int)$remainHours;
                            $close_time_remaining_arr['mins'] = (int)$remainMins;
                            //$close_time_remaining = $now->diffInDays($endDate) . ':' . $diff;

                            // $diff = $now->diffInSeconds($endDate);
                            // echo $diff;
                            // $diff = gmdate('d H:i:s', $diff);

                            // $diff = $endDate->diffInHours($now, false);
                            // $result = $endDate->gt($now);

                            //print_r($result);
                        }
                    } else {

                        return response()->json([
                            'status' => false,
                            'message' => "OOShelf program haven't started yet. Release date is " . $startDatetime . ". ",
                            'display' => false,
                            'start_date' => $startDatetime,
                            'current_datetime' => $currentDateTime
                        ]);
                    }
                } else { // if dynamic option

                    $now = Carbon::now("Asia/Singapore");
                    $taskEnd = Carbon::now()->addDays($taskDuration);
                    $smsFireDay = Carbon::now()->addDays($reminderSmsDay);

                    $data = PhotoFeedbackInvoicesPublish::where('cust_id', $custId)
                        ->first();

                    if (!empty($data->published_date)) {

                        $releaseDatetime = $data->published_date;
                        $taskEnd = Carbon::parse($releaseDatetime)->addDays($taskDuration);
                        $smsFireDay = Carbon::parse($releaseDatetime)->addDays($reminderSmsDay);

                        $hours = $now->diffInHours($taskEnd);
                        $dayHours = 24; //one day 24 hours

                        $remainDays = 0;
                        $remainHours = 0;
                        $remainMins = $now->diff($taskEnd, false)->format('%I');

                        if ($hours > $dayHours) {
                            $days = (int)($hours / $dayHours);
                            $totalHours = $hours % $dayHours;

                            $remainDays = $days;
                            $remainHours = $totalHours;
                        } else {
                            $remainDays = 0;
                            $remainHours = $hours;
                        }

                        $remainDays = (int)$remainDays;
                        $remainHours = (int)$remainHours;
                        $remainMins = (int)$remainMins;


                        $startDatetime = $releaseDatetime;
                        $endDatetime = $taskEnd;

                        $close_time_remaining_arr['day'] = (int)$remainDays;
                        $close_time_remaining_arr['hours'] = (int)$remainHours;
                        $close_time_remaining_arr['mins'] = (int)$remainMins;
                    }
                }

                $submission_data = PhotoFeedbackSubmissionsModel::getSubmission($custId, $taskId);

                //end check left time
                if (!empty($submission_data)) {

                    $statusId = $submission_data[0]['status'];

                    $approved =  PhotoFeedbackSubmissionsModel::$approved;
                    $disapproved = PhotoFeedbackSubmissionsModel::$disapproved;

                    $status = "";
                    if (is_null($statusId)) {
                        $status = "Pending Approval";
                    } else {
                        switch ($statusId) {
                            case $disapproved:
                                $status = "Rejected";
                                break;
                            case $approved:
                                $status = "Approved";
                                break;
                        }
                    }

                    $submission_data[0]['imgs'] = json_decode($submission_data[0]['imgs']);
                    $imgResponseArr = [];
                    $countImgResponseArr = 0;
                    if (!empty($submission_data[0]['imgs'])) {
                        foreach ($submission_data[0]['imgs'] as $imgPath) {

                            $size = filesize($imgPath);
                            $imgSize = $this->formatSizeUnits($size);
                            $imgResponseArr[$countImgResponseArr]["path"] = url($imgPath);
                            $imgResponseArr[$countImgResponseArr]["size"] = $imgSize;
                            $countImgResponseArr++;
                        }

                        $submission_data[0]['imgs'] = $imgResponseArr;
                    } else {
                        $submission_data[0]['imgs'] = [];
                    }

                    return response()->json(array(
                        'success' => true,
                        'message' => 'Data found.',
                        'display' => true,
                        'task_id' => $taskId,
                        'start_datetime' => $startDatetime,
                        'close_datetime' => $endDatetime,
                        'current_datetime' => $currentDateTime,
                        'title' => $title,
                        'descr' => $descr,
                        'campaign_url' => $campaignUrl,
                        'close_time_remaining' => $close_time_remaining_arr,
                        'status' => $status,
                        'submission_data' => $submission_data[0],
                        'dte_data' => $decryptedData
                    ), 200);
                } else {
                    return response()->json(array(
                        'success' => true,
                        'message' => 'Submission data (Cust Id: ' . $custId . ') not found.',
                        'display' => false,
                        'task_id' => $taskId,
                        'start_datetime' => $startDatetime,
                        'close_datetime' => $endDatetime,
                        'current_datetime' => $currentDateTime,
                        'title' => $title,
                        'descr' => $descr,
                        'campaign_url' => $campaignUrl,
                        'close_time_remaining' => $close_time_remaining_arr,
                        'status' => "",
                        'submission_data' => [],
                        'dte_data' => $decryptedData
                    ), 200);
                }

                // } else {

                //     return response()->json([
                //         'status' => false,
                //         'message' => "Cust Id (" . $custId . ") not found in the invoice data.",
                //         'display' => false,
                //         'start_date' => ""
                //     ]);
                // }
            }
        } else {
            return response()->json([
                'status' => false,
                'message' => "Query not found."
            ]);
        }
    }


    public function destroy($id)
    {
        // delete
        $pfSub = PhotoFeedbackSubmissionsModel::find($id);
        $pfSub->softDeletes();
        //$doc->delete();

        // redirect
        Session::flash('message', 'Successfully deleted the Submission!');
        return Redirect::to('photo-feedback/submissions');
    }

    public function deleteMultiple(Request $request)
    {

        $ids = $request->id;

        PhotoFeedbackSubmissionsModel::whereIn('id', $ids)->delete();
        return response()->json(['status' => true, 'message' => "Submission deleted successfully."]);
    }


    public function truncateSubmission()
    {
        try {
            if (PhotoFeedbackSubmissionsModel::query()->truncate()) {
                return response()->json(array(
                    'success' => true,
                    'message' => 'Truncate Submission data succssfully.'
                ), 200);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => "Truncate Submission data failed.",
                ]);
            }
        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {

            return response()->json([
                'status' => false,
                'message' => $e
            ]);
        }
    }

    //Testing only 
    public function deleteSubmission(Request $request)
    {
        $idArr = [""];
        try {
            $ids = $request->cust_id;
            array_push($idArr, $ids);

            PhotoFeedbackSubmissionsModel::whereIn('cust_id', $idArr)->forceDelete();

            return response()->json(['status' => true, 'message' => "Submission deleted successfully."]);
        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {

            return response()->json([
                'status' => false,
                'message' => $e
            ]);
        }
    }

    public function awardPoints($data)
    {
        //Log
        $logPath = "";
        $curlEndpoint = "";
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $curlEndpoint = "https://service.qa-pmidce2.com/dte/v1/api/v1/dte/ingestion";
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/photofeedback/awards/';

            $transactionReasonType = 'a0F25000008HJWlEAO';
            $tradeProgram = 'a0N25000006LfhNEAS';

            $cliendId = $this->QACliendId;
            $clientSecret = $this->QAClientSecret;

            $curlEndpoint = "https://api.iqos.com/dte/v1/api/v1/dte/ingestion";
            $logPath = '/home/game/public_html/pmi-backoffice/storage/photofeedback/awards/';

            //$transactionReasonType = 'a0F4H00000cOyMyUAK';
            $transactionReasonType = "a0F4H00000cOyMy";
            $tradeProgram = 'a0N4H00000lDZ5N';

            $cliendId = $this->ProCliendId;
            $clientSecret = $this->ProCliendSecret;
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $curlEndpoint = "https://service.qa-pmidce2.com/dte/v1/api/v1/dte/ingestion";
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/photofeedback/awards/';

            $transactionReasonType = 'a0F25000008HJWlEAO';
            $tradeProgram = 'a0N25000006LfhNEAS';

            $cliendId = $this->QACliendId;
            $clientSecret = $this->QAClientSecret;
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $curlEndpoint = "https://api.iqos.com/dte/v1/api/v1/dte/ingestion";
            $logPath = '/home/game/public_html/pmi-backoffice/storage/photofeedback/awards/';

            //$transactionReasonType = 'a0F4H00000cOyMyUAK';

            //Year 2021
            //$transactionReasonType = "a0F4H00000cOyMy";
            //$tradeProgram = 'a0N4H00000lDZ5N';

            //Year 2022
            $transactionReasonType = "a0F4H00000i3Mc9";
            $tradeProgram = 'a0N4H00000n5ItN';

            $cliendId = $this->ProCliendId;
            $clientSecret = $this->ProCliendSecret;
        }


        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'Photofeedback-awards-' . $log_date;
        $log = new Logger('Photofeedback-awards-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        $custId = $data['custId'];
        $contactId = $data['contactId'];
        //$awardPoints = 5;
        $transactionDescription = $data['transactionDescr'];
        $awardPoints = $data['points'];
        $statusPoints = 0;
        $transactionReasonType = $transactionReasonType;
        $tradeProgram = $tradeProgram;
        $dateOfTransaction = $data['dateOfTransaction'];
        //$transactionDescription = "MARLBORO's LATEST DISCOUNTS 26Jul-8Aug 5pts: Photofeedback MarlboroFreshIBBM";
        $activityType = "iFrameExternalStatusPoints";

        //$transactionReasonType = "a0F25000008HJWlEAO";
        //$tradeProgram = "a0N25000006LfhNEAS";

        $header = array("User-Agent: Mozilla/5.0");

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $curlEndpoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_POSTFIELDS => '{
              "contactId": "' . $contactId . '",
              "awardPoints": ' . $awardPoints . ',
              "statusPoints": ' . $statusPoints . ',
              "trasactionReasonType": "' . $transactionReasonType . '",
              "tradeProgram": "' . $tradeProgram . '",
              "dateOfTransaction": "' . $dateOfTransaction . '",
              "transactionDescription": "' . $transactionDescription . '",
              "activityType": "' . $activityType . '"
          }',
            CURLOPT_HTTPHEADER => array(
                'X-Channel: DTE',
                'client_id: ' . $cliendId,
                'client_secret: ' . $clientSecret,
                'Content-Type: application/json',
                'X-Correlation-Id: kntest3'
            ),
        ));

        $response = curl_exec($curl);
        $responseObjects = json_decode($response);

        $responseData = [];
        if ($responseObjects->code === 200) {

            $log->info('Points (' . $awardPoints . ') credited to ' . $custId . ' (ContactId: ' . $contactId . ')');

            $responseData['status'] = true;
            $responseData['response'] = $responseObjects->{'response-data'};
        } else {

            $responseObjectsContent = json_encode($response);
            $this->sendAlertEmail($custId, $responseObjectsContent);

            $errorContent = $responseObjects->errors;

            //$errorContent[0]->shortDescription
            if (!is_object($errorContent)) {
                $log->warning('Points  (' . $awardPoints . ') failed credit to ' . $custId . ' (ContactId: ' . $contactId . ') | Error: ' . $errorContent[0]->errorCode);
                $responseData['response'] = $responseObjects;
                //$responseData['response'] = $errorContent[0]->errorCode;
            } else {
                $log->warning('Points  (' . $awardPoints . ') failed credit to ' . $custId . ' (ContactId: ' . $contactId . ') | Error: ' . $errorContent->shortDescription);
                $responseData['response'] = $responseObjects;
                //$responseData['response'] = $errorContent->errorCode;
            }

            $responseData['status'] = false;
        }

        return $responseData;


        //echo stripslashes($response);
    }



    public function sendAlertEmail($custId, $errorInfo)
    {
        $emailMsg = 'Hi, this user encounter points awards issue - ' . $custId . ' <br><br>' . $errorInfo;
        // Mail::raw($emailMsg, function ($message) {
        //     $emailList = ['samrong.tee@onyxisland.com', 'samrong.tee@gmail.com'];
        //     $message->to($emailList)->subject('Photo Feedback Submission Issue');
        // });

        Mail::send([], [], function ($message) use ($emailMsg) {
            $message->to(['samrong.tee@onyxisland.com', 'danny.murong@onyxisland.com', 'serene.lai@onyxisland.com'])
                ->subject('Photo Feedback Submission Issue')

                ->setBody($emailMsg, 'text/html');
        });
    }

    //API
    public function iframe(Request $request)
    {
        if ($request->has('query')) {
            $query = $request->input('query');

            $dte = new DTEdecode();
            $decryptedData = $dte->decode_id($query, FALSE);
            if ($decryptedData == false) {

                return response()->json(array(
                    'success' => false,
                    'message' => 'Invalid query string. ',
                ), 200);
            } else {

                $locale = $decryptedData->User->LanguageLocaleKey;
                $subchain = $decryptedData->User->Contact->Account->DTE_Sub_Chain__c;
                $custId = $decryptedData->User->Contact->Account->DTE_AccountNumber__c;
                $custId = substr($custId, 2);

                //if FlexParameter2 not found or is not COMMERCIAL
                // if (empty($decryptedData->User->Contact->DTE_FlexParameter2__c)) {
                //     return response()->json(array(
                //         'success' => false,
                //         'message' => "Not eligible. ",
                //     ), 500);
                //     exit();
                // } else if ($decryptedData->User->Contact->DTE_FlexParameter2__c != "COMMERCIAL") {
                //     return response()->json(array(
                //         'success' => false,
                //         'message' => "Not eligible. (" . $decryptedData->User->Contact->DTE_FlexParameter2__c . ") ",
                //     ), 500);
                //     exit();
                // }

                $taskOver = false;

                //$subchain = "7-11"; //hardcode
                if (strtoupper(trim($subchain)) == "7-11") {

                    //$duration = 336; //after 2 weeks program end ((14*24)/2 )
                    $taskData = PhotoFeedbackTasksModel::getTaskData($subchain);  //for example duration is 336 hours;

                    $diff = "";

                    if (sizeof($taskData) <= 0) {
                        return response()->json([
                            'status' => false,
                            'message' => "Couldn't find the Task data of subchain - " . $subchain . ". Please check the Task module. ",
                        ]);
                    } else {
                        $taskData = $taskData[0];
                        $taskId = $taskData['id'];
                        $snapUrl = $taskData['snap_url'];
                        $startDatetime = substr($taskData['start_datetime'], 0, -3);
                        $endDatetime = substr($taskData["end_datetime"], 0, -3);
                    }

                    // $currentYear = Carbon::now()->year;
                    // $invoiceDate_year = $currentYear;
                    // $invoiceDate_mth = 7; //July
                    // $invoiceDate_date = 26;
                    // $invoiceHour = 9;
                    // $invoiceMin = 0;

                    //$closeDatetime = Carbon::create($invoiceDate_year, $invoiceDate_mth, $invoiceDate_date, $invoiceHour, $invoiceMin)->setTimezone('Asia/Singapore')->addHours($duration)->format('Y-m-d H:i');
                    $currentDateTime = Carbon::now()->setTimezone('Asia/Singapore')->format('Y-m-d H:i');

                    if ($currentDateTime >= $endDatetime) {
                        $close_time_remaining = 0;

                        $close_time_remaining_arr['day'] = (int)0;
                        $close_time_remaining_arr['hours'] = (int)0;
                        $close_time_remaining_arr['mins'] = (int)0;

                        $taskOver = true;
                    } else {
                        $endDate = Carbon::parse($endDatetime);
                        $now = Carbon::now("Asia/Singapore");

                        $diff = $now->diff($endDate, false)->format('%I');
                        //$close_time_remaining = $now->diffInHours($endDate) . ' hours ' . $diff . ' minutes';

                        $hours = $now->diffInHours($endDate);
                        $dayHours = 24; //one day 24 hours

                        $close_time_remaining = "";
                        $close_time_remaining_arr = [];
                        $remainDays = 0;
                        $remainHours = 0;
                        $remainMins = $diff;

                        if ($hours > $dayHours) {
                            $days = (int)($hours / $dayHours);
                            $totalHours = $hours % $dayHours;

                            $remainDays = $days;
                            $remainHours = $totalHours;
                        } else {
                            $remainDays = 0;
                            $remainHours = $hours;
                        }

                        $close_time_remaining_arr['day'] = (int)$remainDays;
                        $close_time_remaining_arr['hours'] = (int)$remainHours;
                        $close_time_remaining_arr['mins'] = (int)$remainMins;
                    }
                } else {

                    //update business logic only 7-11 user
                    return response()->json([
                        'status' => false,
                        'message' => "No eligible. (" . $subchain . ")",
                    ]);

                    ////////////////END
                    ////////////////

                    // $invoiceDate = PhotoFeedbackInvoicesSMS::getInvoiceDateByCustId($custId);

                    // $close_time_remaining_arr = [];
                    // if (count($invoiceDate) > 0) {
                    //     $invoiceData = $invoiceDate[0];
                    //     $invoiceDate = $invoiceData["invoice_date"];

                    //     $taskData = PhotoFeedbackTasksModel::chkDuration($subchain);
                    //     //$duration = 336; //after 2 weeks program end ((14*24)/2 )

                    //     $taskOver = false;
                    //     //if (!sizeof($taskData)) {
                    //     if (empty($taskData)) {
                    //         return response()->json([
                    //             'status' => false,
                    //             'message' => "No eligible.",
                    //         ]);
                    //     } else {

                    //         $taskData = $taskData[0];
                    //         $duration = $taskData["duration"];

                    //         $invoiceDateArr = explode("-", $invoiceData['invoice_date']);
                    //         $invoiceDate_year = $invoiceDateArr[0];
                    //         $invoiceDate_mth = $invoiceDateArr[1];
                    //         $invoiceDate_date = $invoiceDateArr[2];
                    //         $invoiceHour = 9;
                    //         $invoiceMin = 0;

                    //         $closeDatetime = Carbon::create($invoiceDate_year, $invoiceDate_mth, $invoiceDate_date, $invoiceHour, $invoiceMin)->setTimezone('Asia/Singapore')->addHours($duration)->format('Y-m-d H:i');
                    //         $currentDateTime = Carbon::now()->setTimezone('Asia/Singapore')->format('Y-m-d H:i');

                    //         if ($currentDateTime >= $closeDatetime) {
                    //             $close_time_remaining = 0;

                    //             $close_time_remaining_arr['day'] = (int)0;
                    //             $close_time_remaining_arr['hours'] = (int)0;
                    //             $close_time_remaining_arr['mins'] = (int)0;

                    //             $taskOver = true;
                    //         } else {
                    //             $endDate = Carbon::parse($closeDatetime);
                    //             $now = Carbon::now("Asia/Singapore");

                    //             $diff = $now->diff($endDate, false)->format('%I');
                    //             //$close_time_remaining = $now->diffInHours($endDate) . ' hours ' . $diff . ' minutes';

                    //             $hours = $now->diffInHours($endDate);
                    //             $dayHours = 24; //one day 24 hours

                    //             $close_time_remaining = "";
                    //             $close_time_remaining_arr = [];
                    //             $remainDays = 0;
                    //             $remainHours = 0;
                    //             $remainMins = $diff;

                    //             if ($hours > $dayHours) {
                    //                 $days = (int)($hours / $dayHours);
                    //                 $totalHours = $hours % $dayHours;

                    //                 $remainDays = $days;
                    //                 $remainHours = $totalHours;
                    //             } else {
                    //                 $remainDays = 0;
                    //                 $remainHours = $hours;
                    //             }

                    //             $close_time_remaining_arr['day'] = (int)$remainDays;
                    //             $close_time_remaining_arr['hours'] = (int)$remainHours;
                    //             $close_time_remaining_arr['mins'] = (int)$remainMins;
                    //         }
                    //     }
                    // } else {

                    //     return response()->json([
                    //         'status' => false,
                    //         'message' => "No eligible.",
                    //     ]);
                    // }
                }

                $pfStatus = PhotoFeedbackSubmissionsModel::getStatus($custId, $taskId);

                if (count($pfStatus)) {
                    $status = $pfStatus[0]['status'];
                    $approved =  PhotoFeedbackSubmissionsModel::$approved;
                    $disapproved =  PhotoFeedbackSubmissionsModel::$disapproved;

                    $buttonText = "";
                    $buttonColor = "";

                    switch ($locale) {
                        case "en_SG":
                            if (is_null($status)) {
                                $buttonText = "Pending <br> Approval";
                                $buttonColor = "#c60d14";
                                $statusName = "Pending";
                            } else {
                                switch ($status) {
                                    case $disapproved:
                                        $buttonText = "Resubmit";
                                        $buttonColor = "#c60d14";
                                        $statusName = "Rejected";
                                        break;
                                    case $approved:
                                        $buttonText = "Completed";
                                        $buttonColor = "#C1C1C1";
                                        $statusName = "Approved";
                                        break;
                                }
                            }
                            break;
                        case "zh_SG":
                            if (is_null($status)) {
                                $buttonText = "待批准";
                                $buttonColor = "#c60d14";
                                $statusName = "Pending";
                            } else {
                                switch ($status) {
                                    case $disapproved:
                                        $buttonText = "重新提交";
                                        $buttonColor = "#c60d14";
                                        $statusName = "Rejected";
                                        break;
                                    case $approved:
                                        $buttonText = "任务完成";
                                        $buttonColor = "#C1C1C1";
                                        $statusName = "Approved";
                                        break;
                                }
                            }
                            break;
                    }
                } else { //before 1st try,
                    $statusName = "Start";
                    switch ($locale) {
                        case "en_SG":
                            $buttonText = "Start";
                            $buttonColor = "#c60d14";
                            break;
                        case "zh_SG":
                            $buttonText = "开始";
                            $buttonColor = "#c60d14";
                            break;
                    }
                }

                $imgName = "";
                switch ($locale) {
                    case "en_SG":
                        $imgName = "background.jpg";
                        break;
                    case "zh_SG":
                        $imgName = "background-cn.jpg";
                        break;
                }

                return response()->json(array(
                    'success' => true,
                    'locale' => $locale,
                    'snap_url' => $snapUrl,
                    'img' => $imgName,
                    'button_text' => $buttonText,
                    'button_color' => $buttonColor,
                    'status_name' => $statusName,
                    'task_over' => $taskOver,
                    'current_datetime' => $currentDateTime,
                    'close_datetime' => $endDatetime,
                    'close_time_remaining_arr' => $close_time_remaining_arr
                ), 200);
            }
        }
    }


    //API
    public function iframe_gpric(Request $request)
    {
        if ($request->has('query')) {
            $query = $request->input('query');

            $dte = new DTEdecode();
            $decryptedData = $dte->decode_id($query, FALSE);
            if ($decryptedData == false) {

                return response()->json(array(
                    'success' => false,
                    'message' => 'Invalid query string. ',
                ), 200);
            } else {

                $locale = $decryptedData->User->LanguageLocaleKey;
                $subchain = $decryptedData->User->Contact->Account->DTE_Sub_Chain__c;
                $custId = $decryptedData->User->Contact->Account->DTE_AccountNumber__c;
                $custId = substr($custId, 2);

                $taskOver = false;


                //$duration = 336; //after 2 weeks program end ((14*24)/2 )
                $taskData = PhotoFeedbackTasksModel::getTaskData($subchain);  //for example duration is 336 hours;

                $diff = "";

                if (sizeof($taskData) <= 0) {
                    return response()->json([
                        'status' => false,
                        'message' => "Couldn't find the Task data of subchain - " . $subchain . ". Please check the Task module. ",
                    ]);
                } else {
                    $taskData = $taskData[0];
                    $taskId = $taskData['id'];
                    $snapUrl = $taskData['snap_url'];
                    $startDatetime = substr($taskData['start_datetime'], 0, -3);
                    $endDatetime = substr($taskData["end_datetime"], 0, -3);
                }

                // $currentYear = Carbon::now()->year;
                // $invoiceDate_year = $currentYear;
                // $invoiceDate_mth = 7; //July
                // $invoiceDate_date = 26;
                // $invoiceHour = 9;
                // $invoiceMin = 0;

                //$closeDatetime = Carbon::create($invoiceDate_year, $invoiceDate_mth, $invoiceDate_date, $invoiceHour, $invoiceMin)->setTimezone('Asia/Singapore')->addHours($duration)->format('Y-m-d H:i');
                $currentDateTime = Carbon::now()->setTimezone('Asia/Singapore')->format('Y-m-d H:i');

                if ($currentDateTime >= $endDatetime) {
                    $close_time_remaining = 0;

                    $close_time_remaining_arr['day'] = (int)0;
                    $close_time_remaining_arr['hours'] = (int)0;
                    $close_time_remaining_arr['mins'] = (int)0;

                    $taskOver = true;
                } else {
                    $endDate = Carbon::parse($endDatetime);
                    $now = Carbon::now("Asia/Singapore");

                    $diff = $now->diff($endDate, false)->format('%I');
                    //$close_time_remaining = $now->diffInHours($endDate) . ' hours ' . $diff . ' minutes';

                    $hours = $now->diffInHours($endDate);
                    $dayHours = 24; //one day 24 hours

                    $close_time_remaining = "";
                    $close_time_remaining_arr = [];
                    $remainDays = 0;
                    $remainHours = 0;
                    $remainMins = $diff;

                    if ($hours > $dayHours) {
                        $days = (int)($hours / $dayHours);
                        $totalHours = $hours % $dayHours;

                        $remainDays = $days;
                        $remainHours = $totalHours;
                    } else {
                        $remainDays = 0;
                        $remainHours = $hours;
                    }

                    $close_time_remaining_arr['day'] = (int)$remainDays;
                    $close_time_remaining_arr['hours'] = (int)$remainHours;
                    $close_time_remaining_arr['mins'] = (int)$remainMins;
                }


                $pfStatus = PhotoFeedbackSubmissionsModel::getStatus($custId, $taskId);

                if (count($pfStatus)) {
                    $status = $pfStatus[0]['status'];
                    $approved =  PhotoFeedbackSubmissionsModel::$approved;
                    $disapproved =  PhotoFeedbackSubmissionsModel::$disapproved;

                    $buttonText = "";
                    $buttonColor = "";

                    switch ($locale) {
                        case "en_SG":
                            if (is_null($status)) {
                                $buttonText = "Pending <br> Approval";
                                $buttonColor = "#c60d14";
                                $statusName = "Pending";
                            } else {
                                switch ($status) {
                                    case $disapproved:
                                        $buttonText = "Resubmit";
                                        $buttonColor = "#c60d14";
                                        $statusName = "Rejected";
                                        break;
                                    case $approved:
                                        $buttonText = "Completed";
                                        $buttonColor = "#C1C1C1";
                                        $statusName = "Approved";
                                        break;
                                }
                            }
                            break;
                        case "zh_SG":
                            if (is_null($status)) {
                                $buttonText = "待批准";
                                $buttonColor = "#c60d14";
                                $statusName = "Pending";
                            } else {
                                switch ($status) {
                                    case $disapproved:
                                        $buttonText = "重新提交";
                                        $buttonColor = "#c60d14";
                                        $statusName = "Rejected";
                                        break;
                                    case $approved:
                                        $buttonText = "任务完成";
                                        $buttonColor = "#C1C1C1";
                                        $statusName = "Approved";
                                        break;
                                }
                            }
                            break;
                    }
                } else { //before 1st try,
                    $statusName = "Start";
                    switch ($locale) {
                        case "en_SG":
                            $buttonText = "Start";
                            $buttonColor = "#c60d14";
                            break;
                        case "zh_SG":
                            $buttonText = "开始";
                            $buttonColor = "#c60d14";
                            break;
                    }
                }

                $imgName = "";
                switch ($locale) {
                    case "en_SG":
                        $imgName = "background.jpg";
                        break;
                    case "zh_SG":
                        $imgName = "background-cn.jpg";
                        break;
                }

                return response()->json(array(
                    'success' => true,
                    'locale' => $locale,
                    'snap_url' => $snapUrl,
                    'img' => $imgName,
                    'button_text' => $buttonText,
                    'button_color' => $buttonColor,
                    'status_name' => $statusName,
                    'task_over' => $taskOver,
                    'current_datetime' => $currentDateTime,
                    'close_datetime' => $endDatetime,
                    'close_time_remaining_arr' => $close_time_remaining_arr
                ), 200);
            }
        }
    }


    public function test_static()
    {
        $logPath = "";
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/photofeedback/sms/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/photofeedback/sms/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $logPath = '/home/game/public_html/pmi-backoffice/storage/photofeedback/sms/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'Photofeedback-SMS-' . $log_date;
        $log = new Logger('Photofeedback-SMS-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        $currentDateTime = Carbon::now()->setTimezone('Asia/Singapore')->format('Y-m-d H:i');

        $allTaskData = PhotoFeedbackTasksModel::whereNull('deleted_at')->get();

        $staticOptionVal = 1;
        $dynamicOptionVal = 2;

        $taskSMS = [];
        $dynamicTaskSMS = [];

        // filter out SMS task need to be same at this time (at this minutes without the second)
        foreach ($allTaskData as $taskData) {

            $options = $taskData->options;

            // Static Option
            if ($options == $staticOptionVal) {
                $startDatetime = substr($taskData->start_datetime, 0, -3);
                $endDatetime = substr($taskData->end_datetime, 0, -3);
                $reminderSMSDatetime = substr($taskData->reminder_datetime, 0, -3);

                echo "$taskData->id $currentDateTime - $reminderSMSDatetime <br>";

                if ($currentDateTime == $reminderSMSDatetime) {
                    array_push($taskSMS, $taskData);
                }
            }
        }

        foreach ($taskSMS as $task) {

            $taskId = $task->id;
            $taskTitle = $task->title;
            $taskSubchainId = $task->subchain_id;
            $reminderSmsEN = $task->reminder_sms_en;
            $reminderSmsCH = $task->reminder_sms_ch;

            $subchainSql = 'SELECT name FROM trade_program_subchain
                                       WHERE id IN (' . $taskSubchainId . ') ';

            $subchainData = DB::select($subchainSql);

            $likeSql = "";
            foreach ($subchainData as $subchainObj) {
                $subchainName = trim($subchainObj->name);
                if ($likeSql == "") {
                    $likeSql .= " LIKE '%$subchainName%' ";
                } else {
                    $likeSql .= " OR SubChain LIKE '%$subchainName%' ";
                }
            }

            $outletNoSubmit = 'SELECT ideCust, strCustBankAcctNum, SubChain, strName, StrAddr, mobile_no FROM qa_payout
                                         LEFT JOIN photo_feedback_submissions ON photo_feedback_submissions.cust_id = qa_payout.ideCust 
                                         AND photo_feedback_submissions.task_id = "' . $taskId . '"
                                         WHERE SubChain ' . $likeSql . ' and photo_feedback_submissions.id IS NULL';


            $outletData = DB::select($outletNoSubmit);
            $outletArr = collect($outletData)->map(function ($x) {
                return (array) $x;
            })->toArray(); //return array

            foreach ($outletArr as $payout) {
                $custId = $payout['ideCust'];
                $subchain = $payout['SubChain'];
                $contactNo = "65" . $payout['mobile_no']; //Payout table phone no format without 65

                if (!empty($contactNo)) {
                    $contactNo = str_replace("+", "", $contactNo);

                    $message =  $reminderSmsEN . "\n\n" . $reminderSmsCH;

                    //$sms = new SmsDome();
                    echo "<br>!!!" . $contactNo . ", Task Info: ($taskId - $taskTitle) <br>" . $message . "<br>";

                    //Testing
                    if ($contactNo == "6598109360") {
                        // echo "!!!" . $contactNo . ", Task Info: (' . $taskId . '-' . $taskTitle . ') <br>" . $message;
                        // if ($sms->send_sms($contactNo, $message)) {
                        //     $log->info($custId . '---' . $contactNo . ' msg success delivered (' . $message . '), Task Info: (' . $taskId . '-' . $taskTitle . ') ');
                        // } else {
                        //     $log->warning($custId . '---' . $contactNo . ' msg not delivered (' . $message . '), Task Info: (' . $taskId . '-' . $taskTitle . ')');
                        // }
                    }
                } else {
                    echo "contact no not found";
                    $log->warning($custId . ' Contact No not available, Task Info: (' . $taskId . '-' . $taskTitle . ')');
                }
            }
        }
    }



    public function test_dynamic()
    {
        $logPath = "";
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/photofeedback/sms/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/photofeedback/sms/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $logPath = '/home/game/public_html/pmi-backoffice/storage/photofeedback/sms/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'Photofeedback-Dynamic-SMS-' . $log_date;
        $log = new Logger('Photofeedback-Dynamic-SMS-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        $currentDateTime = Carbon::now()->setTimezone('Asia/Singapore')->format('Y-m-d H:i');

        $allTaskData = PhotoFeedbackTasksModel::whereNull('deleted_at')->get();

        $staticOptionVal = 1;
        $dynamicOptionVal = 2;

        $dynamicTaskSMS = [];

        // filter out SMS task need to be same at this time (at this minutes without the second)
        foreach ($allTaskData as $taskData) {

            $options = $taskData->options;

            // Dynamic Option
            if ($options == $dynamicOptionVal) {
                $taskDuration = $taskData->task_duration;
                $reminderSmsDay = $taskData->reminder_sms_day;
                $dynamicEndDatetime = $taskData->dynamic_end_datetime;

                if ($taskDuration != "" and $reminderSmsDay != "" and $dynamicEndDatetime != "") {

                    if ($currentDateTime <= $dynamicEndDatetime) {
                        array_push($dynamicTaskSMS, $taskData);
                    }
                }
            }
        }

        // Dynamic Option
        foreach ($dynamicTaskSMS as $dynTask) {

            $taskId = $dynTask->id;
            $taskTitle = $dynTask->title;
            $taskDuration = $dynTask->task_duration;
            $dynamicEndDatetime = $dynTask->dynamic_end_datetime;
            $reminderSmsDay = $dynTask->reminder_sms_day;
            $reminderSmsEN = $dynTask->reminder_sms_en;
            $reminderSmsCH = $dynTask->reminder_sms_ch;

            $subchainId = $dynTask->subchain_id;
            $subchainIdArr = explode(",", $dynTask->subchain_id);

            $subchainNameData = Subchain::select('name')->whereIn('id', $subchainIdArr)->get();

            $subchainNameArr = [];
            foreach ($subchainNameData as $subchainNameRow) {
                echo $subchainNameRow->name;
                array_push($subchainNameArr, $subchainNameRow->name);
            }

            $payoutData = Payout::select('ideCust', 'mobile_no')->whereIn('SubChain', $subchainNameArr)->get();


            $NotSubmittedDataArr = [];
            foreach ($payoutData as $pData) {
                $custId = $pData->ideCust;
                $submissionData = PhotoFeedbackSubmissionsModel::select('cust_id')
                    ->where('cust_id', $custId)
                    ->where('task_id', $taskId)
                    ->limit(1)
                    ->first();

                if (empty($submissionData)) {
                    array_push($NotSubmittedDataArr, $pData);
                }
            }

            foreach ($NotSubmittedDataArr as $NotSubmittedData) {

                $mobileNo = "65" . $NotSubmittedData->mobile_no;
                $leadingZeroCustId = str_pad($NotSubmittedData->ideCust, 5, '0', STR_PAD_LEFT);
                $custIdWithSG = "SG" . $leadingZeroCustId;

                $invoicesData = PhotoFeedbackInvoicesPublish::select('published_date')->where('cust_id', $leadingZeroCustId)
                    ->first();

                if (!empty($invoicesData->published_date)) {
                    $taskEndDate = Carbon::parse($invoicesData->published_date)->addDays($taskDuration);
                    $smsFireDay = Carbon::parse($invoicesData->published_date)->addDays($reminderSmsDay)->toDateString();
                    echo "(" . $custIdWithSG . ") Duration: " . $taskDuration . ", SMS Day:" . $reminderSmsDay . ", Date:" . $invoicesData->published_date . ", SMS Send Date:" . $smsFireDay . ", End date: " . $taskEndDate . "<br>";

                    if (Carbon::now()->toDateString() <= $taskEndDate->toDateString()) {
                        if (Carbon::now()->toDateString() == $smsFireDay) {
                            $sms = new SmsDome();

                            $message =  $reminderSmsEN . "\n\n" . $reminderSmsCH;

                            echo $NotSubmittedData->ideCust . '---' . $mobileNo . ' msg success delivered (' . $message . '), Task Info: (' . $taskId . '-' . $taskTitle . ') ';

                            // if ($sms->send_sms($mobileNo, $message)) {
                            //     $log->info($NotSubmittedData->ideCust . '---' . $mobileNo . ' msg success delivered (' . $message . '), Task Info: (' . $taskId . '-' . $taskTitle . ') ');
                            // } else {
                            //     $log->warning($NotSubmittedData->ideCust . '---' . $mobileNo . ' msg not delivered (' . $message . '), Task Info: (' . $taskId . '-' . $taskTitle . ')');
                            // }
                        }
                    }
                }
            }
        }
    }

    public function testImport()
    {

        $filename = 'CustDTEInvoice.csv';

        $logPath = "";
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $upload_dir = 'C:\wamp64\www\pmi-backoffice\public';
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/photofeedback/invoice/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $upload_dir = '/home/gamestg/gamepmistg_export';
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/photofeedback/invoice/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $upload_dir = '/home/game/gamepmiprod_export';
            $logPath = '/home/game/public_html/pmi-backoffice/storage/photofeedback/invoice/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'photofeedback-invoice-' . $log_date;
        $log = new Logger('SMS-Invoice-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        try {

            $csvPath = $upload_dir . '/' . 'CustDTEInvoice.csv';

            if (file_exists($csvPath)) {
                PhotoFeedbackInvoicesSMS::query()->truncate();
                $result = Excel::import(new PhotoFeedbackInvoicesSMSImport, $csvPath);

                $allInvoiceData = PhotoFeedbackInvoicesSMS::all();

                foreach ($allInvoiceData as $invoiceData) {

                    if (
                        !empty($invoiceData->invoice_date) and
                        $invoiceData->invoice_date != null and
                        $invoiceData->invoice_date != "0000-00-00"
                    ) {
                        $publishData = PhotoFeedbackInvoicesPublish::select("published_date")
                            ->where("cust_id", $invoiceData->cust_id)
                            ->get();

                        if ($publishData->isEmpty()) {

                            $invoicePublish = new PhotoFeedbackInvoicesPublish();
                            $invoicePublish->cust_id = $invoiceData->cust_id;
                            $invoicePublish->published_date =  $invoiceData->invoice_date;

                            $invoicePublish->save();
                        }
                    }
                }
                $log->info($filename . '.csv imported successfully.');
            } else {
                $log->warning($filename . '.csv imported failed.');
            }
        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {

            $log->warning($filename . '.csv imported failed.');
        }
    }

    public function invoiceDownload()
    {
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $csv_dir = '';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $csv_dir = '/home/gamestg/gamepmistg_export';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $csv_dir = '/home/game/gamepmiprod_export';
        }

        $filename = 'CustDTEInvoice.csv';
        $csvPath = $csv_dir . '/' . $filename;

        // clean the output buffer
        ob_clean();
        return Response::download($csvPath);
    }

    public function exportPublish()
    {
        return (new FastExcel($this->publishDataGenerator()))->download('Publish_data-' . date('Y-m-d h:i:sa') . '.csv');
    }

    public function publishDataGenerator()
    {

        $query = DB::connection('mysql')->table('photo_feedback_invoices_publish')
            ->select(['photo_feedback_invoices_publish.cust_id', 'published_date', 'qa_payout.SubChain'])
            ->leftJoin('qa_payout', 'qa_payout.ideCust', '=', 'photo_feedback_invoices_publish.cust_id')
            ->where('qa_payout.SubChain', 'CHEER')
            ->orWhere('qa_payout.SubChain', 'EMCHE')
            ->orWhere('qa_payout.SubChain', 'XPRES')
            ->orderBy('qa_payout.SubChain', 'ASC');

        foreach ($query->cursor() as $data) {
            yield $data;
        }
    }
}
