<?php

namespace App\Http\Controllers;

use App\Permission_group;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use URL;
use View;
use Session;
use Redirect;

class PermissionGroupsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        if (request()->ajax()) {
            $user = DB::connection('mysql')
                ->table('permission_group')
                ->select(['id', 'description']);

            return datatables()->of($user)
                ->addColumn('action', function ($row) {
                    if (auth()->user()->can('edit permissions')){
                        return "<a href='" . URL::to("permission-groups/" . $row->id . "/edit") . "' class='btn btn-default'>Edit</a>";
                    }
                })
                ->rawColumns(['action'])
                ->make();;
        }
    }

    public function show()
    {
        return view('permission-groups.index');
    }

    public function create(){
        return View::make('permission-groups.create');
    }

    public function store(){
        // validate

        $rules = array(
            'description' => 'required',
        );
        $validator = Validator::make(Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return Redirect::to('permission-groups/create')
                ->withErrors($validator)
                ->withInput();
        } else {
            // store
            $permission = new Permission_group;
            $permission->description = Input::get('description');
            $permission->save();

            // redirect
            Session::flash('success', $permission->header.' successfully created Permission Groups!');
            return Redirect::to('permission-groups/list');
        }
        
    }

    public function edit($id)
    {
        // get the Doc
        $permission_group = Permission_group::find($id);
        // show the edit form and pass the doc
        return View::make('permission-groups.edit')
            ->with('permission_group', $permission_group);
    }

    public function update($id)
    {
        $rules = array(
            'description' => 'required',
        );
        $validator = Validator::make(Input::all(), $rules);

        if ($validator->fails()) {
            
            return Redirect::to('permissions/' . $id . '/edit')
                ->withErrors($validator)
                ->withInput();
        } else {
            // store
            $permission_group = Permission_group::find($id);
            $permission_group->description = Input::get('description');
            $permission_group->save();

            // redirect
            Session::flash('success', 'Successfully updated '.$permission_group->name.' permission group!');
            return Redirect::to('permission-groups/list');
        }
    }
}
