<?php

namespace App\Http\Controllers;

use App\Permission;
use App\PermissionGroupMaps;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use URL;
use View;
use Session;
use Redirect;

class PermissionGroupMapsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        if (request()->ajax()) {
            $pg_maps = DB::connection('mysql')
                ->table('permission_group')
                ->leftJoin('permission_group_maps', 'permission_group_maps.permission_group_id', '=', 'permission_group.id')
                ->leftJoin('permissions', 'permission_group_maps.permission_id', '=', 'permissions.id')
                ->select(['permission_group.id', DB::raw('group_concat(permissions.name) as p_name'), 'permission_group.description as pg_name'])
                ->orderBy('id')
                ->groupBy('description');

            return datatables()->of($pg_maps)
                ->addColumn('action', function ($row) {
                    if (auth()->user()->can('edit permissions')) {
                        return "<a href='" . URL::to("permission-group-maps/" . $row->id . "/edit") . "' class='btn btn-default'>Edit</a>";
                    }
                })
                ->rawColumns(['action'])
                ->make();
        }
        return view('permission-group-maps.index');
    }

    public function show()
    {
        return view('permission-group-maps.index');
    }

    public function create()
    {
        return View::make('permission-groups.create');
    }

    public function store()
    {
        // validate

        $rules = array(
            'description' => 'required',
        );
        $validator = Validator::make(Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return Redirect::to('permission-groups/create')
                ->withErrors($validator)
                ->withInput();
        } else {
            // store
            $permission = new Permission_group;
            $permission->description = Input::get('description');
            $permission->save();

            // redirect
            Session::flash('success', $permission->header . ' successfully created Permission Groups!');
            return Redirect::to('permission-groups/list');
        }
    }

    public function edit($id)
    {
        $permissions = Permission::all();

        $pgm = DB::connection('mysql')
            ->table('permission_group')
            ->leftJoin('permission_group_maps', 'permission_group_maps.permission_group_id', '=', 'permission_group.id')
            ->leftJoin('permissions', 'permission_group_maps.permission_id', '=', 'permissions.id')
            ->select(['permission_group.id', DB::raw('group_concat(permissions.name) as p_name'), 'permission_group.description as pg_name'])
            ->where('permission_group.id', $id)
            ->groupBy('description')
            ->get();

        $permission_names = $pgm[0]->p_name;
        $permission_names = explode(',', $permission_names);
        // show the edit form and pass the doc
        return View::make('permission-group-maps.edit')
            ->with('id', $id)
            ->with('permissions', $permissions)
            ->with('pgm', $pgm)
            ->with('permission_names', $permission_names);
    }

    public function update(Request $request, $id)
    {

        $permissions = $request->get('permissions', []);

        for ($i = 0; $i <= (count($permissions) - 1); $i++) {
            $permissions_arr[] = [
                'permission_id' => $permissions[$i],
                'permission_group_id' => $id
            ];
        }

        $pgm = PermissionGroupMaps::where('permission_group_id', $id)->delete();

        //var_dump($permissions_arr);exit();

        if (!empty($permissions_arr)) {
            PermissionGroupMaps::insert($permissions_arr);
        }

        // redirect
        Session::flash('success', 'Successfully updated permission group maps!');
        return Redirect::to('permission-group-maps/list');
    }
}
