<?php

namespace App\Http\Controllers;

use Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\Lead_files;
use App\Models\Lead_data;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Response;

use Rap2hpoutre\FastExcel\FastExcel;

class LeadReportController extends Controller
{
    public $carton = 20;

    public function importView()
    {
        return view('lead.import');
    }

    public function index()
    {

        if (request()->ajax()) {
            $gt = DB::connection('mysql')
                ->table('lead_files')
                ->select(['id', 'file_name', 'created_at'])
                ->orderByDesc('created_at');

            return datatables()->of($gt)
                ->addColumn('download', function ($row) {
                    if (auth()->user()->can('import loyalty')) {
                        return "<a href='" . url("api/download-lead-history-files/" . $row->id) . "' class='btn btn-default'>Download</a>";
                    }
                })
                ->rawColumns(['download'])
                ->make(true);
        }

        return view('lead.import');
    }

    public function download_lead_file($fileId)
    {

        $filesInfo = Lead_files::find($fileId);

        $path = storage_path() . '/' . 'app' . '/lead-history-files/' . $filesInfo->file_name;
        if (file_exists($path)) {
            ob_end_clean(); // this
            //ob_start();
            return Response::download($path);
        }
    }

    public function import(Request $request)
    {

        //ini_set('memory_limit', '1024M');
        set_time_limit(0);
        ini_set('mysql.connect_timeout', '0');
        ini_set('max_execution_time', '0');
        ini_set('default_socket_timeout', 9000);

        if ($request->hasFile('file')) {

            DB::beginTransaction();

            try {

                $fileOriginName = $request->file('file')->getClientOriginalName();
                $saveFileName = Carbon::now()->format("Y-m-d His") . '-' . $fileOriginName;

                $path = $request->file('file')->storeAs(
                    'lead-history-files',
                    $saveFileName
                );

                $path = storage_path('app/' . $path);

                $leadFile = new Lead_files;

                $leadFile->file_name = $saveFileName;
                $leadFile->path_name = $path;
                $leadFile->updated_at = null;
                $leadFile->save();

                // $leadCollection = (new FastExcel)->import($path);
                // $leadCollection->filter()->each(function ($line) {

                //     Lead_data::create([
                //         'name' => $line['Full Name'],
                //         'email' => $line['Email'],
                //         'dob' => $line['Date of Birth'],
                //         'mobile' => $line['Mobile'],
                //         'stage' => $line['Stage'],
                //         'created_date' => $line['Created Date'],
                //         'account_number' => $line['Contact Retailer: Account: Account Number'],
                //         'account_name' => $line['Contact Retailer: Account: Account Name'],
                //         'full_name' => $line['Contact Retailer: Full Name'],
                //         'retailer_email' => $line['Contact Retailer: Email'],
                //         'user_id' => $line['Contact Retailer: User ID']
                //     ]);
                // });

                Session::flash('success', 'Lead Report file uploaded!');

                DB::commit();
            } catch (QueryException $ex) {
                DB::rollback();
                Session::flash()->error('Lead Report file failed! ' . $ex);
            }

            return back();
        } else {
            $logPath = "";
            $host = request()->getHost();
            if (strstr($host, 'localhost') || strstr($host, '192.168')) {
                $csv_dir = '';
                $logPath = 'C:\wamp64\www\pmi-backoffice/storage/gt/';
            } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
                $upload_dir = '/home/gamestg/gamepmistg_export';
                $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/gt/';
            } else if (strstr($host, 'games.pmisg.cloud.sg')) {
                $upload_dir = '/home/game/gamepmiprod_export';
                $logPath = '/home/game/public_html/pmi-backoffice/storage/gt/';
            }

            $log_date = Carbon::now()->format('Y-m-d');
            $log_name = 'Lead-Report-' . $log_date;
            $log = new Logger('Lead-Report-log');
            $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

            $filename = 'Data - Lead Report.csv';

            try {

                $csvPath = $upload_dir . '/' . $filename;

                if (file_exists($csvPath)) {
                    GT::query()->truncate();
                    $result = Excel::import(new GTImport, $csvPath);

                    $allInvoiceData = GT::all();

                    $log->info($filename . ' imported successfully.');
                } else {
                    $log->warning($filename . ' imported failed. ' . $csvPath);
                }
            } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {

                $log->warning($filename . '.csv imported failed. ' . $csvPath);
            }
        }
    }
}
