<?php

namespace App\Http\Controllers;

use Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Helpers\DTEdecode;
use App\Models\GtPastIncetive_files;
use App\Models\GtPastIncentive;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Response;

use Rap2hpoutre\FastExcel\FastExcel;

class GtPastIncentiveController extends Controller
{
    public $carton = 20;

    public function importView()
    {
        return view('gt-past-incentive.import');
    }

    public function index()
    {

        if (request()->ajax()) {
            $gt = DB::connection('mysql')
                ->table('gt_past_incentive_files')
                ->select(['id', 'file_name', 'created_at'])
                ->orderByDesc('created_at');

            return datatables()->of($gt)
                ->addColumn('download', function ($row) {
                    if (auth()->user()->can('import past-incentive')) {
                        return "<a href='" . url("api/download-gt-past-incentive-files/" . $row->id) . "' class='btn btn-default'>Download</a>";
                    }
                })
                ->rawColumns(['download'])
                ->make(true);
        }

        return view('gt-past-incentive.import');
    }

    public function download_gt_past_file($fileId)
    {

        $filesInfo = GtPastIncetive_files::find($fileId);

        $path = storage_path() . '/' . 'app' . '/gt-past-incentive-files/' . $filesInfo->file_name;
        echo $path;
        if (file_exists($path)) {
            ob_end_clean(); // this
            ob_start();
            return Response::download($path);
        }
    }

    public function import(Request $request)
    {

        //ini_set('memory_limit', '1024M');
        set_time_limit(0);
        ini_set('mysql.connect_timeout', '0');
        ini_set('max_execution_time', '0');
        ini_set('default_socket_timeout', 9000);

        DB::beginTransaction();

        try {

            $fileOriginName = $request->file('file')->getClientOriginalName();
            $saveFileName = Carbon::now()->format("Y-m-d His") . '-' . $fileOriginName;

            $path = $request->file('file')->storeAs(
                'gt-past-incentive-files',
                $saveFileName
            );

            $path = storage_path('app/' . $path);

            $leadFile = new GtPastIncetive_files();

            $leadFile->file_name = $saveFileName;
            $leadFile->path_name = $path;
            $leadFile->updated_at = null;
            $leadFile->save();

            // $leadCollection = (new FastExcel)->import($path);
            // $leadCollection->filter()->each(function ($line) {

            //     GtPastIncentive::create([
            //         'customer_code' => $line['CustomerCode'],
            //         'customer_name' => $line['CustomerName'],
            //         'base_target_month' => $line['Base Target Month'],
            //         'base_target' => $line['Base Target'],
            //         'product_price_segment_desc' => $line['ProductPriceSegmentDescription'],
            //         'product_family_desc' => $line['ProductFamilyDescription'],
            //         'time_id' => $line['TimeId'],
            //         'ims' => $line['IMS'],
            //         'buy_enough_rebate' => $line['Buy Enough Rebate'],
            //         'buy_above_rebate' => $line['Buy Above Rebate'],
            //         'total_rebate' => $line['Total Rebate'],
            //         'chain' => $line['Chain']
            //     ]);
            // });

            Session::flash('success', 'GT Past Incentive file uploaded!');

            DB::commit();
        } catch (QueryException $ex) {
            DB::rollback();
            Session::flash()->error('GT Past Incentive file failed! ' . $ex);
        }

        return back();
    }
}
