<?php

namespace App\Http\Controllers;

use App\Helpers\DTEdecode;
use App\BackofficeGameplay;
use App\Models\BackofficeGameplay2022May;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Input;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Illuminate\Support\Facades\DB;
use Rap2hpoutre\FastExcel\FastExcel;
use Rap2hpoutre\FastExcel\SheetCollection;

class Game2022Controller extends Controller
{

    public $scorePass = 100;
    public $QACliendId = '9b343f4ee91a434fbda4ab3b82d08d10';
    public $QAClientSecret = '49D1a1b09e934A8387c0291f8774987D';

    public $ProCliendId =  '4a2dbd8c61a14e2ca2718985ad835c0f';
    public $ProCliendSecret =  '279a89CE72704bdba0610cd8147DBA61';

    //public $launchDate = "2022-02-14";

    public $jigsawPoint = "jigsaw-2022";
    public $jigsawNoPoint = "jigsaw-2022-nopoint";

    public $matchGame2a = "match2a-2022";
    public $matchGame2b = "match2b-2022";

    public $adventureGame = "adventure-2022";

    public function get_locale(Request $request)
    {

        if ($request->has("query")) {

            $query = $request->input('query');
            $dte = new DTEdecode();
            $decryptedData = $dte->decode_id($query, false);
            if ($decryptedData == false) {

                return response()->json(array(
                    'success' => false,
                    'message' => 'Invalid query string. ',
                ), 200);
            }

            $dteUser = $decryptedData->User;

            if (
                empty($dteUser->Contact->Account->DTE_AccountNumber__c) or
                empty($dteUser->Contact->Account->DTE_Chain__c)
            ) {
                return response()->json(array(
                    'success' => false,
                    'message' => 'Invalid decrypted info. ',
                ), 200);
            }
            $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;
            $locale = $dteUser->LanguageLocaleKey; // if English is en_MY, if Melayu is ms

            return response()->json(array(
                'success' => true,
                'message' => 'Retrieve locale successfully.',
                'cust_code' => $customerCodeMY,
                'locale' => $locale
            ), 200);
        } else {
            return response()->json(['status' => false, 'message' => "Requested value not found."], 500);
        }
    }

    public function awardPoints($data)
    {
        //Log
        $logPath = "";
        $curlEndpoint = "";
        $host = request()->getHost();
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $curlEndpoint = "https://service.qa-pmidce2.com/dte/v1/api/v1/dte/ingestion";
            $logPath = 'C:\wamp64\www\pmi-backoffice-my/storage/Gameplay2022/';

            $transactionReasonType = 'a0F4H00000iHrBhUAK';
            $tradeProgram = 'a0N5800000Jpo4S';
            $cliendId = $this->QACliendId;
            $clientSecret = $this->QAClientSecret;
        } else {
            $curlEndpoint = "https://api.iqos.com/dte/v1/api/v1/dte/ingestion";
            $logPath = '/opt/bitnami/apache/htdocs/pmi-backoffice-my/storage/app/gameplay2022';

            $transactionReasonType = 'a0F4H00000iHrBhUAK';
            $tradeProgram = 'a0N5800000Jpo4S';
            $cliendId = $this->ProCliendId;
            $clientSecret = $this->ProCliendSecret;
        }

        $cliendId = $this->ProCliendId;
        $clientSecret = $this->ProCliendSecret;

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'Gameplay2022-awards-' . $log_date;
        $log = new Logger('Gameplay2022-awards-log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        $custId = $data['custId'];
        $contactId = $data['contactId'];
        //$awardPoints = 5;
        $awardPoints = $data['points'];
        $statusPoints = 0;
        $transactionReasonType = $transactionReasonType;
        $tradeProgram = $tradeProgram;
        $dateOfTransaction = $data['dateOfTransaction'];
        //$transactionDescription = "Onboarding Game";
        $gameName = $data['gameName'];
        $activityType = "iFrameExternalStatusPoints";

        $transactionDescription = "";
        switch ($gameName) {
            case $this->jigsawPoint:
                $transactionDescription = "Onboarding Game";
                break;
            case $this->matchGame2a:
                $transactionDescription = "Match the Old and New Pack";
                break;
            case $this->matchGame2b:
                $transactionDescription = "Match the Smoke Smell Control Icon with Description";
                break;
            case $this->adventureGame:
                $transactionDescription = "Choose Your Adventure";
                break;
        }

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $curlEndpoint,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_POSTFIELDS => '{
              "contactId": "' . $contactId . '",
              "awardPoints": ' . $awardPoints . ',
              "statusPoints": ' . $statusPoints . ',
              "trasactionReasonType": "' . $transactionReasonType . '",
              "tradeProgram": "' . $tradeProgram . '",
              "dateOfTransaction": "' . $dateOfTransaction . '",
              "transactionDescription": "' . $transactionDescription . '",
              "activityType": "' . $activityType . '"
          }',
            CURLOPT_HTTPHEADER => array(
                'X-Channel: DTE',
                'client_id: ' . $cliendId,
                'client_secret: ' . $clientSecret,
                'Content-Type: application/json',
                'X-Correlation-Id: kntest3'
            ),
        ));

        $response = curl_exec($curl);
        $responseObjects = json_decode($response);

        $responseData = [];


        if ($responseObjects->code === 500) {

            $errorContent = $responseObjects->errors;
            //$errorContent[0]->shortDescription
            $log->warning('Points  (' . $awardPoints . ') failed credit to ' . $custId . ' (ContactId: ' . $contactId . ') | Error: ' . $errorContent[0]->errorCode);

            $responseData['status'] = false;
            $responseData['response'] = $errorContent[0]->errorCode;
        } else {
            $log->info('Points (' . $awardPoints . ') credited to ' . $custId . ' (ContactId: ' . $contactId . ')');

            $responseData['status'] = true;
            $responseData['response'] = $responseObjects->{'response-data'};
        }

        return $responseData;

        //echo stripslashes($response);
    }

    //API
    public function completed($id, Request $request)
    {
        if (!empty($id)) {

            $gameplay = BackofficeGameplay2022May::find($id);

            if ($request->has("score")) {

                if (!empty($gameplay)) {

                    $score = $request->input('score');
                    $gameplay->score = $score;
                    $gameplay->end = Carbon::now()->format('Y-m-d H:i:s');
                    //$gameplay->send_to_dte = Carbon::now()->format('Y-m-d H:i:s');

                    $gameName = $gameplay->game;

                    $custId = $gameplay->cust_id;
                    $contactId = $gameplay->contact_id;
                    $points = $gameplay->points;

                    if ($gameplay->save()) {

                        $totalGamePlayed = BackofficeGameplay2022May::totalGamePlays($custId, $gameName);
                        $numPlayed = $totalGamePlayed[0]['numPlayed'];

                        $submitted = BackofficeGameplay2022May::chkSubmitted($custId, $gameName);
                        $dte_submitted = (count($submitted) > 0) ? true : false;

                        $data = [];
                        $data['custId'] = $custId;
                        $data['contactId'] = $contactId;
                        $data['points'] = $points;
                        $data['dateOfTransaction'] = Carbon::now()->format('Y-m-d');
                        $data['gameName'] = $gameName;

                        if ($score == 0) {

                            return response()->json(array(
                                'success' => true,
                                'message' => 'Game completed.',
                                'total_game_plays' => $numPlayed,
                                'dte_submitted' => false,
                                'game_pass' => true,
                                'data' => $gameplay
                            ), 200);

                            // if score is 1
                        } else {


                            //////Mulesoft points award logic

                            if ($dte_submitted === false) {

                                if (
                                    $gameName == $this->jigsawPoint or
                                    $gameName == $this->matchGame2a or
                                    $gameName == $this->matchGame2b or
                                    $gameName == $this->adventureGame
                                ) {

                                    $gameplay->send_to_dte = Carbon::now()->format('Y-m-d H:i:s');

                                    if ($gameplay->save()) {

                                        $awardResponse = $this->awardPoints($data);

                                        $updateGameplay = BackofficeGameplay2022May::find($id);

                                        if ($awardResponse['status'] === true) { // if SUCCESS

                                            $updateGameplay->add_to_dte = Carbon::now()->format('Y-m-d H:i:s');
                                            $awardResponse = json_encode($awardResponse['response']);
                                            $updateGameplay->dte_message = strval($awardResponse);

                                            if ($updateGameplay->save()) {

                                                return response()->json(array(
                                                    'success' => true,
                                                    'message' => $points . ' Points success credited.',
                                                    'total_game_plays' => $numPlayed,
                                                    'dte_submitted' => true,
                                                    'game_pass' => true,
                                                    'data' => $gameplay
                                                ), 200);
                                            } else {
                                                return response()->json(array(
                                                    'success' => false,
                                                    'message' => $points . ' Points success credited but save error.',
                                                    'data' => $gameplay,
                                                    'total_game_plays' => null,
                                                    'dte_submitted' => null,
                                                    'game_pass' => true
                                                ), 500);
                                            }
                                        } else {

                                            $updateGameplay->dte_message = $awardResponse['response'];
                                            $updateGameplay->save();

                                            $msg = "";
                                            if (!empty($awardResponse['response']))
                                                $msg = $points . ' Points fail credited. Error (' . $awardResponse['response'] . ')';
                                            else
                                                $msg = $points . ' Points fail credited. ';

                                            return response()->json(array(
                                                'success' => false,
                                                'message' => $msg,
                                                'data' => $gameplay,
                                                'total_game_plays' => null,
                                                'dte_submitted' => null,
                                                'game_pass' => true
                                            ), 500);
                                        }
                                    } else { //if db save failed
                                        return response()->json(array(
                                            'success' => false,
                                            'message' => 'Cannot save (send_to_dte) failed.',
                                            'cust_id' => $custId,
                                            'total_game_plays' => null,
                                            'dte_submitted' => null,
                                            'game_pass' => true
                                        ), 500);
                                    }
                                } else { // if jigsaw-2021-nopoint
                                    return response()->json(array(
                                        'success' => true,
                                        'message' => 'Game completed.',
                                        'total_game_plays' => $numPlayed,
                                        'dte_submitted' => false,
                                        'game_pass' => true,
                                        'data' => $gameplay
                                    ), 200);
                                }
                            } else { //if points awarded
                                return response()->json(array(
                                    'success' => true,
                                    'message' => 'Points awarded.',
                                    'total_game_plays' => $numPlayed,
                                    'dte_submitted' => true,
                                    'game_pass' => true,
                                    'data' => $gameplay
                                ), 200);
                            }
                        }

                        // } else { //if score below than minimum requirement score

                        //     return response()->json(array(
                        //         'success' => true,
                        //         'message' => $score . ' score is below ' . $this->scorePass . '. ',
                        //         'total_game_plays' => $numPlayed,
                        //         'dte_submitted' => $dte_submitted,
                        //         'game_pass' => false,
                        //         'data' => $gameplay
                        //     ), 200);
                        // }
                    } else { //if saved failed

                        return response()->json(array(
                            'success' => false,
                            'message' => 'Failed.',
                            'cust_id' => $custId,
                            'total_game_plays' => null,
                            'dte_submitted' => null
                        ), 500);
                    }
                } else { //if id not found in the table
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Data (id: ' . $id . ') not found.',
                    ), 500);
                }
            } else { //if points property not found
                return response()->json(array(
                    'success' => false,
                    'message' => 'Points value not found.',
                ), 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing (id) property or value."], 500);
        }
    }

    //API
    public function replay($id)
    {
        if (!empty($id)) {

            $gameplay = BackofficeGameplay2022May::find($id);

            if (!empty($gameplay)) {
                $gameplay->game_retry = Carbon::now()->format('Y-m-d H:i:s');
                $custId = $gameplay->cust_id;

                if ($gameplay->save()) {

                    return response()->json(array(
                        'success' => true,
                        'message' => 'Success.',
                        'data' => $gameplay
                    ), 200);
                } else {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Failed.',
                        'cust_id' => $custId
                    ), 500);
                }
            } else {
                return response()->json(array(
                    'success' => false,
                    'message' => 'Data (id: ' . $id . ') not found.',
                ), 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing (id) property or value."], 500);
        }
    }

    //API
    public function start($id, Request $request)
    {

        if (!empty($id)) {

            $gameplay = BackofficeGameplay2022May::find($id);

            if (!empty($gameplay)) {
                if (is_null($gameplay->game_start)) {
                    $gameplay->game_start = Carbon::now()->format('Y-m-d H:i:s');
                    $custId = $gameplay->cust_id;
                    $gameName = $gameplay->game;

                    if ($gameplay->save()) {

                        $totalGamePlayed = BackofficeGameplay2022May::totalGamePlays($custId, $gameName);
                        $submitted = BackofficeGameplay2022May::chkSubmitted($custId, $gameName);

                        $numPlayed = $totalGamePlayed[0]['numPlayed'];
                        $dte_submitted = (count($submitted) > 0) ? true : false;

                        return response()->json(array(
                            'success' => true,
                            'message' => 'Success.',
                            'total_game_plays' => $numPlayed,
                            'dte_submitted' => $dte_submitted,
                            'data' => $gameplay,
                            //'dte_data' => $decryptedData
                        ), 200);
                    } else {
                        return response()->json(array(
                            'success' => false,
                            'message' => 'Failed.',
                            'cust_id' => $custId,
                            'total_game_plays' => null,
                            'dte_submitted' => null,
                            //'dte_data' => $decryptedData
                        ), 500);
                    }
                } else {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Game have started - ' . $gameplay->game_start . '. ',
                    ), 500);
                }
            } else {
                return response()->json(array(
                    'success' => false,
                    'message' => 'Data (id: ' . $id . ') not found.',
                ), 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Missing (id) property or value."], 500);
        }
    }

    public function init(Request $request)
    {

        if ($request->all()) {
            if (
                $request->has("query") and
                $request->has("user_agent") and
                $request->has("game")
            ) {

                $query = $request->input('query');
                $dte = new DTEdecode();
                $decryptedData = $dte->decode_id($query, TRUE);
                if ($decryptedData == false) {

                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid query string. ',
                    ), 200);
                }

                // check game name
                $validName = false;
                switch (Input::get('game')) {
                    case $this->jigsawPoint:
                    case $this->jigsawNoPoint:
                    case $this->matchGame2a:
                    case $this->matchGame2b:
                    case $this->adventureGame:
                        $validName = true;
                        break;
                }

                if ($validName == false) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Game Name invalid. ',
                    ), 500);
                }
                //$dteRelatedAccounts = $decryptedData->RelatedAccounts;
                $dteUser = $decryptedData->User;

                if (
                    empty($dteUser->Contact->Account->DTE_AccountNumber__c) or
                    empty($dteUser->Contact->Account->DTE_Chain__c)
                ) {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Invalid decrypted info. ',
                    ), 200);
                }
                $customerCodeMY = $dteUser->Contact->Account->DTE_AccountNumber__c;
                $chain = $dteUser->Contact->Account->DTE_Chain__c;

                $customerCode = substr($customerCodeMY, 2);

                $firstName = $decryptedData->User->FirstName;
                $lastName = $decryptedData->User->LastName;
                $contactId = $decryptedData->User->ContactId;
                $dteId = $decryptedData->User->Id;
                $email = $decryptedData->User->Email;


                $targetAudience = ['GTP1', 'GTP2', 'PMC', 'CVS'];

                // if (!in_array($subchain, $targetAudience)) {
                //     return response()->json(array(
                //         'success' => false,
                //         'message' => 'Failed. Not appicable to this audience',
                //         'cust_id' => $custId,
                //         'total_game_plays' => null,
                //         'dte_submitted' => null,
                //         'dte_data' => $decryptedData
                //     ), 500);
                // }

                $points = 0;

                // if jigsaw-2021
                // if (Input::get('game') == $this->jigsawPoint) {
                //     $points = 50;
                // }

                switch (Input::get('game')) {
                    case $this->jigsawPoint:
                    case $this->matchGame2a:
                    case $this->matchGame2b:
                    case $this->adventureGame:
                        $points = 50;
                        break;
                }

                $gameplay = new BackofficeGameplay2022May();
                $gameplay->cust_id = $customerCode;
                $gameplay->dte_id = $dteId;
                $gameplay->contact_id = $contactId;
                $gameplay->first_name = $firstName;
                $gameplay->last_name = $lastName;
                $gameplay->chain = $chain;
                $gameplay->email = $email;
                $gameplay->user_agent = Input::get('user_agent');
                $gameplay->start = Carbon::now()->format('Y-m-d H:i:s');
                $gameplay->game = Input::get('game');
                $gameplay->points = $points;

                if ($gameplay->save()) {

                    $totalGamePlayed = BackofficeGameplay2022May::totalGamePlays($customerCode, Input::get('game'));
                    $submitted = BackofficeGameplay2022May::chkSubmitted($customerCode, Input::get('game'));

                    $numPlayed = $totalGamePlayed[0]['numPlayed'];
                    $dte_submitted = (count($submitted) > 0) ? true : false;

                    return response()->json(array(
                        'success' => true,
                        'message' => 'Success.',
                        'total_game_plays' => $numPlayed,
                        'dte_submitted' => $dte_submitted,
                        'data' => $gameplay,
                        'dte_data' => $decryptedData
                    ), 200);
                } else {
                    return response()->json(array(
                        'success' => false,
                        'message' => 'Failed.',
                        'cust_id' => $customerCode,
                        'total_game_plays' => null,
                        'dte_submitted' => null,
                        'dte_data' => $decryptedData
                    ), 500);
                }
            } else {

                return response()->json(['status' => false, 'message' => "Missing property or value."], 500);
            }
        } else {
            return response()->json(['status' => false, 'message' => "Requested value not found."], 500);
        }
    }

    public function export()
    {

        $sheets = new SheetCollection([
            'Successful (send 5 Points)' => $this->exportSuccess(),
            'First Try' => $this->exportFirstTime(),
            'Replay Time' => $this->exportReplayTime(),
            'All' => $this->exportAll(),
        ]);

        return (new FastExcel($sheets))->download('Jigsaw2021_' . date('Y-m-d h:i:sa') . '.xlsx');
        //return (new FastExcel($this->dataGenerator()))->download('Snake_Game_' . date('Y-m-d h:i:sa') . '.csv');
    }

    public function exportSuccess()
    {

        $query = DB::connection('mysql')->table('backoffice_gameplay_2021')
            ->where('game', '=', 'jigsaw-2021')
            ->whereNotNull('send_to_dte');

        foreach ($query->cursor() as $data) {
            yield $data;
        }
    }

    public function exportFirstTime()
    {

        $query = DB::connection('mysql')
            ->table('backoffice_gameplay_2021')
            ->select(DB::raw('DISTINCT(cust_id), backoffice_gameplay_2021.*'))
            ->where('game', '=', 'jigsaw-2021')
            ->whereNotNull('game_start')
            ->whereNotNull('end');

        foreach ($query->cursor() as $data) {
            yield $data;
        }
    }

    public function exportReplayTime()
    {

        $query = DB::connection('mysql')
            ->table('backoffice_gameplay_2021')
            ->select(DB::raw('cust_id, count(*) as num_play'))
            ->where('game', '=', 'jigsaw-2021')
            ->whereNotNull('game_start')
            ->groupBy('cust_id');

        foreach ($query->cursor() as $data) {
            yield $data;
        }
    }

    public function exportAll()
    {

        $query = DB::connection('mysql')
            ->table('backoffice_gameplay_2021')
            ->where('game', '=', 'jigsaw-2021');

        foreach ($query->cursor() as $data) {
            yield $data;
        }
    }
}
