<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Mail;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Dashboard;
use Illuminate\Support\Carbon;

use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Illuminate\Support\Facades\Password;

class EmailController extends Controller
{
    function _logging($message, $action, $additional_messages = [])
    {
        ///////////////Logging/////////////////////		
        $log_date = Carbon::now()->format('Ymd');
        $log_name = 'EmailRetailer_log_' . $log_date;
        $log = new Logger('EmailRetailer_log');
        $log->pushHandler(new StreamHandler(LOG_PATH . $log_name . '.log'));
        ///////////////Logging/////////////////////

        switch ($action) {
            case 'Error':
                $log->error($message, $additional_messages);
                break;
            case 'Warning':
                $log->warning($message, $additional_messages);
                break;
            case 'Info':
                $log->info($message, $additional_messages);
                break;
            case 'Emergency':
                $log->emergency($message, $additional_messages);
                break;
            case 'Notice':
                $log->notice($message, $additional_messages);
                break;
            case 'Critical':
                $log->critical($message, $additional_messages);
                break;
            default:
                $log->info($message, $additional_messages);
                break;
        }
    }

    /*
    public function html_email($email, $pwd)
    {

        $msg = "Testing\n";
        $emails = [$email, 'samrong.tee@onyxisland.com'];
        $data = array('password' => $pwd, 'body' => $msg, 'url' => URL::temporarySignedRoute(
            'unsubscribe', now()->addMinutes(30), ['user' => 1]
        ));
        Mail::send('emails.mail', $data, function ($message) use ($emails) {
            $message->to($emails, 'Test')->subject('Test');
            $message->from('samrong.tee@onyxisland.com', 'PMI');
        });
        //echo "HTML Email Sent. Check your inbox.";

    
        // $data = array('name' => "Test", 'body' => 'Test...');
        //Mail::send('emails.mail', $data, function ($message) {
        //    $message->to('samrong.tee@onyxisland.com', 'Test')->subject('Laravel HTML Testing Mail');
        //    $message->from('samrong.tee@onyxisland.com', 'sr');
        //});
        //echo "HTML Email Sent. Check your inbox.";

    }
    */

    public function html_email($email, $pwd)
    {
        $credentials = ['email' => $email];
        $response = Password::sendResetLink($credentials, function (Message $message) {
            $message->subject($this->getEmailSubject());
        });

        switch ($response) {
            case Password::RESET_LINK_SENT:
                return redirect()->back()->with('status', trans($response));
            case Password::INVALID_USER:
                return redirect()->back()->withErrors(['email' => trans($response)]);
        }
    }
}
