<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Console\Commands\AuthPermissionCommand;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */

    protected $commands = [
        //AuthPermissionCommand::class
        'App\Console\Commands\ChkPasswordHistories',
        'App\Console\Commands\DeletePasswordHistories',
        'App\Console\Commands\ImportGT',
        'App\Console\Commands\ImportGTfromEmail',
        'App\Console\Commands\ImportKA',
        'App\Console\Commands\ImportLead',
        'App\Console\Commands\ImportGTPastIncentive'
        //'App\Console\Commands\BalanceTakingEmail',
        //'App\Console\Commands\BalanceTakingEmail',
    ];

    /**
     * Define the application's command schedule. 
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')
        //          ->hourly();

        $schedule->command('delete:password_histories')
            //->hourly();
            //->everyTenMinutes();
            ->dailyAt('11:00');
        $schedule->command('command:password_histories')
            //->everyTenMinutes();
            ->dailyAt('12:00');

        $schedule->command('command:importGT')
            ->cron('0 12 * * *');

        $schedule->command('command:ImportGTfromEmail')
            ->cron('0 12 * * *');

        $schedule->command('command:importKA')
            ->cron('15 12 * * *');

        $schedule->command('command:importLead')
            ->cron('30 12 * * *');

        $schedule->command('command:importGTPastIncentive')
            ->cron('45 12 * * *');

        //$schedule->command('command:photo_feedback_static')
        //    ->cron('* * * * *');

    }

    /**
     * Register the Closure based commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        require base_path('routes/console.php');
    }
}
