<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use App\User;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Mail;
use App\Mail\ResetEmail;
use Illuminate\Support\Facades\DB;
use App\Mail\RemainderPasswordExpire;

class ChkPasswordHistories extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:password_histories';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check Password Histories';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //only send email once
        /*
        $selectSql = "SELECT id, email, (password_changed_at + INTERVAL 23 DAY) as date
                      FROM `backoffice_users`
                      WHERE password_changed_at + INTERVAL 23 DAY = DATE(NOW()) ";
        */

        //send email every day before the expiry date 
        $expiringDays = config('auth.password_expires_days');
        $emailFireDay = $expiringDays - 5;
        //$emailFireDay = $expiringDays - 1;
        //$emailFireDay = $expiringDays - 7; // before one week fire
        $selectSql = 'SELECT id, email, password_changed_at, (password_changed_at + INTERVAL ' . $emailFireDay . ' DAY) as start_date, (password_changed_at + INTERVAL ' . $expiringDays . ' DAY) as expiry_date
                      FROM `backoffice_users`
                      WHERE NOW() BETWEEN (password_changed_at + INTERVAL ' . $emailFireDay . ' DAY) AND (password_changed_at + INTERVAL ' . $expiringDays . ' DAY) ';

        $userList = DB::select($selectSql);
        $userListArr = collect($userList)->map(function ($x) {
            return (array) $x;
        })->toArray(); //return array

        $host = request()->getHost();

        $logPath = "";
        if (strstr($host, 'localhost') || strstr($host, '192.168')) {
            $logPath = 'C:\wamp64\www\pmi-backoffice/storage/password-remainder/';
        } else if (strstr($host, 'games-staging.pmisg.cloud.sg')) {
            $logPath = '/home/gamestg/public_html/pmi-backoffice/storage/password-remainder/';
        } else if (strstr($host, 'games.pmisg.cloud.sg')) {
            $logPath = '/home/game/public_html/pmi-backoffice/storage/password-remainder/';
        }

        $log_date = Carbon::now()->format('Y-m-d');
        $log_name = 'password-remainder-' . $log_date;
        $log = new Logger('PasswordRemainder_log');
        $log->pushHandler(new StreamHandler($logPath . $log_name . '.log'));

        $emailFailedListArr = [];
        $emailPassListArr = [];
        foreach ($userListArr as $userData) {

            $user = User::find($userData['id']);
            $token = Password::broker()->createToken($user);
            $user->expired_date =  $userData['expiry_date'];

            Mail::to($user->email)->send(new RemainderPasswordExpire($user, $token));

            if (Mail::failures()) {
                array_push($emailFailedListArr, $user->email);
            } else {
                array_push($emailPassListArr, $user->email);
            }
        }

        if (Mail::failures()) {
            $emailAddrs = implode(",", $emailFailedListArr);
            $log->critical('Reset Email reminder: ' . $emailAddrs . ' send failed.', []);
            dd('Reset Email reminder: ' . $emailAddrs . ' send failed.');
        } else {
            $emailAddrs = implode(",", $emailPassListArr);
            $log->critical('Reset Email reminder: ' . $emailAddrs . ' send successfully.', []);
            dd('Reset Email reminder: ' . $emailAddrs . ' send successfully.');
        }
    }
}
