<?php

namespace App;

use Arr;
use Illuminate\Support\Facades\URL;

trait Authorizable
{
    private $abilities = [
        'index' => 'view',
        'edit' => 'edit',
        'show' => 'view',
        'update' => 'edit',
        'create' => 'add',
        'store' => 'add',
        'destroy' => 'delete',

        'game_user' => 'view',
        'game_log' => 'view',
        'api_trigger_points' => 'view',
        'order_log' => 'view'
    ];

    /**
     * Override of callAction to perform the authorization before
     *
     * @param $method
     * @param $parameters
     * @return mixed
     */
    public function callAction($method, $parameters)
    {
        if ($ability = $this->getAbility($method)) {
            $this->authorize($ability);
        }

        return parent::callAction($method, $parameters);
    }

    public function getAbility($method)
    {
        $routeName = explode('.', \Request::route()->getName());
        $action = Arr::get($this->getAbilities(), $method);

        switch ($routeName[0]) {
            case "sms-data":
            case "my-invoices":
            case "retailer":
                $route_name = "data";
                break;
            case "api_trigger_points":
                $route_name = "api";
                break;
            case "orderlog":
            case "orderlog_list":
            case "invoice_log":
                $route_name = "logs";
                break;
            default:
                if (
                    $routeName[0] == 'user-creation' and
                    ($routeName[1] == 'edit' or $routeName[1] == 'update')
                ) {
                    //IF these two permissions found can click the edit page
                    if (auth()->user()->can('edit user-creation') == true) {
                        $route_name = $routeName[0];
                    } else if (auth()->user()->can('edit user-creation-role')) {
                        $route_name = 'user-creation-role';
                    } else {
                        $route_name = 'user-creation';
                    }
                } else {
                    //default behaviour
                    $route_name = $routeName[0];
                }
                break;
        }

        return $action ? $action . ' ' . $route_name : null;
    }

    private function getAbilities()
    {
        return $this->abilities;
    }

    public function setAbilities($abilities)
    {
        $this->abilities = $abilities;
    }
}
