<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:api');

Route::post('list-export-response-xml', ['as' => 'response.list_export_response_xml', 'uses' => 'ResponseQueueController@list_export_response_xml']);
Route::post('response/content', ['as' => 'response.content', 'uses' => 'ResponseQueueController@content']);

//Gameplay 2022

// Jigsaw game
Route::get('gameplay2022/locale', ['as' => 'gameplay.locale', 'uses' => 'Game2022Controller@get_locale']);
Route::post('gameplay2022/init', ['as' => 'gameplay.init', 'uses' => 'Game2022Controller@init']);
Route::put('gameplay2022/start/{id}', ['as' => 'gameplay.start', 'uses' => 'Game2022Controller@start']);
Route::put('gameplay2022/completed/{id}', ['as' => 'gameplay.start', 'uses' => 'Game2022Controller@completed']);
Route::put('gameplay2022/replay/{id}', ['as' => 'gameplay.replay', 'uses' => 'Game2022Controller@replay']);
Route::get('gameplay2022/export', ['as' => 'gameplay.export', 'uses' => 'Game2022Controller@export']);

// Match Game 
Route::get('match-gameplay2022/locale', ['as' => 'match2022.locale', 'uses' => 'GameMatch2022Controller@get_locale']);
Route::post('match-gameplay2022/init', ['as' => 'match2022.init', 'uses' => 'GameMatch2022Controller@init']);
Route::put('match-gameplay2022/start/{id}', ['as' => 'match2022.start', 'uses' => 'GameMatch2022Controller@start']);
Route::put('match-gameplay2022/completed/{id}', ['as' => 'match2022.start', 'uses' => 'GameMatch2022Controller@completed']);
Route::put('match-gameplay2022/replay/{id}', ['as' => 'match2022.replay', 'uses' => 'GameMatch2022Controller@replay']);
Route::get('match-gameplay2022/export', ['as' => 'match2022.export', 'uses' => 'GameMatch2022Controller@export']);

// test
//Route::post('import-gt', ['as' => 'gt.import', 'uses' => 'GtController@import']);

// dashboards
Route::get('loyalty-dashboard', ['as' => 'dashboard2022.loyalty_dashboard', 'uses' => 'Dashboard2022@loyalty_dashboard']);
Route::get('program-dashboard', ['as' => 'dashboard2022.program_dashboard', 'uses' => 'Dashboard2022@program_dashboard']);
Route::get('ka-focus-program-dashboard', ['as' => 'dashboard2022.focus_dashboard', 'uses' => 'Dashboard2022@focus_dashboard']);
Route::get('lead-history-dashboard', ['as' => 'dashboard2022.lead_history', 'uses' => 'Dashboard2022@lead_history']);
Route::get('gt-past-incentive', ['as' => 'dashboard2022.gt_past_incentive', 'uses' => 'Dashboard2022@gt_past_incentive']);

// import file
Route::get('download-gt-files/{file_id}', ['as' => 'gt.gt-files', 'uses' => 'GtController@download_gt_file']);
Route::get('download-ka-files/{file_id}', ['as' => 'ka.ka-files', 'uses' => 'KaController@download_ka_file']);
Route::get('download-lead-history-files/{file_id}', ['as' => 'lead.lead-history-files', 'uses' => 'LeadReportController@download_lead_file']);
Route::get('download-gt-past-incentive-files/{file_id}', ['as' => 'gt-past.gt-past-files', 'uses' => 'GtPastIncentiveController@download_gt_past_file']);

Route::get('test-imap', ['as' => 'gt.imap', 'uses' => 'GtController@imap']);

//Photo Feedback
Route::get('download-pf-files/{file_id}', ['as' => 'pf.pf-files', 'uses' => 'PfController@download_pf_file']);
Route::get('photo-feedback', ['as' => 'photo-feedback.init', 'uses' => 'PhotoFeedbackTasksController@show']);
Route::post('photo-feedback/validation', ['as' => 'photo-feedback.validation', 'uses' => 'PhotoFeedbackSubmissionsController@validation']);
Route::post('photo-feedback/submission', ['as' => 'photo-feedback.submission', 'uses' => 'PhotoFeedbackSubmissionsController@submission']);
Route::post('photo-feedback/approved/{id}', ['as' => 'photo-feedback.approved', 'uses' => 'PhotoFeedbackSubmissionsController@approved']);
Route::get('photo-feedback/init', ['as' => 'photo-feedback.init', 'uses' => 'PhotoFeedbackSubmissionsController@init']);

Route::get('photo-feedback/delete', ['as' => 'photo-feedback.deleted', 'uses' => 'PhotoFeedbackSubmissionsController@deleteSubmission']);
Route::get('photo-feedback-task/store-task', ['as' => 'photo-feedback.store_task', 'uses' => 'PhotoFeedbackTasksController@store_task']);
Route::get('photo-feedback/iframe', ['as' => 'photo-feedback.init', 'uses' => 'PhotoFeedbackSubmissionsController@iframe']);
Route::get('photo-feedback/iframe-gpric', ['as' => 'photo-feedback.iframe_gpric', 'uses' => 'PhotoFeedbackSubmissionsController@iframe_gpric']);
Route::get('photo-feedback/test-sms-static', ['as' => 'photo-feedback.test', 'uses' => 'PhotoFeedbackSubmissionsController@test_static']);
Route::get('photo-feedback/test-sms-dynamic', ['as' => 'photo-feedback.test', 'uses' => 'PhotoFeedbackSubmissionsController@test_dynamic']);
Route::get('photo-feedback/test-import', ['as' => 'photo-feedback.test-import', 'uses' => 'PhotoFeedbackSubmissionsController@testImport']);
Route::get('photo-feedback/invoice-export', ['as' => 'photo-feedback.invoice-export', 'uses' => 'PhotoFeedbackSubmissionsController@invoiceDownload']);
Route::get('photo-feedback/export', ['as' => 'photo-feedback.export', 'uses' => 'PhotoFeedbackSubmissionsController@exportSubmission']);
