@extends('layouts.master')



@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    Sticker Submission &nbsp;&nbsp;
                    <span id="status-badge" class="badge"></span>
                    @if ($data->status === 1)
                    <span id="approve-badge" class="badge badge-success">Approved</span>
                    @elseif ($data->status === 0)
                    <span id="approve-badge" class="badge badge-danger">Reject</span>
                    @endif
                </div>

                @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="fa-ul">
                        @foreach ($errors->all() as $error)
                        <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif

                {{ Form::model($data, array('url' => array('faulty-dispenser', $data->id), 'method' => 'PUT')) }}
                <div class="col-md-12" style="margin:10px 0;">
                    <a href="{{ url('/photo-feedback/submissions') }}" class="btn btn-default">Back</a>
                </div>


                <div class="panel-body fd-form">

                    <div class="form-group">
                        <label for="code_a">Code A - Batch</label>
                        <input type="text" name="code_a" class="form-control" id="code-a" value="{{ $data['Code_A_Batch'] }}" readonly>
                    </div>

                    <div class="form-group">
                        <label for="code_b">Code B - Batch</label>
                        <input type="text" name="code_b" class="form-control" id="code-b" value="{{ $data['Code_B_Sticker'] }}" readonly>
                    </div>

                    <div class="form-group">
                        <label for="code_c">Code C - SKU</label>
                        <input type="text" name="code_c" class="form-control" id="code-c" value="{{ $data['Code_C_SKU'] }}" readonly>
                    </div>

                    <div class="form-group">
                        <label for="cust_id">Contact ID</label>
                        <input type="text" name="cust_id" class="form-control" id="cust-id" value="{{ $data->cust_id }}" readonly>
                    </div>

                    <div class="form-group">
                        <label for="contact-no">Contact No</label>
                        <input type="text" name="contact_no" class="form-control" id="contact-no" value="{{ $data->contact_no }}" readonly>
                    </div>

                    @if ($data->checked_by)

                    <div class="form-group approved-info">
                        <label for="approved-by">Approved By</label>
                        <input type="text" name="checked_by" class="form-control" id="approved-by" value="{{ $data->checked_by }}" readonly>
                    </div>

                    @endif

                    @if ($data->checked_datetime)

                    <div class="form-group approved-info">
                        <label for="approved-datetime">Approved Date</label>
                        <input type="text" name="checked_datetime" class="form-control" id="approved-datetime" value="{{ $data->checked_datetime }}" readonly>
                    </div>

                    @endif

                    <div class="form-group">
                        <div>
                            <label for="images">Images</label>
                        </div>
                        @if (!empty($data->imgs))
                        @foreach(json_decode($data->imgs) as $img)
                        <a class='view-img' data-toggle="modal" data-target='#viewModal'>
                            <!-- <img src="{{ url('imgs/faulty-dispenser/'.$data->case_id.'/'.$img) }}" class="dispenser-img" /> -->
                            <img src="{{ url($img) }}" class="dispenser-img" />
                        </a>
                        @endforeach
                        @else
                        <p>NA</p>
                        @endif
                    </div>

                    @if ($data->error_msg)
                    <div class="form-group">
                        <label for="error-msg">Rejection Message</label>
                        @foreach($error_msg_opt as $kv => $vl)
                        @if ($kv === $data->error_msg)
                        <input type="text" name="error_msg_field" class="form-control" id="error-msg-field" value="{{ $vl }}" readonly>
                        @endif
                        @endforeach
                    </div>
                    @endif

                    <div class="form-group">
                        <ul class="list-group">


                            <li class="list-group-item">
                                <!-- {{ Form::submit('Update Status', array('id' => 'submit-btn', 'class' => 'btn btn-default')) }} -->
                                <a class="btn btn-success btn-approve" data-toggle='modal' data-target='#approveModal'>APPROVED</a>
                                <a class="btn btn-danger btn-disapprove" data-toggle='modal' data-target='#disapproveModal'>REJECT</a>
                                <span id="end-notification">Event Closed (2 Aug 2021)</span>
                            </li>

                        </ul>
                    </div>


                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>

<!-- Image modal -->
<div class="modal fade" id="viewModal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div id="modal-body" class="modal-xml modal-body"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="approveModal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Approve?</h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Are you sure?</p>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-approve" class="btn btn-default btn-approve" data-id="{{$data->id}}" data-status="1" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>

        </div>

    </div>
</div>

<div class="modal fade" id="disapproveModal" role="dialog">
    <div class="modal-dialog">

        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Disapprove?</h4>
            </div>
            <div id="modal-body" class="modal-body">
                <p>Are you sure? Rejection SMS will be sent to the retailer. Please select one of the relevant rejection messages to be displayed below the DTE platform SNAP banner.</p>
                <select name="error-msg" id="error-msg" class="form-control">
                    <!--<option selected disabled>Please select</option>-->
                    @foreach($error_msg_opt as $kv => $vl)
                    <option value="{{ $kv }}">{{ $vl }}</option>
                    @endforeach
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" id="btn-disapprove" class="btn btn-default btn-disapprove" data-id="{{$data->id}}" data-status="0" class="btn btn-danger" data-dismiss="modal">Confirm</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>

        </div>

    </div>
</div>

<style>
    .dispenser-img {
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 5px;
        width: 200px;
    }

    img:hover {
        opacity: 0.5;
        cursor: pointer;
    }

    #modal-body img {
        width: 100%;
    }

    #end-notification {
        display: none;
        margin-left: 20px;
        color: red;
    }
</style>

@endsection

@section('footer_script')
<script src="{{ asset('vendor/unisharp/laravel-ckeditor/ckeditor.js') }}"></script>
<script>
    var userId = "{{$userId}}";
    var flagStatus = "{{$status}}";
    var disableApproveBtn = "{{$disableApproveBtn}}";

    $(function() {

        // if (disableApproveBtn == true) {
        //     $("#btn-approve").css({
        //         "pointer-events": "none",
        //         "cursor": "default",
        //         "opacity": "0.5"
        //     });
        //     $("#end-notification").show();
        // }

        if ($("#approve-badge, #disapprove-badge").length > 0) {
            $(".btn-approve, .btn-disapprove").css({
                "pointer-events": "none",
                "cursor": "default",
                "opacity": "0.5"
            });
        }

        // switch (parseInt(flagStatus)) {
        //     case 0:
        //     case 1:
        //         $("#btn-approve, #btn-disapprove").css({
        //             "pointer-events": "none",
        //             "cursor": "default",
        //             "opacity": "0.5"
        //         });
        //         break;
        // }

        $('#submit-btn').on('click', function(e) {
            if (!confirm('Are you sure approved this submission?')) {
                e.preventDefault();
            }
        });

        $(".view-img").click(function() {
            var src = $(this).find('img').attr('src');
            $("#viewModal #modal-body").html("<img src='" + src + "' />");
        })

        $("#btn-approve, #btn-disapprove").click(function() {
            //if (confirm('Are you sure? SMS will send to this retailers user.')) {
            var id = $(this).data("id");
            var status = $(this).data("status");

            if ($(this).attr('id') == 'btn-disapprove') {
                var postData = {
                    csrf_token: "{{ csrf_token() }}",
                    user_id: userId,
                    status: status,
                    error_msg: $("#error-msg option:selected").val()
                };
            } else {
                var postData = {
                    csrf_token: "{{ csrf_token() }}",
                    user_id: userId,
                    status: status
                };
            }

            $.ajax({
                url: "{{url('api/photo-feedback/approved')}}" + "/" + id,
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: postData,
                success: function(result) {
                    console.log(result);
                    if (result.success) {
                        alert(result.message);
                        location.reload();
                    } else {
                        console.log(result);
                        alert(result.message + "!");
                    }
                },
                error: function(xhr, status, error) {
                    alert(xhr.status + " error. ");
                }
            });
            //}
        })
    });
</script>
@endsection