
@extends('layouts.master')



@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Edit Permission</div>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="fa-ul">
                            @foreach ($errors->all() as $error)
                                <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                {{ Form::model($permission, array('url' => array('permissions', $permission->id), 'method' => 'PUT')) }}
                <div class="col-md-12" style="margin:10px 0;">
                    {{ Form::submit('Save', array('class' => 'btn btn-default')) }}
                    <a href="{{ URL::previous() }}" class="btn btn-default">Back</a>
                </div>
  

                <div class="panel-body">

                    <div class="form-group">
                        <label for="title">Title</label>
                        <input type="text" name="name" class="form-control" id="name"  value="{{ $permission->name }}">
                    </div>

                    {{--
                    <div class="form-group">
                        <label for="content">Status</label>
                        <select name="status" class="form-control">
                            @foreach($status as $s => $vl)
                                @if ($permission->status == $s)
                                    <option selected value="{{ $s }}">{{ $vl }}</option>
                                @else
                                    <option value="{{ $s }}">{{ $vl }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    --}}

                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection
