@extends('layouts.master')

@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Permission Groups

                    @foreach (['danger', 'warning', 'success', 'info'] as $key)
                    @if(Session::has($key))
                    <p class="alert alert-{{ $key }} alert-msg"><i class="fa fa-check" aria-hidden="true"></i>&nbsp;{{ Session::get($key) }}</p>
                    @endif
                    @endforeach
                </div>

                @can('add permissions')
                <div class="col-md-12" style="margin:10px 0;">
                    <a href="{{ route('permission-groups.create') }}" class="btn btn-default"><i class="glyphicon glyphicon-plus"></i> Create</a>
                    <!--<button type="button" id="deleteDocBtn" class="float-right btn btn-default" data-toggle="modal" data-target="#deleteModal" disabled><i class="fa fa-trash" aria-hidden="true"></i></button>-->
                </div>
                @endcan

                <div class="panel-body">

                    <table id="permission-tbl" class="display table-bordered dt-responsive">
                        <thead>
                            <tr>
                                <th>Permission Description</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>

                    <table id="filter-temp-tbl">
                        <thead>
                            <tr></tr>
                        </thead>
                    </table>
        
                </div>
            </div>
        </div>
    </div>
</div>

<div class="spinner-border" style="width: 3rem; height: 3rem;" role="status">
  <span class="sr-only">Loading...</span>
</div>

@endsection

@section('footer_script')
<script type="text/javascript">
    $(document).ready(function() {

        $("#accordion").accordion({
            collapsible: true,
            active: false
        });

        $('#permission-tbl tr').clone(true).appendTo('#filter-temp-tbl thead');
        $('#filter-temp-tbl thead tr:eq(1) th').each(function(i) {
            var title = $(this).text();
            $(this).html('<input type="text" placeholder="Search ' + title + '" />');

            $('input', this).on('keyup change', function() {
                if (permission_tbl.column(i).search() !== this.value) {
                    permission_tbl
                        .column(i)
                        .search(this.value)
                        .draw();
                }
            });
        });

        /*
        $.ajax({
			method: "GET",
			url: base_url + '/orderlog-list'
		}).done(function(data) {

			if (data.success){
                $("#log-download-link").attr("href", data.log_path);
                $("#log-name").html(data.log_name);
                $("#log-container").html(data.log_content);
            }
        }).fail(function() {
        
        });
        */

        var permission_tbl = $('#permission-tbl').DataTable({
            serverSide: true,
            processing: true,
            bStateSave: true,
            responsive: true,
            autoWidth: false,
            columnDefs: [{
                "targets": [0, 1],
                "orderable": false
            }],
            ajax: {
                url: "{{ route('permission-groups.index') }}",
                //type: 'GET',
            },
            language: {
                paginate: {
                    next: '>', // or '→'
                    previous: '<' // or '←' 
                }
            },
            // dom:'<lf<t>ip>',
            columns: [
                //{ data: 'id', name: 'id' },
                {
                    data: 'description',
                    name: 'description'
                },
                {
                    data: 'action',
                    name: 'action'
                }

            ],
            fnDrawCallback: function(oSettings) {
                //bindDelete();
            }
        });

        $('#filter-temp-tbl th input[type=text]').addClass('form-control input-sm').css({
            "width": "100%"
        });
        $('#filter-temp-tbl th:nth-of-type(2) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-1');
        $('#filter-temp-tbl th:nth-of-type(3) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-1');
        $('#filter-temp-tbl th:nth-of-type(5) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-2');
        $('#filter-temp-tbl th:nth-of-type(8) > input[type=text]').clone(true).appendTo('#filter-container .filter-col-2');
        $('#filter-container').css({
            'height': '100%'
        });
        $('#filter-temp-tbl thead tr:nth-of-type(2)').css({
            'display': 'none'
        });
        //new $.fn.dataTable.FixedHeader( sms_tbl );
    });
</script>
@endsection