
@extends('layouts.master')



@section('content')

<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">Edit Permission Group</div>
                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="fa-ul">
                            @foreach ($errors->all() as $error)
                                <li><i class="fa-li fa fa-exclamation-triangle"></i>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                
                {{ Form::model($permission_group, array('url' => array('permission-groups', $permission_group->id), 'method' => 'PUT')) }}
                <div class="col-md-12" style="margin:10px 0;">
                    {{ Form::submit('Save', array('class' => 'btn btn-default')) }}
                    <a href="{{ URL::previous() }}" class="btn btn-default">Back</a>
                </div>
  

                <div class="panel-body">

                    <div class="form-group">
                        <label for="title">Permission Group Name</label>
                        <input type="text" name="description" class="form-control" id="description"  value="{{ $permission_group->description }}">
                    </div>

                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>
@endsection
